/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.authorization.AccessPolicy;
import org.apache.nifi.authorization.AccessPolicyMapper;
import org.apache.nifi.authorization.AccessPolicyProviderInitializationContext;
import org.apache.nifi.authorization.AuthorizationsHolder;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.ConfigurableAccessPolicyProvider;
import org.apache.nifi.authorization.ConfigurableUserGroupProvider;
import org.apache.nifi.authorization.FileAccessPolicyMapper;
import org.apache.nifi.authorization.FingerprintAccessPolicyMapper;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.RequestAction;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.authorization.UserGroupProviderLookup;
import org.apache.nifi.authorization.annotation.AuthorizerContext;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.authorization.exception.UninheritableAuthorizationsException;
import org.apache.nifi.authorization.resource.ResourceType;
import org.apache.nifi.authorization.util.IdentityMappingUtil;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.util.FlowInfo;
import org.apache.nifi.util.FlowParser;
import org.apache.nifi.util.NiFiProperties;
import org.apache.nifi.util.file.FileUtils;
import org.apache.nifi.xml.processing.ProcessingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileAccessPolicyProvider
implements ConfigurableAccessPolicyProvider {
    private static final Logger logger = LoggerFactory.getLogger(FileAccessPolicyProvider.class);
    static final String PROP_NODE_IDENTITY_PREFIX = "Node Identity ";
    static final String PROP_NODE_GROUP_NAME = "Node Group";
    static final String PROP_USER_GROUP_PROVIDER = "User Group Provider";
    static final String PROP_AUTHORIZATIONS_FILE = "Authorizations File";
    static final String PROP_INITIAL_ADMIN_IDENTITY = "Initial Admin Identity";
    static final String PROP_INITIAL_ADMIN_GROUP = "Initial Admin Group";
    static final Pattern NODE_IDENTITY_PATTERN = Pattern.compile("Node Identity \\S+");
    private NiFiProperties properties;
    private File authorizationsFile;
    private File restoreAuthorizationsFile;
    private String rootGroupId;
    private String initialAdminIdentity;
    private String initialAdminGroup;
    private Set<String> nodeIdentities;
    private String nodeGroupIdentifier;
    private UserGroupProvider userGroupProvider;
    private UserGroupProviderLookup userGroupProviderLookup;
    private final AtomicReference<AuthorizationsHolder> authorizationsHolder = new AtomicReference();
    private final AccessPolicyMapper fileAccessPolicyMapper = new FileAccessPolicyMapper();
    private final AccessPolicyMapper fingerprintAccessPolicyMapper = new FingerprintAccessPolicyMapper();

    public void initialize(AccessPolicyProviderInitializationContext initializationContext) throws AuthorizerCreationException {
        this.userGroupProviderLookup = initializationContext.getUserGroupProviderLookup();
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
        try {
            PropertyValue userGroupProviderIdentifier = configurationContext.getProperty(PROP_USER_GROUP_PROVIDER);
            if (!userGroupProviderIdentifier.isSet()) {
                throw new AuthorizerCreationException("The user group provider must be specified.");
            }
            this.userGroupProvider = this.userGroupProviderLookup.getUserGroupProvider(userGroupProviderIdentifier.getValue());
            if (this.userGroupProvider == null) {
                throw new AuthorizerCreationException("Unable to locate user group provider with identifier " + userGroupProviderIdentifier.getValue());
            }
            PropertyValue authorizationsPath = configurationContext.getProperty(PROP_AUTHORIZATIONS_FILE);
            if (StringUtils.isBlank((CharSequence)authorizationsPath.getValue())) {
                throw new AuthorizerCreationException("The authorizations file must be specified.");
            }
            this.authorizationsFile = new File(authorizationsPath.getValue());
            if (!this.authorizationsFile.exists()) {
                logger.info("Creating new authorizations file at {}", (Object)this.authorizationsFile.getAbsolutePath());
                this.saveAuthorizations(new ArrayList<AccessPolicy>(), this.authorizationsFile);
            }
            File authorizationsFileDirectory = this.authorizationsFile.getAbsoluteFile().getParentFile();
            File restoreDirectory = this.properties.getRestoreDirectory();
            if (restoreDirectory != null) {
                FileUtils.ensureDirectoryExistAndCanAccess((File)restoreDirectory);
                if (authorizationsFileDirectory.getAbsolutePath().equals(restoreDirectory.getAbsolutePath())) {
                    throw new AuthorizerCreationException(String.format("Authorizations file directory '%s' is the same as restore directory '%s' ", authorizationsFileDirectory.getAbsolutePath(), restoreDirectory.getAbsolutePath()));
                }
                this.restoreAuthorizationsFile = new File(restoreDirectory, this.authorizationsFile.getName());
                try {
                    FileUtils.syncWithRestore((File)this.authorizationsFile, (File)this.restoreAuthorizationsFile, (Logger)logger);
                }
                catch (IOException | IllegalStateException ioe) {
                    throw new AuthorizerCreationException((Throwable)ioe);
                }
            }
            List identityMappings = Collections.unmodifiableList(IdentityMappingUtil.getIdentityMappings((NiFiProperties)this.properties));
            PropertyValue initialAdminIdentityProp = configurationContext.getProperty(PROP_INITIAL_ADMIN_IDENTITY);
            this.initialAdminIdentity = initialAdminIdentityProp.isSet() ? IdentityMappingUtil.mapIdentity((String)initialAdminIdentityProp.getValue(), identityMappings) : null;
            PropertyValue initialAdminGroupProp = configurationContext.getProperty(PROP_INITIAL_ADMIN_GROUP);
            this.initialAdminGroup = initialAdminGroupProp.isSet() ? IdentityMappingUtil.mapIdentity((String)initialAdminGroupProp.getValue(), identityMappings) : null;
            this.nodeIdentities = new HashSet<String>();
            for (Map.Entry entry : configurationContext.getProperties().entrySet()) {
                Matcher matcher = NODE_IDENTITY_PATTERN.matcher((CharSequence)entry.getKey());
                if (!matcher.matches() || StringUtils.isBlank((CharSequence)((CharSequence)entry.getValue()))) continue;
                String mappedNodeIdentity = IdentityMappingUtil.mapIdentity((String)((String)entry.getValue()), identityMappings);
                this.nodeIdentities.add(mappedNodeIdentity);
                logger.info("Added mapped node {} (raw node identity {})", (Object)mappedNodeIdentity, entry.getValue());
            }
            PropertyValue nodeGroupNameProp = configurationContext.getProperty(PROP_NODE_GROUP_NAME);
            String nodeGroupName = nodeGroupNameProp != null && nodeGroupNameProp.isSet() ? nodeGroupNameProp.getValue() : null;
            this.nodeGroupIdentifier = null;
            if (nodeGroupName != null) {
                if (!StringUtils.isBlank((CharSequence)nodeGroupName)) {
                    logger.debug("Trying to load node group '{}' from the underlying userGroupProvider", (Object)nodeGroupName);
                    for (Group group : this.userGroupProvider.getGroups()) {
                        if (!group.getName().equals(nodeGroupName)) continue;
                        this.nodeGroupIdentifier = group.getIdentifier();
                        break;
                    }
                    if (this.nodeGroupIdentifier == null) {
                        throw new AuthorizerCreationException(String.format("Authorizations node group '%s' could not be found", nodeGroupName));
                    }
                } else {
                    logger.debug("Empty node group name provided");
                }
            }
            this.load();
            if (this.restoreAuthorizationsFile != null) {
                FileUtils.copyFile((File)this.authorizationsFile, (File)this.restoreAuthorizationsFile, (boolean)false, (boolean)false, (Logger)logger);
            }
            logger.debug("Authorizations file loaded");
        }
        catch (IOException | IllegalStateException | AuthorizerCreationException e) {
            throw new AuthorizerCreationException(e);
        }
    }

    public UserGroupProvider getUserGroupProvider() {
        return this.userGroupProvider;
    }

    public Set<AccessPolicy> getAccessPolicies() throws AuthorizationAccessException {
        return this.authorizationsHolder.get().getAllPolicies();
    }

    public synchronized AccessPolicy addAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        this.addAccessPolicies(Collections.singletonList(accessPolicy));
        return this.authorizationsHolder.get().getPoliciesById().get(accessPolicy.getIdentifier());
    }

    private synchronized void addAccessPolicies(List<AccessPolicy> accessPolicies) throws AuthorizationAccessException {
        if (accessPolicies == null) {
            throw new IllegalArgumentException("AccessPolicies cannot be null");
        }
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        List<AccessPolicy> currentPolicies = holder.getPolicies();
        currentPolicies.addAll(accessPolicies);
        this.saveAndRefreshHolder(currentPolicies);
    }

    public synchronized void purgePolicies(boolean save) {
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        List<AccessPolicy> currentPolicies = holder.getPolicies();
        currentPolicies.clear();
        if (save) {
            this.saveAndRefreshHolder(currentPolicies);
        }
    }

    public void backupPolicies() {
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        List<AccessPolicy> policies = holder.getPolicies();
        String timestamp = DateTimeFormatter.ofPattern("yyyy-MM-dd-HH-mm-ss").format(OffsetDateTime.now());
        File backupFile = new File(this.authorizationsFile.getParentFile(), this.authorizationsFile.getName() + "." + timestamp);
        logger.info("Writing backup of Policies to {}", (Object)backupFile.getAbsolutePath());
        this.saveAuthorizations(policies, backupFile);
    }

    public AccessPolicy getAccessPolicy(String identifier) throws AuthorizationAccessException {
        if (identifier == null) {
            return null;
        }
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        return holder.getPoliciesById().get(identifier);
    }

    public AccessPolicy getAccessPolicy(String resourceIdentifier, RequestAction action) throws AuthorizationAccessException {
        return this.authorizationsHolder.get().getAccessPolicy(resourceIdentifier, action);
    }

    public synchronized AccessPolicy updateAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        Objects.requireNonNull(accessPolicy, "Access Policy required");
        ArrayList<AccessPolicy> updatedPolicies = new ArrayList<AccessPolicy>();
        AccessPolicy updatedPolicy = null;
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        for (AccessPolicy currentPolicy : holder.getPolicies()) {
            if (currentPolicy.getIdentifier().equals(accessPolicy.getIdentifier())) {
                updatedPolicy = new AccessPolicy.Builder().identifier(currentPolicy.getIdentifier()).resource(currentPolicy.getResource()).action(currentPolicy.getAction()).addUsers(accessPolicy.getUsers()).addGroups(accessPolicy.getGroups()).build();
                updatedPolicies.add(updatedPolicy);
                continue;
            }
            updatedPolicies.add(currentPolicy);
        }
        if (updatedPolicy != null) {
            this.saveAndRefreshHolder(updatedPolicies);
        }
        return updatedPolicy;
    }

    public synchronized AccessPolicy deleteAccessPolicy(AccessPolicy accessPolicy) throws AuthorizationAccessException {
        Objects.requireNonNull(accessPolicy, "Access Policy required");
        AuthorizationsHolder holder = this.authorizationsHolder.get();
        List<AccessPolicy> policies = holder.getPolicies();
        boolean deletedPolicy = false;
        Iterator<AccessPolicy> currentPolicies = policies.iterator();
        while (currentPolicies.hasNext()) {
            AccessPolicy policy = currentPolicies.next();
            if (!policy.getIdentifier().equals(accessPolicy.getIdentifier())) continue;
            currentPolicies.remove();
            deletedPolicy = true;
            break;
        }
        if (!deletedPolicy) {
            return null;
        }
        this.saveAndRefreshHolder(policies);
        return accessPolicy;
    }

    @AuthorizerContext
    public void setNiFiProperties(NiFiProperties properties) {
        this.properties = properties;
    }

    public synchronized void inheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        List<AccessPolicy> accessPolicies = this.parsePolicies(fingerprint);
        this.addAccessPolicies(accessPolicies);
    }

    public synchronized void forciblyInheritFingerprint(String fingerprint) throws AuthorizationAccessException {
        List<AccessPolicy> accessPolicies = this.parsePolicies(fingerprint);
        if (this.isInheritable()) {
            logger.debug("Inherited Access Policies [{}]", (Object)accessPolicies.size());
            this.addAccessPolicies(accessPolicies);
        } else {
            logger.info("Cannot directly inherit cluster's Access Policies. Will create backup of existing policies and replace with proposed policies");
            try {
                this.backupPolicies();
            }
            catch (Exception e) {
                throw new AuthorizationAccessException("Failed to backup existing policies so will not inherit any policies", (Throwable)e);
            }
            this.purgePolicies(false);
            this.addAccessPolicies(accessPolicies);
        }
    }

    public void checkInheritability(String proposedFingerprint) throws AuthorizationAccessException, UninheritableAuthorizationsException {
        if (!this.isInheritable()) {
            throw new UninheritableAuthorizationsException("Proposed fingerprint is not inheritable because the current access policies is not empty.");
        }
    }

    private boolean isInheritable() {
        return this.getAccessPolicies().isEmpty();
    }

    public String getFingerprint() throws AuthorizationAccessException {
        String string;
        ArrayList<AccessPolicy> policies = new ArrayList<AccessPolicy>(this.getAccessPolicies());
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        try {
            this.fingerprintAccessPolicyMapper.writeAccessPolicies(policies, outputStream);
            outputStream.flush();
            string = outputStream.toString(StandardCharsets.UTF_8);
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw new AuthorizationAccessException("Failed to generate fingerprint for Authorizations", (Throwable)e);
            }
        }
        outputStream.close();
        return string;
    }

    private List<AccessPolicy> parsePolicies(String fingerprint) {
        List<AccessPolicy> list;
        byte[] fingerprintBytes = fingerprint.getBytes(StandardCharsets.UTF_8);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(fingerprintBytes);
        try {
            list = this.fingerprintAccessPolicyMapper.readAccessPolicies(inputStream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    ((InputStream)inputStream).close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException | ProcessingException e) {
                throw new AuthorizationAccessException("Unable to parse fingerprint", e);
            }
        }
        ((InputStream)inputStream).close();
        return list;
    }

    private synchronized void load() throws IOException {
        boolean hasInitialAdminGroup;
        ArrayList<AccessPolicy> policies = new ArrayList<AccessPolicy>();
        try (FileInputStream inputStream = new FileInputStream(this.authorizationsFile);){
            List<AccessPolicy> accessPolicies = this.fileAccessPolicyMapper.readAccessPolicies(inputStream);
            policies.addAll(accessPolicies);
        }
        catch (ProcessingException e) {
            throw new AuthorizerCreationException("Failed to read Authorizations from [%s]".formatted(this.authorizationsFile), (Throwable)e);
        }
        AuthorizationsHolder authorizationsHolder = new AuthorizationsHolder(policies);
        boolean emptyAuthorizations = authorizationsHolder.getAllPolicies().isEmpty();
        boolean hasInitialAdminIdentity = this.initialAdminIdentity != null && !StringUtils.isBlank((CharSequence)this.initialAdminIdentity);
        boolean bl = hasInitialAdminGroup = this.initialAdminGroup != null && !StringUtils.isBlank((CharSequence)this.initialAdminGroup);
        if (emptyAuthorizations) {
            this.parseFlow();
            if (hasInitialAdminIdentity) {
                logger.info("Populating authorizations for Initial Admin [{}]", (Object)this.initialAdminIdentity);
                this.populateInitialAdmin(policies, hasInitialAdminGroup);
            }
            if (hasInitialAdminGroup) {
                logger.info("Populating authorizations for Initial Admin Group [{}]", (Object)this.initialAdminGroup);
                this.populateInitialAdminGroup(policies);
            }
            this.populateNodes(policies);
            this.saveAndRefreshHolder(policies);
        } else {
            this.authorizationsHolder.set(authorizationsHolder);
        }
    }

    private void saveAuthorizations(List<AccessPolicy> policies, File destinationFile) {
        try (FileOutputStream outputStream = new FileOutputStream(destinationFile);){
            this.fileAccessPolicyMapper.writeAccessPolicies(policies, outputStream);
        }
        catch (IOException | ProcessingException e) {
            throw new AuthorizerCreationException("Write Authorization [%s] failed".formatted(destinationFile), e);
        }
    }

    private void parseFlow() {
        FlowParser flowParser = new FlowParser();
        File flowConfigurationFile = this.properties.getFlowConfigurationFile();
        FlowInfo flowInfo = flowParser.parse(flowConfigurationFile);
        if (flowInfo != null) {
            this.rootGroupId = flowInfo.getRootGroupId();
        }
    }

    private void populateInitialAdmin(List<AccessPolicy> policies, boolean hasInitialAdminGroup) {
        UserGroupProvider userGroupProvider;
        User initialAdmin = this.userGroupProvider.getUserByIdentity(this.initialAdminIdentity);
        if (initialAdmin == null) {
            throw new AuthorizerCreationException("Unable to locate initial admin " + this.initialAdminIdentity + " to seed policies");
        }
        if (hasInitialAdminGroup && (userGroupProvider = this.userGroupProvider) instanceof ConfigurableUserGroupProvider) {
            ConfigurableUserGroupProvider configurableProvider = (ConfigurableUserGroupProvider)userGroupProvider;
            Group initialAdminGroup = this.userGroupProvider.getGroupByName(this.initialAdminGroup);
            if (initialAdminGroup == null) {
                throw new AuthorizerCreationException("Unable to locate initial admin group " + this.initialAdminGroup + " to seed policies");
            }
            if (configurableProvider.isConfigurable(initialAdminGroup)) {
                Group updatedAdminGroup = new Group.Builder(initialAdminGroup).addUser(initialAdmin.getIdentifier()).build();
                configurableProvider.updateGroup(updatedAdminGroup);
                return;
            }
        }
        this.addUserToAccessPolicy(policies, ResourceType.Flow.getValue(), initialAdmin.getIdentifier(), RequestAction.READ);
        if (this.rootGroupId != null) {
            this.addUserToAccessPolicy(policies, ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, initialAdmin.getIdentifier(), RequestAction.READ);
            this.addUserToAccessPolicy(policies, ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, initialAdmin.getIdentifier(), RequestAction.WRITE);
            this.addUserToAccessPolicy(policies, ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, initialAdmin.getIdentifier(), RequestAction.READ);
            this.addUserToAccessPolicy(policies, ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, initialAdmin.getIdentifier(), RequestAction.WRITE);
        }
        this.addUserToAccessPolicy(policies, ResourceType.RestrictedComponents.getValue(), initialAdmin.getIdentifier(), RequestAction.WRITE);
        this.addUserToAccessPolicy(policies, ResourceType.Tenant.getValue(), initialAdmin.getIdentifier(), RequestAction.READ);
        this.addUserToAccessPolicy(policies, ResourceType.Tenant.getValue(), initialAdmin.getIdentifier(), RequestAction.WRITE);
        this.addUserToAccessPolicy(policies, ResourceType.Policy.getValue(), initialAdmin.getIdentifier(), RequestAction.READ);
        this.addUserToAccessPolicy(policies, ResourceType.Policy.getValue(), initialAdmin.getIdentifier(), RequestAction.WRITE);
        this.addUserToAccessPolicy(policies, ResourceType.Controller.getValue(), initialAdmin.getIdentifier(), RequestAction.READ);
        this.addUserToAccessPolicy(policies, ResourceType.Controller.getValue(), initialAdmin.getIdentifier(), RequestAction.WRITE);
    }

    private void populateInitialAdminGroup(List<AccessPolicy> policies) {
        Group initialAdminGroup = this.userGroupProvider.getGroupByName(this.initialAdminGroup);
        if (initialAdminGroup == null) {
            throw new AuthorizerCreationException("Unable to locate initial admin group " + this.initialAdminGroup + " to seed policies");
        }
        this.addGroupToAccessPolicy(policies, ResourceType.Flow.getValue(), initialAdminGroup.getIdentifier(), RequestAction.READ);
        if (this.rootGroupId != null) {
            this.addGroupToAccessPolicy(policies, ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, initialAdminGroup.getIdentifier(), RequestAction.READ);
            this.addGroupToAccessPolicy(policies, ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, initialAdminGroup.getIdentifier(), RequestAction.WRITE);
            this.addGroupToAccessPolicy(policies, ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, initialAdminGroup.getIdentifier(), RequestAction.READ);
            this.addGroupToAccessPolicy(policies, ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, initialAdminGroup.getIdentifier(), RequestAction.WRITE);
        }
        this.addGroupToAccessPolicy(policies, ResourceType.RestrictedComponents.getValue(), initialAdminGroup.getIdentifier(), RequestAction.WRITE);
        this.addGroupToAccessPolicy(policies, ResourceType.Tenant.getValue(), initialAdminGroup.getIdentifier(), RequestAction.READ);
        this.addGroupToAccessPolicy(policies, ResourceType.Tenant.getValue(), initialAdminGroup.getIdentifier(), RequestAction.WRITE);
        this.addGroupToAccessPolicy(policies, ResourceType.Policy.getValue(), initialAdminGroup.getIdentifier(), RequestAction.READ);
        this.addGroupToAccessPolicy(policies, ResourceType.Policy.getValue(), initialAdminGroup.getIdentifier(), RequestAction.WRITE);
        this.addGroupToAccessPolicy(policies, ResourceType.Controller.getValue(), initialAdminGroup.getIdentifier(), RequestAction.READ);
        this.addGroupToAccessPolicy(policies, ResourceType.Controller.getValue(), initialAdminGroup.getIdentifier(), RequestAction.WRITE);
    }

    private void populateNodes(List<AccessPolicy> policies) {
        for (String nodeIdentity : this.nodeIdentities) {
            User node = this.userGroupProvider.getUserByIdentity(nodeIdentity);
            if (node == null) {
                throw new AuthorizerCreationException("Unable to locate node " + nodeIdentity + " to seed policies.");
            }
            logger.debug("Populating default authorizations for node '{}' ({})", (Object)node.getIdentity(), (Object)node.getIdentifier());
            this.addUserToAccessPolicy(policies, ResourceType.Proxy.getValue(), node.getIdentifier(), RequestAction.WRITE);
            this.addUserToAccessPolicy(policies, ResourceType.Controller.getValue(), node.getIdentifier(), RequestAction.READ);
            if (this.rootGroupId == null) continue;
            this.addUserToAccessPolicy(policies, ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, node.getIdentifier(), RequestAction.READ);
            this.addUserToAccessPolicy(policies, ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, node.getIdentifier(), RequestAction.WRITE);
        }
        if (this.nodeGroupIdentifier != null) {
            logger.debug("Populating default authorizations for group '{}' ({})", (Object)this.userGroupProvider.getGroup(this.nodeGroupIdentifier).getName(), (Object)this.nodeGroupIdentifier);
            this.addGroupToAccessPolicy(policies, ResourceType.Proxy.getValue(), this.nodeGroupIdentifier, RequestAction.WRITE);
            if (this.rootGroupId != null) {
                this.addGroupToAccessPolicy(policies, ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, this.nodeGroupIdentifier, RequestAction.READ);
                this.addGroupToAccessPolicy(policies, ResourceType.Data.getValue() + ResourceType.ProcessGroup.getValue() + "/" + this.rootGroupId, this.nodeGroupIdentifier, RequestAction.WRITE);
            }
        }
    }

    private void addUserToAccessPolicy(List<AccessPolicy> policies, String resource, String userIdentifier, RequestAction action) {
        ListIterator<AccessPolicy> accessPolicies = policies.listIterator();
        boolean updated = false;
        while (accessPolicies.hasNext()) {
            AccessPolicy accessPolicy = accessPolicies.next();
            if (!accessPolicy.getResource().equals(resource) || action != accessPolicy.getAction()) continue;
            accessPolicies.remove();
            AccessPolicy updatedPolicy = new AccessPolicy.Builder(accessPolicy).addUser(userIdentifier).build();
            accessPolicies.add(updatedPolicy);
            updated = true;
            break;
        }
        if (!updated) {
            String uuidSeed = resource + String.valueOf(action);
            AccessPolicy accessPolicy = new AccessPolicy.Builder().identifierGenerateFromSeed(uuidSeed).resource(resource).action(action).addUser(userIdentifier).build();
            policies.add(accessPolicy);
        }
    }

    private void addGroupToAccessPolicy(List<AccessPolicy> policies, String resource, String groupIdentifier, RequestAction action) {
        ListIterator<AccessPolicy> accessPolicies = policies.listIterator();
        boolean updated = false;
        while (accessPolicies.hasNext()) {
            AccessPolicy accessPolicy = accessPolicies.next();
            if (!accessPolicy.getResource().equals(resource) || action != accessPolicy.getAction()) continue;
            accessPolicies.remove();
            AccessPolicy updatedPolicy = new AccessPolicy.Builder(accessPolicy).addGroup(groupIdentifier).build();
            accessPolicies.add(updatedPolicy);
            updated = true;
            break;
        }
        if (!updated) {
            String uuidSeed = resource + String.valueOf(action);
            AccessPolicy accessPolicy = new AccessPolicy.Builder().identifierGenerateFromSeed(uuidSeed).resource(resource).action(action).addGroup(groupIdentifier).build();
            policies.add(accessPolicy);
        }
    }

    private synchronized void saveAndRefreshHolder(List<AccessPolicy> policies) throws AuthorizationAccessException {
        try (FileOutputStream outputStream = new FileOutputStream(this.authorizationsFile);){
            this.fileAccessPolicyMapper.writeAccessPolicies(policies, outputStream);
            this.authorizationsHolder.set(new AuthorizationsHolder(policies));
        }
        catch (IOException e) {
            throw new AuthorizationAccessException("Unable to save Authorizations to [%s]".formatted(this.authorizationsFile), (Throwable)e);
        }
    }

    public void preDestruction() throws AuthorizerDestructionException {
    }
}

