/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.evtx.parser.bxml;

import com.google.common.primitives.UnsignedInteger;
import java.io.IOException;
import org.apache.nifi.processors.evtx.parser.BinaryReader;
import org.apache.nifi.processors.evtx.parser.BxmlNodeVisitor;
import org.apache.nifi.processors.evtx.parser.ChunkHeader;
import org.apache.nifi.processors.evtx.parser.NumberUtil;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNode;
import org.apache.nifi.processors.evtx.parser.bxml.BxmlNodeWithToken;
import org.apache.nifi.processors.evtx.parser.bxml.NameStringNode;

public class OpenStartElementNode
extends BxmlNodeWithToken {
    private final int unknown;
    private final UnsignedInteger size;
    private final int stringOffset;
    private final String tagName;
    private final int tagLength;

    public OpenStartElementNode(BinaryReader binaryReader, ChunkHeader chunkHeader, BxmlNode parent) throws IOException {
        super(binaryReader, chunkHeader, parent);
        if ((this.getFlags() & 0xB) != 0) {
            throw new IOException("Invalid flag detected");
        }
        this.unknown = binaryReader.readWord();
        this.size = binaryReader.readDWord();
        this.stringOffset = NumberUtil.intValueMax(binaryReader.readDWord(), Integer.MAX_VALUE, "Invalid string offset.", new Object[0]);
        int tagLength = 11;
        if ((this.getFlags() & 4) > 0) {
            tagLength += 4;
        }
        String string = this.getChunkHeader().getString(this.stringOffset);
        if ((long)this.stringOffset > this.getOffset() - chunkHeader.getOffset()) {
            int initialPosition = binaryReader.getPosition();
            NameStringNode nameStringNode = chunkHeader.addNameStringNode(this.stringOffset, binaryReader);
            tagLength += binaryReader.getPosition() - initialPosition;
            this.tagName = nameStringNode.getString();
        } else {
            this.tagName = string;
        }
        this.tagLength = tagLength;
        this.init();
    }

    public String getTagName() {
        return this.tagName;
    }

    @Override
    protected int getHeaderLength() {
        return this.tagLength;
    }

    @Override
    protected int[] getEndTokens() {
        return new int[]{3, 4};
    }

    @Override
    public void accept(BxmlNodeVisitor bxmlNodeVisitor) throws IOException {
        bxmlNodeVisitor.visit(this);
    }
}

