/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.event.transport.netty;

import io.netty.bootstrap.AbstractBootstrap;
import io.netty.bootstrap.Bootstrap;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.UnpooledByteBufAllocator;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.socket.nio.NioDatagramChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import java.net.InetAddress;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import org.apache.nifi.event.transport.EventException;
import org.apache.nifi.event.transport.EventServer;
import org.apache.nifi.event.transport.EventServerFactory;
import org.apache.nifi.event.transport.configuration.BufferAllocator;
import org.apache.nifi.event.transport.configuration.ShutdownQuietPeriod;
import org.apache.nifi.event.transport.configuration.ShutdownTimeout;
import org.apache.nifi.event.transport.configuration.TransportProtocol;
import org.apache.nifi.event.transport.netty.EventLoopGroupFactory;
import org.apache.nifi.event.transport.netty.NettyEventServer;
import org.apache.nifi.event.transport.netty.channel.StandardChannelInitializer;
import org.apache.nifi.event.transport.netty.channel.ssl.ServerSslHandlerChannelInitializer;
import org.apache.nifi.security.util.ClientAuth;

public class NettyEventServerFactory
extends EventLoopGroupFactory
implements EventServerFactory {
    private final InetAddress address;
    private final int port;
    private final TransportProtocol protocol;
    private Supplier<List<ChannelHandler>> handlerSupplier = Collections::emptyList;
    private Integer socketReceiveBuffer;
    private Boolean socketKeepAlive;
    private SSLContext sslContext;
    private SSLParameters sslParameters;
    private ClientAuth clientAuth = ClientAuth.NONE;
    private Duration shutdownQuietPeriod = ShutdownQuietPeriod.DEFAULT.getDuration();
    private Duration shutdownTimeout = ShutdownTimeout.DEFAULT.getDuration();
    private Duration idleTimeout = null;
    private BufferAllocator bufferAllocator = BufferAllocator.POOLED;

    public NettyEventServerFactory(InetAddress address, int port, TransportProtocol protocol) {
        this.address = address;
        this.port = port;
        this.protocol = protocol;
    }

    public void setHandlerSupplier(Supplier<List<ChannelHandler>> handlerSupplier) {
        this.handlerSupplier = Objects.requireNonNull(handlerSupplier);
    }

    public void setSocketKeepAlive(Boolean socketKeepAlive) {
        this.socketKeepAlive = socketKeepAlive;
    }

    public void setSocketReceiveBuffer(Integer socketReceiveBuffer) {
        this.socketReceiveBuffer = socketReceiveBuffer;
    }

    public void setSslContext(SSLContext sslContext) {
        this.sslContext = sslContext;
    }

    public void setSslParameters(SSLParameters sslParameters) {
        this.sslParameters = sslParameters;
    }

    public void setClientAuth(ClientAuth clientAuth) {
        this.clientAuth = clientAuth;
    }

    public void setShutdownQuietPeriod(Duration quietPeriod) {
        this.shutdownQuietPeriod = quietPeriod;
    }

    public void setShutdownTimeout(Duration timeout) {
        this.shutdownTimeout = timeout;
    }

    public void setBufferAllocator(BufferAllocator bufferAllocator) {
        this.bufferAllocator = Objects.requireNonNull(bufferAllocator, "Buffer Allocator required");
    }

    public void setIdleTimeout(Duration timeout) {
        this.idleTimeout = Objects.requireNonNull(timeout, "Timeout value required");
    }

    @Override
    public EventServer getEventServer() {
        AbstractBootstrap<?, ?> bootstrap = this.getBootstrap();
        this.setChannelOptions(bootstrap);
        EventLoopGroup group = this.getEventLoopGroup();
        bootstrap.group(group);
        return this.getBoundEventServer(bootstrap, group);
    }

    private void setChannelOptions(AbstractBootstrap<?, ?> bootstrap) {
        if (this.socketReceiveBuffer != null) {
            bootstrap.option(ChannelOption.SO_RCVBUF, (Object)this.socketReceiveBuffer);
            bootstrap.option(ChannelOption.RECVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(this.socketReceiveBuffer.intValue()));
        }
        if (this.socketKeepAlive != null) {
            bootstrap.option(ChannelOption.SO_KEEPALIVE, (Object)this.socketKeepAlive);
        }
        if (BufferAllocator.UNPOOLED == this.bufferAllocator) {
            bootstrap.option(ChannelOption.ALLOCATOR, (Object)UnpooledByteBufAllocator.DEFAULT);
        }
    }

    private AbstractBootstrap<?, ?> getBootstrap() {
        if (TransportProtocol.UDP.equals((Object)this.protocol)) {
            Bootstrap bootstrap = new Bootstrap();
            bootstrap.channel(NioDatagramChannel.class);
            bootstrap.handler(this.getChannelInitializer());
            return bootstrap;
        }
        ServerBootstrap bootstrap = new ServerBootstrap();
        bootstrap.channel(NioServerSocketChannel.class);
        bootstrap.childHandler(this.getChannelInitializer());
        return bootstrap;
    }

    private ChannelInitializer<?> getChannelInitializer() {
        StandardChannelInitializer channelInitializer;
        if (this.sslContext == null) {
            channelInitializer = new StandardChannelInitializer(this.handlerSupplier);
        } else {
            SSLParameters parameters = this.sslParameters == null ? this.sslContext.getDefaultSSLParameters() : this.sslParameters;
            channelInitializer = new ServerSslHandlerChannelInitializer(this.handlerSupplier, this.sslContext, this.clientAuth, parameters);
        }
        if (this.idleTimeout != null) {
            channelInitializer.setIdleTimeout(this.idleTimeout);
        }
        return channelInitializer;
    }

    private EventServer getBoundEventServer(AbstractBootstrap<?, ?> bootstrap, EventLoopGroup group) {
        ChannelFuture bindFuture = bootstrap.bind(this.address, this.port);
        try {
            ChannelFuture channelFuture = bindFuture.syncUninterruptibly();
            return new NettyEventServer(group, channelFuture.channel(), this.shutdownQuietPeriod, this.shutdownTimeout);
        }
        catch (Exception e) {
            group.shutdownGracefully();
            throw new EventException(String.format("Channel Bind Failed [%s:%d]", this.address, this.port), e);
        }
    }
}

