/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.elasticsearch;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.elasticsearch.ElasticSearchClientService;
import org.apache.nifi.elasticsearch.ElasticsearchException;
import org.apache.nifi.elasticsearch.ElasticsearchRequestOptions;
import org.apache.nifi.elasticsearch.OperationResponse;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.elasticsearch.ElasticsearchRestProcessor;
import org.apache.nifi.util.StringUtils;

public abstract class AbstractByQueryElasticsearch
extends AbstractProcessor
implements ElasticsearchRestProcessor {
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If the \"by query\" operation fails, and a flowfile was read, it will be sent to this relationship.").build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("If the \"by query\" operation succeeds, and a flowfile was read, it will be sent to this relationship.").build();
    private static final Set<Relationship> relationships = Set.of(REL_SUCCESS, REL_FAILURE, REL_RETRY);
    static final List<PropertyDescriptor> byQueryPropertyDescriptors = List.of(QUERY_DEFINITION_STYLE, QUERY, QUERY_CLAUSE, SCRIPT, QUERY_ATTRIBUTE, INDEX, TYPE, MAX_JSON_FIELD_STRING_LENGTH, CLIENT_SERVICE);
    ObjectMapper mapper;
    private final AtomicReference<ElasticSearchClientService> clientService = new AtomicReference<Object>(null);

    abstract String getTookAttribute();

    abstract String getErrorAttribute();

    abstract OperationResponse performOperation(ElasticSearchClientService var1, String var2, String var3, String var4, ElasticsearchRequestOptions var5);

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return byQueryPropertyDescriptors;
    }

    protected PropertyDescriptor getSupportedDynamicPropertyDescriptor(String propertyDescriptorName) {
        return new PropertyDescriptor.Builder().name(propertyDescriptorName).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).dynamic(true).build();
    }

    @Override
    public boolean isIndexNotExistSuccessful() {
        return false;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.clientService.set((ElasticSearchClientService)context.getProperty(CLIENT_SERVICE).asControllerService(ElasticSearchClientService.class));
        this.mapper = this.buildObjectMapper(context);
    }

    @OnStopped
    public void onStopped() {
        this.clientService.set(null);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile input = null;
        if (context.hasIncomingConnection() && (input = session.get()) == null && context.hasNonLoopConnection()) {
            return;
        }
        try {
            String query = this.getQuery(input, context, session, this.mapper);
            String index = context.getProperty(INDEX).evaluateAttributeExpressions(input).getValue();
            String type = context.getProperty(TYPE).isSet() ? context.getProperty(TYPE).evaluateAttributeExpressions(input).getValue() : null;
            String queryAttr = context.getProperty(QUERY_ATTRIBUTE).isSet() ? context.getProperty(QUERY_ATTRIBUTE).evaluateAttributeExpressions(input).getValue() : null;
            OperationResponse or = this.performOperation(this.clientService.get(), query, index, type, new ElasticsearchRequestOptions(this.getRequestParametersFromDynamicProperties(context, input), this.getRequestHeadersFromDynamicProperties(context, input)));
            if (input == null) {
                input = session.create();
            }
            HashMap<String, String> attrs = new HashMap<String, String>();
            attrs.put(this.getTookAttribute(), String.valueOf(or.getTook()));
            if (!StringUtils.isBlank((String)queryAttr)) {
                attrs.put(queryAttr, query);
            }
            input = session.putAllAttributes(input, attrs);
            session.transfer(input, REL_SUCCESS);
        }
        catch (ElasticsearchException ese) {
            String msg = String.format("Encountered a server-side problem with Elasticsearch. %s", ese.isElastic() ? "Routing to retry." : "Routing to failure");
            this.getLogger().error(msg, (Throwable)ese);
            if (input != null) {
                session.penalize(input);
                input = session.putAttribute(input, this.getErrorAttribute(), ese.getMessage());
                session.transfer(input, ese.isElastic() ? REL_RETRY : REL_FAILURE);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error running \"by query\" operation: ", (Throwable)e);
            if (input != null) {
                input = session.putAttribute(input, this.getErrorAttribute(), e.getMessage());
                session.transfer(input, REL_FAILURE);
            }
            context.yield();
        }
    }

    @Override
    public void migrateProperties(PropertyConfiguration config) {
        ElasticsearchRestProcessor.super.migrateProperties(config);
    }
}

