/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.elasticsearch;

import java.util.Arrays;
import java.util.Map;

public class IndexOperationRequest {
    private final String index;
    private final String type;
    private final String id;
    private final Map<String, Object> fields;
    private final Operation operation;
    private final Map<String, Object> script;
    private final boolean scriptedUpsert;
    private final Map<String, Object> dynamicTemplates;
    private final Map<String, String> headerFields;

    public IndexOperationRequest(String index, String type, String id, Map<String, Object> fields, Operation operation, Map<String, Object> script, boolean scriptedUpsert, Map<String, Object> dynamicTemplates, Map<String, String> headerFields) {
        this.index = index;
        this.type = type;
        this.id = id;
        this.fields = fields;
        this.operation = operation;
        this.script = script;
        this.scriptedUpsert = scriptedUpsert;
        this.dynamicTemplates = dynamicTemplates;
        this.headerFields = headerFields;
    }

    public String getIndex() {
        return this.index;
    }

    public String getType() {
        return this.type;
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getFields() {
        return this.fields;
    }

    public Operation getOperation() {
        return this.operation;
    }

    public Map<String, Object> getScript() {
        return this.script;
    }

    public boolean isScriptedUpsert() {
        return this.scriptedUpsert;
    }

    public Map<String, Object> getDynamicTemplates() {
        return this.dynamicTemplates;
    }

    public Map<String, String> getHeaderFields() {
        return this.headerFields;
    }

    public String toString() {
        return "IndexOperationRequest{index='" + this.index + "', type='" + this.type + "', id='" + this.id + "', fields=" + String.valueOf(this.fields) + ", operation=" + String.valueOf((Object)this.operation) + ", script=" + String.valueOf(this.script) + ", scriptedUpsert=" + this.scriptedUpsert + ", dynamicTemplates=" + String.valueOf(this.dynamicTemplates) + ", headerFields=" + String.valueOf(this.headerFields) + "}";
    }

    public static enum Operation {
        Create("create"),
        Delete("delete"),
        Index("index"),
        Update("update"),
        Upsert("upsert");

        private final String value;

        private Operation(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Operation forValue(String value) {
            return Arrays.stream(Operation.values()).filter(o -> o.getValue().equalsIgnoreCase(value)).findFirst().orElseThrow(() -> new IllegalArgumentException(String.format("Unknown Index Operation %s", value)));
        }
    }
}

