/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.rules.engine;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.reporting.InitializationException;
import org.apache.nifi.rules.Action;
import org.apache.nifi.rules.ActionHandler;
import org.apache.nifi.rules.Rule;
import org.apache.nifi.rules.RulesFactory;
import org.apache.nifi.rules.RulesMVELCondition;
import org.apache.nifi.rules.RulesSPELCondition;
import org.apache.nifi.rules.engine.RulesEngineService;
import org.apache.nifi.util.StringUtils;
import org.jeasy.rules.api.Condition;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.api.RuleListener;
import org.jeasy.rules.api.Rules;
import org.jeasy.rules.core.DefaultRulesEngine;
import org.jeasy.rules.core.RuleBuilder;

@CapabilityDescription(value="Defines and execute the rules stored in NiFi or EasyRules file formats for a given set of facts. Supports rules stored as JSON or YAML file types.")
@Tags(value={"rules", "rules-engine", "engine", "actions", "facts"})
public class EasyRulesEngineService
extends AbstractControllerService
implements RulesEngineService {
    static final AllowableValue YAML = new AllowableValue("YAML", "YAML", "YAML file configuration type.");
    static final AllowableValue JSON = new AllowableValue("JSON", "JSON", "JSON file configuration type.");
    static final AllowableValue NIFI = new AllowableValue("NIFI", "NIFI", "NiFi rules formatted file.");
    static final AllowableValue MVEL = new AllowableValue("MVEL", "Easy Rules MVEL", "Easy Rules File format using MVFLEX Expression Language");
    static final AllowableValue SPEL = new AllowableValue("SPEL", "Easy Rules SpEL", "Easy Rules File format using Spring Expression Language");
    static final PropertyDescriptor RULES_FILE_PATH = new PropertyDescriptor.Builder().name("rules-file-path").displayName("Rules File Path").description("Path to location of rules file. Only one of Rules File or Rules Body may be used").required(false).addValidator(StandardValidators.FILE_EXISTS_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor RULES_BODY = new PropertyDescriptor.Builder().name("rules-body").displayName("Rules Body").description("Body of rules file to execute. Only one of Rules File or Rules Body may be used").required(false).addValidator(Validator.VALID).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).build();
    static final PropertyDescriptor RULES_FILE_TYPE = new PropertyDescriptor.Builder().name("rules-file-type").displayName("Rules File Type").description("File or Body type for rules definition. Supported types are YAML and JSON").required(true).allowableValues(new AllowableValue[]{JSON, YAML}).defaultValue(JSON.getValue()).build();
    static final PropertyDescriptor RULES_FILE_FORMAT = new PropertyDescriptor.Builder().name("rules-file-format").displayName("Rules File Format").description("Format for rules. Supported formats are NiFi Rules, Easy Rules files with MVEL Expression Language and Easy Rules files with Spring Expression Language.").required(true).allowableValues(new AllowableValue[]{NIFI, MVEL, SPEL}).defaultValue(NIFI.getValue()).build();
    static final PropertyDescriptor IGNORE_CONDITION_ERRORS = new PropertyDescriptor.Builder().name("rules-ignore-condition-errors").displayName("Ignore Condition Errors").description("When set to true, rules engine will ignore errors for any rule that encounters issues when compiling rule conditions (including syntax errors and/or missing facts). Rule will simply return as false and engine will continue with execution.").required(true).defaultValue("false").allowableValues(new String[]{"true", "false"}).build();
    protected List<PropertyDescriptor> properties;
    protected volatile List<Rule> rules;
    protected volatile String rulesFileFormat;
    private boolean ignoreConditionErrors;

    protected void init(ControllerServiceInitializationContext config) throws InitializationException {
        super.init(config);
        ArrayList<PropertyDescriptor> properties = new ArrayList<PropertyDescriptor>();
        properties.add(RULES_FILE_TYPE);
        properties.add(RULES_FILE_PATH);
        properties.add(RULES_BODY);
        properties.add(RULES_FILE_FORMAT);
        properties.add(IGNORE_CONDITION_ERRORS);
        this.properties = Collections.unmodifiableList(properties);
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) throws InitializationException {
        String rulesFile = context.getProperty(RULES_FILE_PATH).getValue();
        String rulesBody = context.getProperty(RULES_BODY).getValue();
        String rulesFileType = context.getProperty(RULES_FILE_TYPE).getValue();
        this.rulesFileFormat = context.getProperty(RULES_FILE_FORMAT).getValue();
        this.ignoreConditionErrors = context.getProperty(IGNORE_CONDITION_ERRORS).asBoolean();
        try {
            this.rules = StringUtils.isEmpty((String)rulesFile) ? RulesFactory.createRulesFromString(rulesBody, rulesFileType, this.rulesFileFormat) : RulesFactory.createRulesFromFile(rulesFile, rulesFileType, this.rulesFileFormat);
        }
        catch (Exception fex) {
            throw new InitializationException((Throwable)fex);
        }
    }

    public Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        HashSet<ValidationResult> results = new HashSet<ValidationResult>();
        Map propertyMap = validationContext.getProperties();
        if (StringUtils.isEmpty((String)((String)propertyMap.get(RULES_FILE_PATH))) == StringUtils.isEmpty((String)((String)propertyMap.get(RULES_BODY)))) {
            results.add(new ValidationResult.Builder().subject("Rules Body or Rules File").valid(false).explanation("exactly one of Rules File or Rules Body must be set").build());
        }
        return results;
    }

    public List<Action> fireRules(Map<String, Object> facts) {
        ArrayList<Action> actions = new ArrayList<Action>();
        if (this.rules == null || facts == null || facts.isEmpty()) {
            return null;
        }
        Rules easyRules = this.convertToEasyRules(this.rules, (action, eventFacts) -> actions.add(action));
        Facts easyFacts = new Facts();
        facts.forEach((arg_0, arg_1) -> ((Facts)easyFacts).put(arg_0, arg_1));
        DefaultRulesEngine rulesEngine = new DefaultRulesEngine();
        rulesEngine.registerRuleListener((RuleListener)new EasyRulesListener());
        rulesEngine.fire(easyRules, easyFacts);
        return actions;
    }

    protected Rules convertToEasyRules(List<Rule> rules, ActionHandler actionHandler) {
        Rules easyRules = new Rules(new org.jeasy.rules.api.Rule[0]);
        rules.forEach(rule -> {
            RuleBuilder ruleBuilder = new RuleBuilder();
            Object condition = this.rulesFileFormat.equalsIgnoreCase(SPEL.getValue()) ? new RulesSPELCondition(rule.getCondition(), this.ignoreConditionErrors) : new RulesMVELCondition(rule.getCondition(), this.ignoreConditionErrors);
            ruleBuilder.name(rule.getName()).description(rule.getDescription()).priority(rule.getPriority().intValue()).when((Condition)condition);
            for (Action action : rule.getActions()) {
                ruleBuilder.then(facts -> actionHandler.execute(action, facts.asMap()));
            }
            easyRules.register((Object)ruleBuilder.build());
        });
        return easyRules;
    }

    private class EasyRulesListener
    implements RuleListener {
        private EasyRulesListener() {
        }

        public boolean beforeEvaluate(org.jeasy.rules.api.Rule rule, Facts facts) {
            return true;
        }

        public void afterEvaluate(org.jeasy.rules.api.Rule rule, Facts facts, boolean b) {
        }

        public void beforeExecute(org.jeasy.rules.api.Rule rule, Facts facts) {
        }

        public void onSuccess(org.jeasy.rules.api.Rule rule, Facts facts) {
            EasyRulesEngineService.this.getLogger().debug("Rules was successfully processed for: {}", new Object[]{rule.getName()});
        }

        public void onFailure(org.jeasy.rules.api.Rule rule, Facts facts, Exception e) {
            EasyRulesEngineService.this.getLogger().warn("Rule execution failed for: {}", new Object[]{rule.getName()}, (Throwable)e);
        }
    }
}

