/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.rules;

import org.jeasy.rules.api.Condition;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.spel.SpELCondition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class RulesSPELCondition
implements Condition {
    private static final Logger LOGGER = LoggerFactory.getLogger(SpELCondition.class);
    private final ExpressionParser parser = new SpelExpressionParser();
    private String expression;
    private Expression compiledExpression;
    private boolean ignoreConditionErrors;

    public RulesSPELCondition(String expression) {
        this.expression = expression;
        this.compiledExpression = this.parser.parseExpression(expression);
    }

    public RulesSPELCondition(String expression, ParserContext parserContext) {
        this.expression = expression;
        this.compiledExpression = this.parser.parseExpression(expression, parserContext);
    }

    public RulesSPELCondition(String expression, boolean ignoreConditionErrors) {
        this.expression = expression;
        this.compiledExpression = this.parser.parseExpression(expression);
        this.ignoreConditionErrors = ignoreConditionErrors;
    }

    public RulesSPELCondition(String expression, ParserContext parserContext, boolean ignoreConditionErrors) {
        this.expression = expression;
        this.compiledExpression = this.parser.parseExpression(expression, parserContext);
        this.ignoreConditionErrors = ignoreConditionErrors;
    }

    public boolean evaluate(Facts facts) {
        try {
            StandardEvaluationContext context = new StandardEvaluationContext();
            context.setRootObject((Object)facts.asMap());
            context.setVariables(facts.asMap());
            return (Boolean)this.compiledExpression.getValue((EvaluationContext)context, Boolean.class);
        }
        catch (Exception ex) {
            if (this.ignoreConditionErrors) {
                LOGGER.debug("Unable to evaluate expression: '" + this.expression + "' on facts: " + facts, (Throwable)ex);
                return false;
            }
            throw ex;
        }
    }
}

