/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.rules;

import java.io.Serializable;
import java.util.Map;
import org.jeasy.rules.api.Condition;
import org.jeasy.rules.api.Facts;
import org.jeasy.rules.mvel.MVELCondition;
import org.mvel2.MVEL;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RulesMVELCondition
implements Condition {
    private static final Logger LOGGER = LoggerFactory.getLogger(MVELCondition.class);
    private String expression;
    private Serializable compiledExpression;
    private boolean ignoreConditionErrors;

    public RulesMVELCondition(String expression, boolean ignoreConditionErrors) {
        this.expression = expression;
        this.compiledExpression = MVEL.compileExpression((String)expression);
        this.ignoreConditionErrors = ignoreConditionErrors;
    }

    public boolean evaluate(Facts facts) {
        try {
            return (Boolean)MVEL.executeExpression((Object)this.compiledExpression, (Map)facts.asMap());
        }
        catch (Exception ex) {
            if (this.ignoreConditionErrors) {
                LOGGER.debug("Unable to evaluate expression: '" + this.expression + "' on facts: " + facts, (Throwable)ex);
                return false;
            }
            throw ex;
        }
    }
}

