/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.rules;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.nifi.rules.Action;
import org.apache.nifi.rules.Rule;
import org.jeasy.rules.support.JsonRuleDefinitionReader;
import org.jeasy.rules.support.YamlRuleDefinitionReader;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class RulesFactory {
    public static List<Rule> createRulesFromFile(String ruleFile, String ruleFileType, String rulesFileFormat) throws Exception {
        FileInputStream rulesInputStream = new FileInputStream(ruleFile);
        return RulesFactory.createRules(rulesInputStream, ruleFileType, rulesFileFormat);
    }

    public static List<Rule> createRulesFromString(String rulesBody, String ruleFileType, String rulesFileFormat) throws Exception {
        ByteArrayInputStream rulesInputStream = new ByteArrayInputStream(rulesBody.getBytes());
        return RulesFactory.createRules(rulesInputStream, ruleFileType, rulesFileFormat);
    }

    private static List<Rule> createRules(InputStream rulesInputStream, String ruleFileType, String rulesFileFormat) throws Exception {
        FileFormat fileFormat = FileFormat.valueOf(rulesFileFormat);
        switch (fileFormat) {
            case NIFI: {
                return RulesFactory.createRulesFromNiFiFormat(rulesInputStream, ruleFileType);
            }
            case MVEL: 
            case SPEL: {
                return RulesFactory.createRulesFromEasyRulesFormat(rulesInputStream, ruleFileType, rulesFileFormat);
            }
        }
        return null;
    }

    private static List<Rule> createRulesFromEasyRulesFormat(InputStream rulesInputStream, String ruleFileType, String ruleFileFormat) throws Exception {
        YamlRuleDefinitionReader reader = FileType.valueOf(ruleFileType).equals((Object)FileType.YAML) ? new YamlRuleDefinitionReader() : new JsonRuleDefinitionReader();
        List ruleDefinitions = reader.read((Reader)new InputStreamReader(rulesInputStream));
        return ruleDefinitions.stream().map(ruleDefinition -> {
            Rule rule = new Rule();
            rule.setName(ruleDefinition.getName());
            rule.setDescription(ruleDefinition.getDescription());
            rule.setPriority(Integer.valueOf(ruleDefinition.getPriority()));
            rule.setCondition(ruleDefinition.getCondition());
            List actions = ruleDefinition.getActions().stream().map(ruleAction -> {
                Action action = new Action();
                action.setType("EXPRESSION");
                HashMap<String, String> attributes = new HashMap<String, String>();
                attributes.put("command", (String)ruleAction);
                attributes.put("type", ruleFileFormat);
                action.setAttributes(attributes);
                return action;
            }).collect(Collectors.toList());
            rule.setActions(actions);
            return rule;
        }).collect(Collectors.toList());
    }

    private static List<Rule> createRulesFromNiFiFormat(InputStream rulesInputStream, String ruleFileType) throws Exception {
        FileType type = FileType.valueOf(ruleFileType.toUpperCase());
        if (type.equals((Object)FileType.YAML)) {
            return RulesFactory.yamlToRules(rulesInputStream);
        }
        if (type.equals((Object)FileType.JSON)) {
            return RulesFactory.jsonToRules(rulesInputStream);
        }
        return null;
    }

    private static List<Rule> yamlToRules(InputStream rulesInputStream) throws FileNotFoundException {
        ArrayList<Rule> rules = new ArrayList<Rule>();
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(Rule.class));
        for (Object object : yaml.loadAll(rulesInputStream)) {
            if (!(object instanceof Rule)) continue;
            rules.add((Rule)object);
        }
        return rules;
    }

    private static List<Rule> jsonToRules(InputStream rulesInputStream) throws Exception {
        InputStreamReader isr = new InputStreamReader(rulesInputStream);
        ObjectMapper objectMapper = new ObjectMapper();
        List rules = (List)objectMapper.readValue((Reader)isr, (TypeReference)new TypeReference<List<Rule>>(){});
        return rules;
    }

    static enum FileFormat {
        NIFI,
        MVEL,
        SPEL;

    }

    static enum FileType {
        YAML,
        JSON;

    }
}

