/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.couchbase;

public enum ErrorHandlingStrategy {
    ConfigurationError(Result.ProcessException, Penalty.Yield),
    InvalidInput(Result.Failure, Penalty.None),
    TemporalClusterError(Result.Retry, Penalty.Yield),
    TemporalFlowFileError(Result.Retry, Penalty.Penalize),
    Fatal(Result.Retry, Penalty.Yield);

    private final Result result;
    private final Penalty penalty;

    private ErrorHandlingStrategy(Result result, Penalty penalty) {
        this.result = result;
        this.penalty = penalty;
    }

    public Result result() {
        return this.result;
    }

    public Penalty penalty() {
        return this.penalty;
    }

    public static enum Penalty {
        Yield,
        Penalize,
        None;

    }

    public static enum Result {
        ProcessException,
        Failure,
        Retry;

    }
}

