/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cipher.age;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import org.apache.nifi.processors.cipher.age.AgeKeyIndicator;
import org.apache.nifi.processors.cipher.age.AgeKeyReader;

abstract class AbstractAgeKeyReader<T>
implements AgeKeyReader<T> {
    private final AgeKeyIndicator ageKeyIndicator;

    AbstractAgeKeyReader(AgeKeyIndicator ageKeyIndicator) {
        this.ageKeyIndicator = ageKeyIndicator;
    }

    @Override
    public List<T> read(InputStream inputStream) throws IOException {
        Objects.requireNonNull(inputStream, "Input Stream required");
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
            Set<String> keys = reader.lines().filter(line -> line.startsWith(this.ageKeyIndicator.getPrefix())).map(this.ageKeyIndicator.getPattern()::matcher).filter(Matcher::matches).map(Matcher::group).collect(Collectors.toSet());
            List<T> list = this.readKeys(keys);
            return list;
        }
    }

    protected abstract List<T> readKeys(Set<String> var1) throws IOException;
}

