/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.cipher;

import com.exceptionfactory.jagged.DecryptingChannelFactory;
import com.exceptionfactory.jagged.RecipientStanzaReader;
import com.exceptionfactory.jagged.framework.armor.ArmoredDecryptingChannelFactory;
import com.exceptionfactory.jagged.framework.stream.StandardDecryptingChannelFactory;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.channels.ReadableByteChannel;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.SupportsBatching;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.components.resource.ResourceCardinality;
import org.apache.nifi.components.resource.ResourceReference;
import org.apache.nifi.components.resource.ResourceReferences;
import org.apache.nifi.components.resource.ResourceType;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.io.StreamCallback;
import org.apache.nifi.processors.cipher.EncryptContentAge;
import org.apache.nifi.processors.cipher.age.AgeKeyIndicator;
import org.apache.nifi.processors.cipher.age.AgeKeyReader;
import org.apache.nifi.processors.cipher.age.AgeKeyValidator;
import org.apache.nifi.processors.cipher.age.AgePrivateKeyReader;
import org.apache.nifi.processors.cipher.age.AgeProviderResolver;
import org.apache.nifi.processors.cipher.age.KeySource;
import org.apache.nifi.processors.cipher.io.ChannelStreamCallback;
import org.apache.nifi.stream.io.StreamUtils;

@SupportsBatching
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"age", "age-encryption.org", "encryption", "ChaCha20-Poly1305", "X25519"})
@CapabilityDescription(value="Decrypt content using the age-encryption.org/v1 specification. Detects binary or ASCII armored content encoding using the initial file header bytes. The age standard uses ChaCha20-Poly1305 for authenticated encryption of the payload. The age-keygen command supports generating X25519 key pairs for encryption and decryption operations.")
@SeeAlso(value={EncryptContentAge.class})
public class DecryptContentAge
extends AbstractProcessor
implements VerifiableProcessor {
    static final Relationship SUCCESS = new Relationship.Builder().name("success").description("Decryption Completed").build();
    static final Relationship FAILURE = new Relationship.Builder().name("failure").description("Decryption Failed").build();
    static final PropertyDescriptor PRIVATE_KEY_SOURCE = new PropertyDescriptor.Builder().name("Private Key Source").displayName("Private Key Source").description("Source of information determines the loading strategy for X25519 Private Key Identities").required(true).defaultValue(KeySource.PROPERTIES.getValue()).allowableValues(KeySource.class).build();
    static final PropertyDescriptor PRIVATE_KEY_IDENTITIES = new PropertyDescriptor.Builder().name("Private Key Identities").displayName("Private Key Identities").description("One or more X25519 Private Key Identities, separated with newlines, encoded according to the age specification, starting with AGE-SECRET-KEY-1").required(true).sensitive(true).addValidator((Validator)new AgeKeyValidator(AgeKeyIndicator.PRIVATE_KEY)).identifiesExternalResource(ResourceCardinality.SINGLE, ResourceType.TEXT, new ResourceType[0]).dependsOn(PRIVATE_KEY_SOURCE, (DescribedValue)KeySource.PROPERTIES, new DescribedValue[0]).build();
    static final PropertyDescriptor PRIVATE_KEY_IDENTITY_RESOURCES = new PropertyDescriptor.Builder().name("Private Key Identity Resources").displayName("Private Key Identity Resources").description("One or more files or URLs containing X25519 Private Key Identities, separated with newlines, encoded according to the age specification, starting with AGE-SECRET-KEY-1").required(true).addValidator((Validator)new AgeKeyValidator(AgeKeyIndicator.PRIVATE_KEY)).identifiesExternalResource(ResourceCardinality.MULTIPLE, ResourceType.FILE, new ResourceType[]{ResourceType.URL}).dependsOn(PRIVATE_KEY_SOURCE, (DescribedValue)KeySource.RESOURCES, new DescribedValue[0]).build();
    private static final Set<Relationship> RELATIONSHIPS = new LinkedHashSet<Relationship>(Arrays.asList(SUCCESS, FAILURE));
    private static final List<PropertyDescriptor> DESCRIPTORS = Arrays.asList(PRIVATE_KEY_SOURCE, PRIVATE_KEY_IDENTITIES, PRIVATE_KEY_IDENTITY_RESOURCES);
    private static final AgeKeyReader<RecipientStanzaReader> PRIVATE_KEY_READER = new AgePrivateKeyReader();
    private static final Provider CIPHER_PROVIDER = AgeProviderResolver.getCipherProvider();
    private static final int BUFFER_CAPACITY = 65552;
    private static final String VERSION_INDICATOR = "age-encryption.org";
    private static final byte[] BINARY_VERSION_INDICATOR = "age-encryption.org".getBytes(StandardCharsets.US_ASCII);
    private static final int INPUT_BUFFER_SIZE = BINARY_VERSION_INDICATOR.length;
    private static final String KEY_VERIFICATION_STEP = "Verify Private Key Identities";
    private static final String NOT_FOUND_EXPLANATION = "Private Key Identities not found";
    private volatile List<RecipientStanzaReader> configuredRecipientStanzaReaders = Collections.emptyList();

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public final List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return DESCRIPTORS;
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        ConfigVerificationResult.Builder verificationBuilder = new ConfigVerificationResult.Builder().verificationStepName(KEY_VERIFICATION_STEP);
        try {
            List<RecipientStanzaReader> recipientStanzaReaders = this.getRecipientStanzaReaders((PropertyContext)context);
            if (recipientStanzaReaders.isEmpty()) {
                verificationLogger.warn(NOT_FOUND_EXPLANATION);
                verificationBuilder.outcome(ConfigVerificationResult.Outcome.FAILED).explanation(NOT_FOUND_EXPLANATION);
            } else {
                String explanation = String.format("Private Key Identities found: %d", recipientStanzaReaders.size());
                verificationLogger.info(explanation);
                verificationBuilder.outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).explanation(explanation);
            }
        }
        catch (Exception e) {
            String explanation = String.format("%s: %s", NOT_FOUND_EXPLANATION, e);
            verificationLogger.warn(NOT_FOUND_EXPLANATION, (Throwable)e);
            verificationBuilder.outcome(ConfigVerificationResult.Outcome.FAILED).explanation(explanation);
        }
        results.add(verificationBuilder.build());
        return results;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) throws IOException {
        this.configuredRecipientStanzaReaders = this.getRecipientStanzaReaders((PropertyContext)context);
    }

    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            DecryptingStreamCallback streamCallback = new DecryptingStreamCallback(this.configuredRecipientStanzaReaders);
            flowFile = session.write(flowFile, (StreamCallback)streamCallback);
            session.transfer(flowFile, SUCCESS);
        }
        catch (Exception e) {
            this.getLogger().error("Decryption Failed {}", new Object[]{flowFile, e});
            session.transfer(flowFile, FAILURE);
        }
    }

    private List<RecipientStanzaReader> getRecipientStanzaReaders(PropertyContext context) throws IOException {
        KeySource keySource = KeySource.valueOf(context.getProperty(PRIVATE_KEY_SOURCE).getValue());
        ArrayList<ResourceReference> resources = new ArrayList<ResourceReference>();
        if (KeySource.PROPERTIES == keySource) {
            ResourceReference resource = context.getProperty(PRIVATE_KEY_IDENTITIES).asResource();
            resources.add(resource);
        } else {
            ResourceReferences resourceReferences = context.getProperty(PRIVATE_KEY_IDENTITY_RESOURCES).asResources();
            resources.addAll(resourceReferences.asList());
        }
        ArrayList<RecipientStanzaReader> recipientStanzaReaders = new ArrayList<RecipientStanzaReader>();
        for (ResourceReference resource : resources) {
            InputStream inputStream = resource.read();
            Throwable throwable = null;
            try {
                List<RecipientStanzaReader> readers = PRIVATE_KEY_READER.read(inputStream);
                recipientStanzaReaders.addAll(readers);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (inputStream == null) continue;
                if (throwable != null) {
                    try {
                        inputStream.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                inputStream.close();
            }
        }
        if (recipientStanzaReaders.isEmpty()) {
            throw new IOException(NOT_FOUND_EXPLANATION);
        }
        return recipientStanzaReaders;
    }

    private static class DecryptingStreamCallback
    extends ChannelStreamCallback {
        private final List<RecipientStanzaReader> recipientStanzaReaders;

        private DecryptingStreamCallback(List<RecipientStanzaReader> recipientStanzaReaders) {
            super(65552);
            this.recipientStanzaReaders = recipientStanzaReaders;
        }

        @Override
        protected ReadableByteChannel getReadableChannel(InputStream inputStream) throws IOException {
            PushbackInputStream pushbackInputStream = new PushbackInputStream(inputStream, INPUT_BUFFER_SIZE);
            byte[] versionIndicator = this.getVersionIndicator(pushbackInputStream);
            DecryptingChannelFactory decryptingChannelFactory = this.getDecryptingChannelFactory(versionIndicator);
            try {
                ReadableByteChannel inputChannel = super.getReadableChannel(pushbackInputStream);
                return decryptingChannelFactory.newDecryptingChannel(inputChannel, this.recipientStanzaReaders);
            }
            catch (GeneralSecurityException e) {
                throw new IOException("Channel initialization failed", e);
            }
        }

        private byte[] getVersionIndicator(PushbackInputStream pushbackInputStream) throws IOException {
            byte[] versionIndicator = new byte[INPUT_BUFFER_SIZE];
            StreamUtils.fillBuffer((InputStream)pushbackInputStream, (byte[])versionIndicator);
            pushbackInputStream.unread(versionIndicator);
            return versionIndicator;
        }

        private DecryptingChannelFactory getDecryptingChannelFactory(byte[] versionIndicator) {
            Object decryptingChannelFactory = Arrays.equals(BINARY_VERSION_INDICATOR, versionIndicator) ? new StandardDecryptingChannelFactory(CIPHER_PROVIDER) : new ArmoredDecryptingChannelFactory(CIPHER_PROVIDER);
            return decryptingChannelFactory;
        }
    }
}

