/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.event.io;

import java.io.IOException;
import org.apache.nifi.cdc.event.io.EventWriterConfiguration;
import org.apache.nifi.cdc.mysql.event.CommitTransactionEventInfo;
import org.apache.nifi.cdc.mysql.event.io.AbstractBinlogEventWriter;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;

public class CommitTransactionEventWriter
extends AbstractBinlogEventWriter<CommitTransactionEventInfo> {
    @Override
    public long writeEvent(ProcessSession session, String transitUri, CommitTransactionEventInfo eventInfo, long currentSequenceId, Relationship relationship, EventWriterConfiguration eventWriterConfiguration) {
        long sequenceId = super.writeEvent(session, transitUri, eventInfo, currentSequenceId, relationship, eventWriterConfiguration);
        if (this.oneTransactionPerFlowFile(eventWriterConfiguration)) {
            super.finishAndTransferFlowFile(session, eventWriterConfiguration, transitUri, sequenceId, eventInfo, relationship);
        }
        return sequenceId;
    }

    @Override
    protected void writeJson(CommitTransactionEventInfo event) throws IOException {
        super.writeJson(event);
        if (event.getDatabaseName() != null) {
            this.jsonGenerator.writeStringField("database", event.getDatabaseName());
        } else {
            this.jsonGenerator.writeNullField("database");
        }
    }
}

