/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.mysql.event.handler;

import com.github.shyiko.mysql.binlog.event.EventData;
import org.apache.nifi.cdc.event.io.EventWriterConfiguration;
import org.apache.nifi.cdc.mysql.event.CommitTransactionEventInfo;
import org.apache.nifi.cdc.mysql.event.DataCaptureState;
import org.apache.nifi.cdc.mysql.event.handler.BinlogEventHandler;
import org.apache.nifi.cdc.mysql.event.io.CommitTransactionEventWriter;
import org.apache.nifi.cdc.mysql.processors.CaptureChangeMySQL;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessSession;

public class CommitEventHandler
implements BinlogEventHandler<EventData, CommitTransactionEventInfo> {
    private final CommitTransactionEventWriter eventWriter = new CommitTransactionEventWriter();

    @Override
    public void handleEvent(EventData eventData, boolean writeEvent, DataCaptureState dataCaptureState, CaptureChangeMySQL.BinlogResourceInfo binlogResourceInfo, CaptureChangeMySQL.BinlogEventState binlogEventState, String sql, EventWriterConfiguration eventWriterConfiguration, ProcessSession session, long timestamp) {
        CommitTransactionEventInfo commitEvent;
        String currentDatabase = binlogResourceInfo.getCurrentDatabase();
        CommitTransactionEventInfo commitTransactionEventInfo = commitEvent = dataCaptureState.isUseGtid() ? new CommitTransactionEventInfo(currentDatabase, timestamp, dataCaptureState.getGtidSet()) : new CommitTransactionEventInfo(currentDatabase, (Long)timestamp, dataCaptureState.getBinlogFile(), dataCaptureState.getBinlogPosition());
        if (writeEvent) {
            binlogEventState.setCurrentEventInfo(commitEvent);
            binlogEventState.setCurrentEventWriter(this.eventWriter);
            dataCaptureState.setSequenceId(this.eventWriter.writeEvent(session, binlogResourceInfo.getTransitUri(), commitEvent, dataCaptureState.getSequenceId(), CaptureChangeMySQL.REL_SUCCESS, eventWriterConfiguration));
        } else if (session != null) {
            FlowFile flowFile = eventWriterConfiguration.getCurrentFlowFile();
            if (flowFile != null) {
                this.eventWriter.finishAndTransferFlowFile(session, eventWriterConfiguration, binlogResourceInfo.getTransitUri(), dataCaptureState.getSequenceId(), commitEvent, CaptureChangeMySQL.REL_SUCCESS);
            }
            session.commitAsync();
        }
        binlogResourceInfo.setInTransaction(false);
    }
}

