/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.cdc.event.io;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.nifi.cdc.event.EventInfo;
import org.apache.nifi.cdc.event.io.EventWriter;

public abstract class AbstractEventWriter<T extends EventInfo>
implements EventWriter<T> {
    private final JsonFactory JSON_FACTORY = new JsonFactory();
    protected JsonGenerator jsonGenerator;

    protected void startJson(OutputStream outputStream, T event) throws IOException {
        if (this.jsonGenerator == null) {
            this.jsonGenerator = this.createJsonGenerator(outputStream);
        }
        this.jsonGenerator.writeStartObject();
        String eventType = event.getEventType();
        if (eventType == null) {
            this.jsonGenerator.writeNullField("type");
        } else {
            this.jsonGenerator.writeStringField("type", eventType);
        }
        Long timestamp = event.getTimestamp();
        if (timestamp == null) {
            this.jsonGenerator.writeNullField("timestamp");
        } else {
            this.jsonGenerator.writeNumberField("timestamp", event.getTimestamp().longValue());
        }
    }

    protected void endJson() throws IOException {
        if (this.jsonGenerator == null) {
            throw new IOException("endJson called without a JsonGenerator");
        }
        this.jsonGenerator.writeEndObject();
    }

    protected void endFile() throws IOException {
        this.jsonGenerator.flush();
        this.jsonGenerator.close();
        this.jsonGenerator = null;
    }

    protected JsonGenerator createJsonGenerator(OutputStream out) throws IOException {
        return this.JSON_FACTORY.createGenerator(out);
    }
}

