/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.service;

import com.datastax.driver.core.Cluster;
import com.datastax.driver.core.ConsistencyLevel;
import com.datastax.driver.core.JdkSSLOptions;
import com.datastax.driver.core.Metadata;
import com.datastax.driver.core.ProtocolOptions;
import com.datastax.driver.core.SSLOptions;
import com.datastax.driver.core.Session;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnDisabled;
import org.apache.nifi.annotation.lifecycle.OnEnabled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.authentication.exception.ProviderCreationException;
import org.apache.nifi.cassandra.CassandraSessionProviderService;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.controller.ConfigurationContext;
import org.apache.nifi.controller.ControllerServiceInitializationContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.security.util.SslContextFactory;
import org.apache.nifi.ssl.SSLContextService;

@Tags(value={"cassandra", "dbcp", "database", "connection", "pooling"})
@CapabilityDescription(value="Provides connection session for Cassandra processors to work with Apache Cassandra.")
public class CassandraSessionProvider
extends AbstractControllerService
implements CassandraSessionProviderService {
    public static final int DEFAULT_CASSANDRA_PORT = 9042;
    public static final PropertyDescriptor CONTACT_POINTS = new PropertyDescriptor.Builder().name("Cassandra Contact Points").description("Contact points are addresses of Cassandra nodes. The list of contact points should be comma-separated and in hostname:port format. Example node1:port,node2:port,.... The default client port for Cassandra is 9042, but the port(s) must be explicitly specified.").required(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.HOSTNAME_PORT_LIST_VALIDATOR).build();
    public static final PropertyDescriptor KEYSPACE = new PropertyDescriptor.Builder().name("Keyspace").description("The Cassandra Keyspace to connect to. If no keyspace is specified, the query will need to include the keyspace name before any table reference, in case of 'query' native processors or if the processor supports the 'Table' property, the keyspace name has to be provided with the table name in the form of <KEYSPACE>.<TABLE>").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PROP_SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("The SSL Context Service used to provide client certificate information for TLS/SSL connections.").required(false).identifiesControllerService(SSLContextService.class).build();
    public static final PropertyDescriptor CLIENT_AUTH = new PropertyDescriptor.Builder().name("Client Auth").description("Client authentication policy when connecting to secure (TLS/SSL) cluster. Possible values are REQUIRED, WANT, NONE. This property is only used when an SSL Context has been defined and enabled.").required(false).allowableValues((Enum[])SSLContextService.ClientAuth.values()).defaultValue("REQUIRED").build();
    public static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("Username to access the Cassandra cluster").required(false).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor PASSWORD = new PropertyDescriptor.Builder().name("Password").description("Password to access the Cassandra cluster").required(false).sensitive(true).expressionLanguageSupported(ExpressionLanguageScope.VARIABLE_REGISTRY).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor CONSISTENCY_LEVEL = new PropertyDescriptor.Builder().name("Consistency Level").description("The strategy for how many replicas must respond before results are returned.").required(true).allowableValues((Enum[])ConsistencyLevel.values()).defaultValue("ONE").build();
    static final PropertyDescriptor COMPRESSION_TYPE = new PropertyDescriptor.Builder().name("Compression Type").description("Enable compression at transport-level requests and responses").required(false).allowableValues((Enum[])ProtocolOptions.Compression.values()).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).defaultValue("NONE").build();
    private List<PropertyDescriptor> properties;
    private Cluster cluster;
    private Session cassandraSession;

    public void init(ControllerServiceInitializationContext context) {
        ArrayList<PropertyDescriptor> props = new ArrayList<PropertyDescriptor>();
        props.add(CONTACT_POINTS);
        props.add(CLIENT_AUTH);
        props.add(CONSISTENCY_LEVEL);
        props.add(COMPRESSION_TYPE);
        props.add(KEYSPACE);
        props.add(USERNAME);
        props.add(PASSWORD);
        props.add(PROP_SSL_CONTEXT_SERVICE);
        this.properties = props;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return this.properties;
    }

    @OnEnabled
    public void onEnabled(ConfigurationContext context) {
        this.connectToCassandra(context);
    }

    @OnDisabled
    public void onDisabled() {
        if (this.cassandraSession != null) {
            this.cassandraSession.close();
        }
        if (this.cluster != null) {
            this.cluster.close();
        }
    }

    @OnStopped
    public void onStopped() {
        if (this.cassandraSession != null) {
            this.cassandraSession.close();
        }
        if (this.cluster != null) {
            this.cluster.close();
        }
    }

    public Cluster getCluster() {
        if (this.cluster != null) {
            return this.cluster;
        }
        throw new ProcessException("Unable to get the Cassandra cluster detail.");
    }

    public Session getCassandraSession() {
        if (this.cassandraSession != null) {
            return this.cassandraSession;
        }
        throw new ProcessException("Unable to get the Cassandra session.");
    }

    private void connectToCassandra(ConfigurationContext context) {
        if (this.cluster == null) {
            String password;
            String username;
            SSLContext sslContext;
            ComponentLog log = this.getLogger();
            String contactPointList = context.getProperty(CONTACT_POINTS).evaluateAttributeExpressions().getValue();
            String consistencyLevel = context.getProperty(CONSISTENCY_LEVEL).getValue();
            String compressionType = context.getProperty(COMPRESSION_TYPE).getValue();
            List<InetSocketAddress> contactPoints = this.getContactPoints(contactPointList);
            SSLContextService sslService = (SSLContextService)context.getProperty(PROP_SSL_CONTEXT_SERVICE).asControllerService(SSLContextService.class);
            String rawClientAuth = context.getProperty(CLIENT_AUTH).getValue();
            if (sslService != null) {
                SSLContextService.ClientAuth clientAuth;
                if (StringUtils.isBlank((CharSequence)rawClientAuth)) {
                    clientAuth = SSLContextService.ClientAuth.REQUIRED;
                } else {
                    try {
                        clientAuth = SSLContextService.ClientAuth.valueOf((String)rawClientAuth);
                    }
                    catch (IllegalArgumentException iae) {
                        throw new ProviderCreationException(String.format("Unrecognized client auth '%s'. Possible values are [%s]", rawClientAuth, StringUtils.join((Object[])SslContextFactory.ClientAuth.values(), (String)", ")));
                    }
                }
                sslContext = sslService.createSSLContext(clientAuth);
            } else {
                sslContext = null;
            }
            PropertyValue usernameProperty = context.getProperty(USERNAME).evaluateAttributeExpressions();
            PropertyValue passwordProperty = context.getProperty(PASSWORD).evaluateAttributeExpressions();
            if (usernameProperty != null && passwordProperty != null) {
                username = usernameProperty.getValue();
                password = passwordProperty.getValue();
            } else {
                username = null;
                password = null;
            }
            Cluster newCluster = this.createCluster(contactPoints, sslContext, username, password, compressionType);
            PropertyValue keyspaceProperty = context.getProperty(KEYSPACE).evaluateAttributeExpressions();
            Session newSession = keyspaceProperty != null ? newCluster.connect(keyspaceProperty.getValue()) : newCluster.connect();
            newCluster.getConfiguration().getQueryOptions().setConsistencyLevel(ConsistencyLevel.valueOf((String)consistencyLevel));
            Metadata metadata = newCluster.getMetadata();
            log.info("Connected to Cassandra cluster: {}", new Object[]{metadata.getClusterName()});
            this.cluster = newCluster;
            this.cassandraSession = newSession;
        }
    }

    private List<InetSocketAddress> getContactPoints(String contactPointList) {
        if (contactPointList == null) {
            return null;
        }
        List<String> contactPointStringList = Arrays.asList(contactPointList.split(","));
        ArrayList<InetSocketAddress> contactPoints = new ArrayList<InetSocketAddress>();
        for (String contactPointEntry : contactPointStringList) {
            String[] addresses = contactPointEntry.split(":");
            String hostName = addresses[0].trim();
            int port = addresses.length > 1 ? Integer.parseInt(addresses[1].trim()) : 9042;
            contactPoints.add(new InetSocketAddress(hostName, port));
        }
        return contactPoints;
    }

    private Cluster createCluster(List<InetSocketAddress> contactPoints, SSLContext sslContext, String username, String password, String compressionType) {
        Cluster.Builder builder = Cluster.builder().addContactPointsWithPorts(contactPoints);
        if (sslContext != null) {
            JdkSSLOptions sslOptions = JdkSSLOptions.builder().withSSLContext(sslContext).build();
            builder = builder.withSSL((SSLOptions)sslOptions);
        }
        if (username != null && password != null) {
            builder = builder.withCredentials(username, password);
        }
        if (ProtocolOptions.Compression.SNAPPY.equals((Object)compressionType)) {
            builder = builder.withCompression(ProtocolOptions.Compression.SNAPPY);
        } else if (ProtocolOptions.Compression.LZ4.equals((Object)compressionType)) {
            builder = builder.withCompression(ProtocolOptions.Compression.LZ4);
        }
        return builder.build();
    }
}

