/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.sql.internal;

import java.util.List;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.RelFactories;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.tools.RelBuilderFactory;
import org.apache.nifi.sql.internal.NiFiTableScan;

public class NiFiProjectTableScanRule
extends RelRule<Config> {
    NiFiProjectTableScanRule(Config config) {
        super((RelRule.Config)config);
    }

    public void onMatch(RelOptRuleCall call) {
        Project project = (Project)call.rel(0);
        RelNode relNode = project.getInput();
        if (!(relNode instanceof NiFiTableScan)) {
            return;
        }
        NiFiTableScan scan = (NiFiTableScan)relNode;
        int[] fields = NiFiProjectTableScanRule.getProjectionFields(project.getProjects());
        if (fields == null) {
            return;
        }
        NiFiTableScan tableScan = new NiFiTableScan(scan.getCluster(), scan.getTable(), fields);
        call.transformTo((RelNode)tableScan);
    }

    private static int[] getProjectionFields(List<RexNode> expressions) {
        int[] fields = new int[expressions.size()];
        for (int i = 0; i < expressions.size(); ++i) {
            RexNode exp = expressions.get(i);
            if (!(exp instanceof RexInputRef)) {
                return null;
            }
            fields[i] = ((RexInputRef)exp).getIndex();
        }
        return fields;
    }

    private static class StandardConfig
    implements Config {
        private RelBuilderFactory relBuilderFactory = RelFactories.LOGICAL_BUILDER;
        private String description;
        private RelRule.OperandTransform operandTransform;

        private StandardConfig() {
        }

        public StandardConfig withRelBuilderFactory(RelBuilderFactory factory) {
            this.relBuilderFactory = factory;
            return this;
        }

        public StandardConfig withDescription(String description) {
            this.description = description;
            return this;
        }

        public StandardConfig withOperandSupplier(RelRule.OperandTransform transform) {
            this.operandTransform = transform;
            return this;
        }

        public RelBuilderFactory relBuilderFactory() {
            return this.relBuilderFactory;
        }

        public String description() {
            return this.description;
        }

        public RelRule.OperandTransform operandSupplier() {
            return this.operandTransform;
        }
    }

    public static interface Config
    extends RelRule.Config {
        public static final Config DEFAULT = new StandardConfig().withOperandSupplier(b0 -> b0.operand(Project.class).anyInputs());

        default public NiFiProjectTableScanRule toRule() {
            return new NiFiProjectTableScanRule(this);
        }
    }
}

