/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.sql.internal;

import java.lang.reflect.Type;
import java.util.function.Function;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.nifi.sql.internal.NiFiTableScan;

public class CalciteTable
extends AbstractTable
implements QueryableTable,
TranslatableTable {
    private final Function<RelDataTypeFactory, RelDataType> tableDefinitionFactory;
    private final Function<int[], Enumerable<Object>> projectionFactory;

    public CalciteTable(Function<RelDataTypeFactory, RelDataType> tableDefinitionFactory, Function<int[], Enumerable<Object>> projectionFactory) {
        this.tableDefinitionFactory = tableDefinitionFactory;
        this.projectionFactory = projectionFactory;
    }

    public Enumerable<Object> project(DataContext dataContext, int[] fields) {
        return this.projectionFactory.apply(fields);
    }

    public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
        return Schemas.tableExpression((SchemaPlus)schema, (Type)this.getElementType(), (String)tableName, (Class)clazz);
    }

    public Type getElementType() {
        return Object[].class;
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        throw new UnsupportedOperationException();
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        int fieldCount = relOptTable.getRowType().getFieldCount();
        int[] fields = new int[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fields[i] = i;
        }
        return new NiFiTableScan(context.getCluster(), relOptTable, fields);
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.tableDefinitionFactory.apply(typeFactory);
    }
}

