/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxAI;
import com.box.sdk.BoxAIExtractField;
import com.box.sdk.BoxAIExtractFieldOption;
import com.box.sdk.BoxAIExtractMetadataTemplate;
import com.box.sdk.BoxAIExtractStructuredResponse;
import com.box.sdk.BoxAIItem;
import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIResponseException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.box.FetchBoxFile;
import org.apache.nifi.processors.box.ListBoxFile;
import org.apache.nifi.processors.box.ListBoxFileMetadataTemplates;
import org.apache.nifi.processors.box.UpdateBoxFileMetadataInstance;
import org.apache.nifi.serialization.MalformedRecordException;
import org.apache.nifi.serialization.RecordReader;
import org.apache.nifi.serialization.RecordReaderFactory;
import org.apache.nifi.serialization.record.Record;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"box", "storage", "metadata", "ai", "extract"})
@CapabilityDescription(value="Extracts metadata from a Box file using Box AI. The extraction can use either a template or a list of fields. The extracted metadata is written to the FlowFile content as JSON.")
@SeeAlso(value={ListBoxFileMetadataTemplates.class, ListBoxFile.class, FetchBoxFile.class, UpdateBoxFileMetadataInstance.class})
@WritesAttributes(value={@WritesAttribute(attribute="box.id", description="The ID of the file from which metadata was extracted"), @WritesAttribute(attribute="box.ai.template.key", description="The template key used for extraction (when using TEMPLATE extraction method)"), @WritesAttribute(attribute="box.ai.extraction.method", description="The extraction method used (TEMPLATE or FIELDS)"), @WritesAttribute(attribute="box.ai.completion.reason", description="The completion reason from the AI extraction"), @WritesAttribute(attribute="mime.type", description="Set to 'application/json' for the JSON content"), @WritesAttribute(attribute="error.code", description="The error code returned by Box"), @WritesAttribute(attribute="error.message", description="The error message returned by Box")})
public class ExtractStructuredBoxFileMetadata
extends AbstractProcessor {
    public static final PropertyDescriptor FILE_ID = new PropertyDescriptor.Builder().name("File ID").description("The ID of the file from which to extract metadata.").required(true).defaultValue("${box.id}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor EXTRACTION_METHOD = new PropertyDescriptor.Builder().name("Extraction Method").description("The method to use for extracting metadata. TEMPLATE uses a Box metadata template for extraction. FIELDS uses a JSON schema of fields (read from FlowFile content) for extraction.").required(true).allowableValues(new DescribedValue[]{ExtractionMethod.TEMPLATE, ExtractionMethod.FIELDS}).defaultValue(ExtractionMethod.TEMPLATE.getValue()).build();
    public static final PropertyDescriptor TEMPLATE_KEY = new PropertyDescriptor.Builder().name("Template Key").description("The key of the metadata template to use for extraction. Required when Extraction Method is TEMPLATE.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).dependsOn(EXTRACTION_METHOD, (DescribedValue)ExtractionMethod.TEMPLATE, new DescribedValue[0]).build();
    public static final PropertyDescriptor RECORD_READER = new PropertyDescriptor.Builder().name("Record Reader").description("The Record Reader to use for parsing the incoming data. Required when Extraction Method is FIELDS.").required(true).identifiesControllerService(RecordReaderFactory.class).dependsOn(EXTRACTION_METHOD, (DescribedValue)ExtractionMethod.FIELDS, new DescribedValue[0]).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile is routed to this relationship after metadata has been successfully extracted.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile is routed to this relationship if an error occurs during metadata extraction.").build();
    public static final Relationship REL_FILE_NOT_FOUND = new Relationship.Builder().name("file not found").description("FlowFiles for which the specified Box file was not found will be routed to this relationship.").build();
    public static final Relationship REL_TEMPLATE_NOT_FOUND = new Relationship.Builder().name("template not found").description("FlowFiles for which the specified metadata template was not found will be routed to this relationship.").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_FILE_NOT_FOUND, REL_TEMPLATE_NOT_FOUND);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BoxClientService.BOX_CLIENT_SERVICE, FILE_ID, EXTRACTION_METHOD, TEMPLATE_KEY, RECORD_READER);
    private static final String SCOPE = "enterprise";
    private volatile BoxAPIConnection boxAPIConnection;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BoxClientService.BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        this.boxAPIConnection = boxClientService.getBoxApiConnection();
    }

    /*
     * Unable to fully structure code
     */
    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        fileId = context.getProperty(ExtractStructuredBoxFileMetadata.FILE_ID).evaluateAttributeExpressions(flowFile).getValue();
        extractionMethod = (ExtractionMethod)context.getProperty(ExtractStructuredBoxFileMetadata.EXTRACTION_METHOD).asAllowableValue(ExtractionMethod.class);
        try {
            block34: {
                attributes = new HashMap<String, String>();
                attributes.put("box.id", fileId);
                attributes.put("box.ai.extraction.method", extractionMethod.name());
                switch (extractionMethod.ordinal()) {
                    default: {
                        throw new MatchException(null, null);
                    }
                    case 0: {
                        templateKey = context.getProperty(ExtractStructuredBoxFileMetadata.TEMPLATE_KEY).evaluateAttributeExpressions(flowFile).getValue();
                        attributes.put("box.ai.template.key", templateKey);
                        v0 = var8_10 = this.getBoxAIExtractStructuredResponseWithTemplate(templateKey, fileId);
                        break;
                    }
                    case 1: {
                        recordReaderFactory = (RecordReaderFactory)context.getProperty(ExtractStructuredBoxFileMetadata.RECORD_READER).asControllerService(RecordReaderFactory.class);
                        inputStream = session.read(flowFile);
                        try {
                            recordReader = recordReaderFactory.createRecordReader(flowFile, inputStream, this.getLogger());
                            try {
                                var8_10 = this.getBoxAIExtractStructuredResponseWithFields(recordReader, fileId);
                                if (recordReader == null) ** GOTO lbl41
                            }
                            catch (Throwable var12_16) {
                                if (recordReader != null) {
                                    try {
                                        recordReader.close();
                                    }
                                    catch (Throwable var13_18) {
                                        var12_16.addSuppressed(var13_18);
                                    }
                                }
                                throw var12_16;
                            }
                            recordReader.close();
lbl41:
                            // 2 sources

                            v0 = var8_10;
                            break;
                        }
                        finally {
                            if (inputStream != null) {
                                inputStream.close();
                            }
                        }
                    }
                }
                result = v0;
                completionReason = result.getCompletionReason();
                if (completionReason != null) {
                    attributes.put("box.ai.completion.reason", completionReason);
                }
                flowFile = session.putAllAttributes(flowFile, attributes);
                try {
                    out = session.write(flowFile);
                    try {
                        if (result.getAnswer() != null) {
                            out.write(result.getAnswer().toString().getBytes());
                            break block34;
                        }
                        flowFile = session.putAttribute(flowFile, "error.message", "No answer present in the AI extraction result");
                        session.transfer(flowFile, ExtractStructuredBoxFileMetadata.REL_FAILURE);
                        return;
                    }
                    finally {
                        if (out != null) {
                            out.close();
                        }
                    }
                }
                catch (IOException e) {
                    this.getLogger().error("Error writing Box AI metadata extraction answer to FlowFile", (Throwable)e);
                    flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
                    session.transfer(flowFile, ExtractStructuredBoxFileMetadata.REL_FAILURE);
                    return;
                }
            }
            flowFile = session.putAttribute(flowFile, CoreAttributes.MIME_TYPE.key(), "application/json");
            session.getProvenanceReporter().modifyAttributes(flowFile, "https://app.box.com/file/" + fileId);
            session.transfer(flowFile, ExtractStructuredBoxFileMetadata.REL_SUCCESS);
        }
        catch (BoxAPIResponseException e) {
            flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getResponseCode()));
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            if (e.getResponseCode() == 404) {
                errorBody = e.getResponse();
                if (errorBody != null && errorBody.contains("Specified Metadata Template not found")) {
                    this.getLogger().warn("Box metadata template was not found for extraction request.");
                    session.transfer(flowFile, ExtractStructuredBoxFileMetadata.REL_TEMPLATE_NOT_FOUND);
                } else {
                    this.getLogger().warn("Box file with ID {} was not found.", new Object[]{fileId});
                    session.transfer(flowFile, ExtractStructuredBoxFileMetadata.REL_FILE_NOT_FOUND);
                }
            } else {
                this.getLogger().error("Couldn't extract metadata from file with id [{}]", new Object[]{fileId, e});
                session.transfer(flowFile, ExtractStructuredBoxFileMetadata.REL_FAILURE);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error processing metadata extraction for Box file [{}]", new Object[]{fileId, e});
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            session.transfer(flowFile, ExtractStructuredBoxFileMetadata.REL_FAILURE);
        }
    }

    BoxAIExtractStructuredResponse getBoxAIExtractStructuredResponseWithTemplate(String templateKey, String fileId) {
        BoxAIExtractMetadataTemplate template = new BoxAIExtractMetadataTemplate(templateKey, SCOPE);
        BoxAIItem fileItem = new BoxAIItem(fileId, BoxAIItem.Type.FILE);
        return BoxAI.extractMetadataStructured((BoxAPIConnection)this.boxAPIConnection, Collections.singletonList(fileItem), (BoxAIExtractMetadataTemplate)template);
    }

    BoxAIExtractStructuredResponse getBoxAIExtractStructuredResponseWithFields(RecordReader recordReader, String fileId) throws IOException, MalformedRecordException {
        List<BoxAIExtractField> fields = this.parseFieldsFromRecords(recordReader);
        BoxAIItem fileItem = new BoxAIItem(fileId, BoxAIItem.Type.FILE);
        return BoxAI.extractMetadataStructured((BoxAPIConnection)this.boxAPIConnection, Collections.singletonList(fileItem), fields);
    }

    private List<BoxAIExtractField> parseFieldsFromRecords(RecordReader recordReader) throws IOException, MalformedRecordException {
        Record record;
        ArrayList<BoxAIExtractField> fields = new ArrayList<BoxAIExtractField>();
        while ((record = recordReader.nextRecord()) != null) {
            String key = record.getAsString("key");
            if (key == null || key.isBlank()) {
                throw new MalformedRecordException("Field record missing a key field: " + String.valueOf(record));
            }
            String type = record.getAsString("type");
            String description = record.getAsString("description");
            String displayName = record.getAsString("displayName");
            String prompt = record.getAsString("prompt");
            ArrayList<BoxAIExtractFieldOption> options = null;
            Object optionsObj = record.getValue("options");
            if (optionsObj instanceof Iterable) {
                Iterable iterable = (Iterable)optionsObj;
                options = new ArrayList<BoxAIExtractFieldOption>();
                for (Object option : iterable) {
                    if (option instanceof Record) {
                        Record optionRecord = (Record)option;
                        String optionKey = optionRecord.getAsString("key");
                        if (optionKey != null && !optionKey.isBlank()) {
                            options.add(new BoxAIExtractFieldOption(optionKey));
                            continue;
                        }
                        this.getLogger().warn("Option record missing a valid 'key': {}", new Object[]{optionRecord});
                        continue;
                    }
                    this.getLogger().warn("Option is not a record: {}", new Object[]{option});
                }
            }
            fields.add(new BoxAIExtractField(type, description, displayName, key, options, prompt));
        }
        if (fields.isEmpty()) {
            throw new MalformedRecordException("No valid field records found in the input");
        }
        return fields;
    }

    public static enum ExtractionMethod implements DescribedValue
    {
        TEMPLATE("Template", "Uses a Box metadata template for extraction."),
        FIELDS("Fields", "Uses a JSON schema of fields to extract from the FlowFile content. The schema should include 'key' (required); 'type', 'description', 'displayName', 'prompt', and 'options' fields are optional. This follows the BOX API schema for fields.");

        private final String displayName;
        private final String description;

        private ExtractionMethod(String displayName, String description) {
            this.displayName = displayName;
            this.description = description;
        }

        public String getValue() {
            return this.name();
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

