/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.BoxFile;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.box.CreateBoxFileMetadataInstance;
import org.apache.nifi.processors.box.FetchBoxFileMetadataInstance;
import org.apache.nifi.processors.box.UpdateBoxFileMetadataInstance;

@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"box", "storage", "metadata", "templates", "delete"})
@CapabilityDescription(value="Deletes a metadata instance from a Box file using the specified template key")
@SeeAlso(value={CreateBoxFileMetadataInstance.class, FetchBoxFileMetadataInstance.class, UpdateBoxFileMetadataInstance.class})
@WritesAttributes(value={@WritesAttribute(attribute="box.id", description="The ID of the file from which metadata was deleted"), @WritesAttribute(attribute="box.template.key", description="The template key used for metadata deletion"), @WritesAttribute(attribute="error.code", description="The error code returned by Box"), @WritesAttribute(attribute="error.message", description="The error message returned by Box")})
public class DeleteBoxFileMetadataInstance
extends AbstractProcessor {
    public static final PropertyDescriptor FILE_ID = new PropertyDescriptor.Builder().name("File ID").description("The ID of the file from which to delete metadata.").required(true).defaultValue("${box.id}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor TEMPLATE_KEY = new PropertyDescriptor.Builder().name("Template Key").description("The key of the metadata template instance to delete.").required(true).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("A FlowFile is routed to this relationship after metadata has been successfully deleted.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("A FlowFile is routed to this relationship if an error occurs during metadata deletion.").build();
    public static final Relationship REL_FILE_NOT_FOUND = new Relationship.Builder().name("file not found").description("FlowFiles for which the specified Box file was not found will be routed to this relationship.").build();
    public static final Relationship REL_TEMPLATE_NOT_FOUND = new Relationship.Builder().name("template not found").description("FlowFiles for which the specified metadata template was not found will be routed to this relationship.").build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE, REL_FILE_NOT_FOUND, REL_TEMPLATE_NOT_FOUND);
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BoxClientService.BOX_CLIENT_SERVICE, FILE_ID, TEMPLATE_KEY);
    private volatile BoxAPIConnection boxAPIConnection;

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BoxClientService.BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        this.boxAPIConnection = boxClientService.getBoxApiConnection();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String fileId = context.getProperty(FILE_ID).evaluateAttributeExpressions(flowFile).getValue();
        String templateKey = context.getProperty(TEMPLATE_KEY).evaluateAttributeExpressions(flowFile).getValue();
        try {
            BoxFile boxFile = this.getBoxFile(fileId);
            boxFile.deleteMetadata(templateKey);
            Map<String, String> attributes = Map.of("box.id", fileId, "box.template.key", templateKey);
            flowFile = session.putAllAttributes(flowFile, attributes);
            session.getProvenanceReporter().invokeRemoteProcess(flowFile, "%s%s/metadata/%s".formatted("https://app.box.com/file/", fileId, templateKey), "Deleted metadata instance using template key: " + templateKey);
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (BoxAPIResponseException e) {
            flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getResponseCode()));
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            if (e.getResponseCode() == 404) {
                String errorBody = e.getResponse();
                if (errorBody != null && errorBody.toLowerCase().contains("specified metadata template not found")) {
                    this.getLogger().warn("Box metadata instance with template key {} was not found for file ID {}.", new Object[]{templateKey, fileId});
                    session.transfer(flowFile, REL_TEMPLATE_NOT_FOUND);
                } else {
                    this.getLogger().warn("Box file with ID {} was not found.", new Object[]{fileId});
                    session.transfer(flowFile, REL_FILE_NOT_FOUND);
                }
            } else {
                this.getLogger().error("Couldn't delete metadata for file with id [{}]", new Object[]{fileId, e});
                session.transfer(flowFile, REL_FAILURE);
            }
        }
        catch (Exception e) {
            this.getLogger().error("Error processing metadata deletion for Box file [{}]", new Object[]{fileId, e});
            flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    BoxFile getBoxFile(String fileId) {
        return new BoxFile(this.boxAPIConnection, fileId);
    }
}

