/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box.utils;

import com.box.sdk.Metadata;
import com.eclipsesource.json.JsonValue;
import java.math.BigDecimal;
import java.util.Map;

public class BoxMetadataUtils {
    public static Object parseJsonValue(JsonValue jsonValue) {
        if (jsonValue == null) {
            return null;
        }
        if (jsonValue.isString()) {
            return jsonValue.asString();
        }
        if (jsonValue.isNumber()) {
            String numberString = jsonValue.toString();
            if (numberString.contains(".") || numberString.toLowerCase().contains("e")) {
                try {
                    return new BigDecimal(numberString).toPlainString();
                }
                catch (NumberFormatException e) {
                    return jsonValue.asDouble();
                }
            }
            try {
                return jsonValue.asLong();
            }
            catch (NumberFormatException e) {
                return new BigDecimal(numberString).toPlainString();
            }
        }
        if (jsonValue.isBoolean()) {
            return jsonValue.asBoolean();
        }
        return jsonValue.toString();
    }

    public static void processBoxMetadataInstance(String fileId, Metadata metadata, Map<String, Object> instanceFields) {
        instanceFields.put("$id", metadata.getID());
        instanceFields.put("$type", metadata.getTypeName());
        instanceFields.put("$parent", "file_" + fileId);
        instanceFields.put("$template", metadata.getTemplateName());
        instanceFields.put("$scope", metadata.getScope());
        for (String fieldName : metadata.getPropertyPaths()) {
            JsonValue jsonValue = metadata.getValue(fieldName);
            if (jsonValue == null) continue;
            String cleanFieldName = fieldName.startsWith("/") ? fieldName.substring(1) : fieldName;
            Object fieldValue = BoxMetadataUtils.parseJsonValue(jsonValue);
            instanceFields.put(cleanFieldName, fieldValue);
        }
    }
}

