/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.box;

import com.box.sdk.BoxAPIConnection;
import com.box.sdk.BoxAPIException;
import com.box.sdk.BoxAPIResponseException;
import com.box.sdk.BoxFile;
import com.box.sdk.BoxFolder;
import com.box.sdk.BoxItem;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import java.util.stream.StreamSupport;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.ReadsAttribute;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.box.controllerservices.BoxClientService;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.DataUnit;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.box.BoxFileUtils;
import org.apache.nifi.processors.box.FetchBoxFile;
import org.apache.nifi.processors.box.ListBoxFile;
import org.apache.nifi.processors.conflict.resolution.ConflictResolutionStrategy;

@SeeAlso(value={ListBoxFile.class, FetchBoxFile.class})
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@Tags(value={"box", "storage", "put"})
@CapabilityDescription(value="Puts content to a Box folder.")
@ReadsAttribute(attribute="filename", description="Uses the FlowFile's filename as the filename for the Box object.")
@WritesAttributes(value={@WritesAttribute(attribute="box.id", description="The id of the file"), @WritesAttribute(attribute="filename", description="The name of the file"), @WritesAttribute(attribute="path", description="The folder path where the file is located"), @WritesAttribute(attribute="box.size", description="The size of the file"), @WritesAttribute(attribute="box.timestamp", description="The last modified time of the file"), @WritesAttribute(attribute="error.code", description="The error code returned by Box"), @WritesAttribute(attribute="error.message", description="The error message returned by Box")})
public class PutBoxFile
extends AbstractProcessor {
    public static final int CHUNKED_UPLOAD_LOWER_LIMIT_IN_BYTES = 0x1400000;
    public static final int CHUNKED_UPLOAD_UPPER_LIMIT_IN_BYTES = 0x3200000;
    public static final int NUMBER_OF_RETRIES = 10;
    public static final int WAIT_TIME_MS = 1000;
    public static final PropertyDescriptor FOLDER_ID = new PropertyDescriptor.Builder().name("box-folder-id").displayName("Folder ID").description("The ID of the folder where the file is uploaded. Please see Additional Details to obtain Folder ID.").addValidator(StandardValidators.NON_EMPTY_VALIDATOR).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(true).build();
    public static final PropertyDescriptor FILE_NAME = new PropertyDescriptor.Builder().name("file-name").displayName("Filename").description("The name of the file to upload to the specified Box folder.").required(true).defaultValue("${filename}").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor SUBFOLDER_NAME = new PropertyDescriptor.Builder().name("subfolder-name").displayName("Subfolder Name").description("The name (path) of the subfolder where files are uploaded. The subfolder name is relative to the folder specified by 'Folder ID'. Example: subFolder, subFolder1/subfolder2").addValidator(StandardValidators.createRegexMatchingValidator((Pattern)Pattern.compile("^(?!/).+(?<!/)$"), (boolean)false, (String)"Subfolder Name should not contain leading or trailing slash ('/') character.")).expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).build();
    public static final PropertyDescriptor CREATE_SUBFOLDER = new PropertyDescriptor.Builder().name("create-folder").displayName("Create Subfolder").expressionLanguageSupported(ExpressionLanguageScope.NONE).required(true).addValidator(StandardValidators.BOOLEAN_VALIDATOR).allowableValues(new String[]{"true", "false"}).defaultValue("false").dependsOn(SUBFOLDER_NAME, new AllowableValue[0]).description("Specifies whether to check if the subfolder exists and to automatically create it if it does not. Permission to list folders is required. ").build();
    public static final PropertyDescriptor CONFLICT_RESOLUTION = new PropertyDescriptor.Builder().name("conflict-resolution-strategy").displayName("Conflict Resolution Strategy").description("Indicates what should happen when a file with the same name already exists in the specified Box folder.").required(true).defaultValue(ConflictResolutionStrategy.FAIL.getValue()).allowableValues(ConflictResolutionStrategy.class).build();
    public static final PropertyDescriptor CHUNKED_UPLOAD_THRESHOLD = new PropertyDescriptor.Builder().name("chunked-upload-threshold").displayName("Chunked Upload Threshold").description("The maximum size of the content which is uploaded at once. FlowFiles larger than this threshold are uploaded in chunks. Chunked upload is allowed for files larger than 20 MB. It is recommended to use chunked upload for files exceeding 50 MB.").defaultValue("20 MB").addValidator(StandardValidators.createDataSizeBoundsValidator((long)0x1400000L, (long)0x3200000L)).required(false).build();
    public static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(BoxClientService.BOX_CLIENT_SERVICE, FOLDER_ID, SUBFOLDER_NAME, CREATE_SUBFOLDER, FILE_NAME, CONFLICT_RESOLUTION, CHUNKED_UPLOAD_THRESHOLD);
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("Files that have been successfully written to Box are transferred to this relationship.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("Files that could not be written to Box for some reason are transferred to this relationship.").build();
    public static final Set<Relationship> RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    private static final int CONFLICT_RESPONSE_CODE = 409;
    private static final int NOT_FOUND_RESPONSE_CODE = 404;
    private volatile BoxAPIConnection boxAPIConnection;

    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        BoxClientService boxClientService = (BoxClientService)context.getProperty(BoxClientService.BOX_CLIENT_SERVICE).asControllerService(BoxClientService.class);
        this.boxAPIConnection = boxClientService.getBoxApiConnection();
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String filename = context.getProperty(FILE_NAME).evaluateAttributeExpressions(flowFile).getValue();
        long chunkUploadThreshold = context.getProperty(CHUNKED_UPLOAD_THRESHOLD).asDataSize(DataUnit.B).longValue();
        ConflictResolutionStrategy conflictResolution = ConflictResolutionStrategy.forValue((String)context.getProperty(CONFLICT_RESOLUTION).getValue());
        long startNanos = System.nanoTime();
        String fullPath = null;
        try {
            long size = flowFile.getSize();
            BoxFolder parentFolder = this.getOrCreateDirectParentFolder(context, flowFile);
            fullPath = BoxFileUtils.getFolderPath(parentFolder.getInfo(new String[0]));
            BoxFile.Info uploadedFileInfo = null;
            try (InputStream rawIn = session.read(flowFile);){
                if (ConflictResolutionStrategy.REPLACE.equals((Object)conflictResolution)) {
                    uploadedFileInfo = this.replaceBoxFileIfExists(parentFolder, filename, rawIn, size, chunkUploadThreshold);
                }
                if (uploadedFileInfo == null) {
                    uploadedFileInfo = this.createBoxFile(parentFolder, filename, rawIn, size, chunkUploadThreshold);
                }
            }
            catch (BoxAPIResponseException e) {
                if (e.getResponseCode() == 409) {
                    this.handleConflict(conflictResolution, filename, fullPath, (BoxAPIException)((Object)e));
                }
                throw e;
            }
            if (uploadedFileInfo != null) {
                Map<String, String> attributes = BoxFileUtils.createAttributeMap(uploadedFileInfo);
                String url = "https://app.box.com/file/" + uploadedFileInfo.getID();
                flowFile = session.putAllAttributes(flowFile, attributes);
                long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
                session.getProvenanceReporter().send(flowFile, url, transferMillis);
            }
            session.transfer(flowFile, REL_SUCCESS);
        }
        catch (BoxAPIResponseException e) {
            this.getLogger().error("Upload failed: File [{}] Folder [{}] Response Code [{}]", new Object[]{filename, fullPath, e.getResponseCode(), e});
            this.handleExpectedError(session, flowFile, e);
        }
        catch (Exception e) {
            this.getLogger().error("Upload failed: File [{}], Folder [{}]", new Object[]{filename, fullPath, e});
            this.handleUnexpectedError(session, flowFile, e);
        }
    }

    BoxFolder getFolder(String folderId) {
        return new BoxFolder(this.boxAPIConnection, folderId);
    }

    private BoxFolder getOrCreateDirectParentFolder(ProcessContext context, FlowFile flowFile) {
        String subfolderPath = context.getProperty(SUBFOLDER_NAME).evaluateAttributeExpressions(flowFile).getValue();
        boolean createFolder = context.getProperty(CREATE_SUBFOLDER).asBoolean();
        String folderId = context.getProperty(FOLDER_ID).evaluateAttributeExpressions(flowFile).getValue();
        BoxFolder parentFolder = this.getFolderById(folderId);
        if (subfolderPath != null) {
            Queue<String> subFolderNames = this.getSubFolderNames(subfolderPath);
            parentFolder = this.getOrCreateSubfolders(subFolderNames, parentFolder, createFolder);
        }
        return parentFolder;
    }

    private BoxFile.Info replaceBoxFileIfExists(BoxFolder parentFolder, String filename, InputStream inputStream, long size, long chunkUploadThreshold) throws IOException, InterruptedException {
        Optional<BoxFile> existingBoxFileInfo = this.getFileByName(filename, parentFolder);
        if (existingBoxFileInfo.isPresent()) {
            BoxFile existingBoxFile = existingBoxFileInfo.get();
            if (size > chunkUploadThreshold) {
                return existingBoxFile.uploadLargeFile(inputStream, size);
            }
            return existingBoxFile.uploadNewVersion(inputStream);
        }
        return null;
    }

    private BoxFile.Info createBoxFile(BoxFolder parentFolder, String filename, InputStream inputStream, long size, long chunkUploadThreshold) throws IOException, InterruptedException {
        if (size > chunkUploadThreshold) {
            return parentFolder.uploadLargeFile(inputStream, filename, size);
        }
        return parentFolder.uploadFile(inputStream, filename);
    }

    private Queue<String> getSubFolderNames(String subfolderPath) {
        LinkedList<String> subfolderNames = new LinkedList<String>();
        Collections.addAll(subfolderNames, subfolderPath.split("/"));
        return subfolderNames;
    }

    private BoxFolder getOrCreateSubfolders(Queue<String> subFolderNames, BoxFolder parentFolder, boolean createFolder) {
        BoxFolder newParentFolder = this.getOrCreateFolder(subFolderNames.poll(), parentFolder, createFolder);
        if (!subFolderNames.isEmpty()) {
            return this.getOrCreateSubfolders(subFolderNames, newParentFolder, createFolder);
        }
        return newParentFolder;
    }

    private BoxFolder getOrCreateFolder(String folderName, BoxFolder parentFolder, boolean createFolder) {
        Optional<BoxFolder> existingFolder = this.getFolderByName(folderName, parentFolder);
        if (existingFolder.isPresent()) {
            return existingFolder.get();
        }
        if (!createFolder) {
            throw new ProcessException(String.format("The specified subfolder [%s] does not exist and [%s] is false.", folderName, CREATE_SUBFOLDER.getDisplayName()));
        }
        return this.createFolder(folderName, parentFolder);
    }

    private BoxFolder createFolder(String folderName, BoxFolder parentFolder) {
        this.getLogger().info("Creating Folder [{}], Parent [{}]", new Object[]{folderName, parentFolder.getID()});
        try {
            return parentFolder.createFolder(folderName).getResource();
        }
        catch (BoxAPIResponseException e) {
            if (e.getResponseCode() != 409) {
                throw e;
            }
            Optional<BoxFolder> createdFolder = this.waitForOngoingFolderCreationToFinish(folderName, parentFolder);
            return createdFolder.orElseThrow(() -> new ProcessException(String.format("Created subfolder [%s] can not be found under [%s]", folderName, parentFolder.getID())));
        }
    }

    private Optional<BoxFolder> waitForOngoingFolderCreationToFinish(String folderName, BoxFolder parentFolder) {
        try {
            Optional<BoxFolder> createdFolder = this.getFolderByName(folderName, parentFolder);
            for (int i = 0; i < 10 && createdFolder.isEmpty(); ++i) {
                this.getLogger().debug("Subfolder [{}] under [{}] has not been created yet, waiting {} ms", new Object[]{folderName, parentFolder.getID(), 1000});
                Thread.sleep(1000L);
                createdFolder = this.getFolderByName(folderName, parentFolder);
            }
            return createdFolder;
        }
        catch (InterruptedException ie) {
            throw new RuntimeException(String.format("Waiting for creation of subfolder [%s] under [%s] was interrupted", folderName, parentFolder.getID()), ie);
        }
    }

    private BoxFolder getFolderById(String folderId) {
        BoxFolder folder;
        block2: {
            folder = this.getFolder(folderId);
            try {
                folder.getInfo(new String[0]);
            }
            catch (BoxAPIResponseException e) {
                if (e.getResponseCode() != 404) break block2;
                throw new ProcessException(String.format("The Folder [%s] specified by [%s] does not exist", folderId, FOLDER_ID.getDisplayName()));
            }
        }
        return folder;
    }

    private Optional<BoxFolder> getFolderByName(String folderName, BoxFolder parentFolder) {
        return this.getItemByName(folderName, parentFolder, BoxFolder.Info.class).map(BoxFolder.Info::getResource);
    }

    private Optional<BoxFile> getFileByName(String filename, BoxFolder parentFolder) {
        return this.getItemByName(filename, parentFolder, BoxFile.Info.class).map(BoxFile.Info::getResource);
    }

    private <T extends BoxItem.Info> Optional<T> getItemByName(String itemName, BoxFolder parentFolder, Class<T> type) {
        return StreamSupport.stream(parentFolder.getChildren(new String[]{"name"}).spliterator(), false).filter(type::isInstance).map(type::cast).filter(info -> info.getName().equals(itemName)).findAny();
    }

    private void handleConflict(ConflictResolutionStrategy conflictResolution, String filename, String path, BoxAPIException e) {
        if (conflictResolution != ConflictResolutionStrategy.IGNORE) {
            throw new ProcessException(String.format("File with the same name [%s] already exists in [%s]", filename, path), (Throwable)e);
        }
        this.getLogger().info("File with the same name [{}] already exists in [{}]. Remote file is not modified due to [{}] being set to [{}]", new Object[]{filename, path, CONFLICT_RESOLUTION.getDisplayName(), conflictResolution.getDisplayName()});
    }

    private void handleUnexpectedError(ProcessSession session, FlowFile flowFile, Exception e) {
        flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
        flowFile = session.penalize(flowFile);
        session.transfer(flowFile, REL_FAILURE);
    }

    private void handleExpectedError(ProcessSession session, FlowFile flowFile, BoxAPIResponseException e) {
        flowFile = session.putAttribute(flowFile, "error.message", e.getMessage());
        flowFile = session.putAttribute(flowFile, "error.code", String.valueOf(e.getResponseCode()));
        flowFile = session.penalize(flowFile);
        session.transfer(flowFile, REL_FAILURE);
    }
}

