/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.process;

import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.nifi.bootstrap.process.AbstractFileBasedRuntimeValidator;
import org.apache.nifi.bootstrap.process.RuntimeValidatorResult;

public class SocketTimedWaitDuration
extends AbstractFileBasedRuntimeValidator {
    private static final String[] POSSIBLE_FILE_PATHS = new String[]{"/proc/sys/net/ipv4/tcp_tw_timeout", "/proc/sys/net/netfilter/nf_conntrack_tcp_timeout_time_wait", "/proc/sys/net/ipv4/netfilter/ip_conntrack_tcp_timeout_time_wait"};
    private static final Pattern PATTERN = Pattern.compile("\\d+");
    private static final int DESIRED_TIMED_WAIT_DURATION = 1;

    public SocketTimedWaitDuration() {
        super(SocketTimedWaitDuration.determineConfigurationFile());
    }

    SocketTimedWaitDuration(File configurationFile) {
        super(configurationFile);
    }

    @Override
    protected Pattern getPattern() {
        return PATTERN;
    }

    @Override
    protected void performChecks(Matcher matcher, List<RuntimeValidatorResult> results) {
        String configurationPath = this.getConfigurationFile().getAbsolutePath();
        if (matcher.find()) {
            int timedWaitDuration = Integer.parseInt(matcher.group());
            if (timedWaitDuration > 1) {
                RuntimeValidatorResult result = this.getResultBuilder(RuntimeValidatorResult.Outcome.FAILED).explanation(String.format("TCP Socket Wait [%d seconds] more than recommended [%d seconds] according to [%s]", timedWaitDuration, 1, configurationPath)).build();
                results.add(result);
            }
        } else {
            RuntimeValidatorResult result = this.getResultBuilder(RuntimeValidatorResult.Outcome.FAILED).explanation(String.format("Configuration file [%s] cannot be parsed", this.getConfigurationFile().getAbsolutePath())).build();
            results.add(result);
        }
    }

    private static File determineConfigurationFile() {
        for (String filePath : POSSIBLE_FILE_PATHS) {
            File file = new File(filePath);
            if (!file.canRead()) continue;
            return file;
        }
        return null;
    }
}

