/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.bootstrap.notification;

import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.nifi.attribute.expression.language.Query;
import org.apache.nifi.attribute.expression.language.StandardExpressionLanguageCompiler;
import org.apache.nifi.attribute.expression.language.StandardPropertyValue;
import org.apache.nifi.bootstrap.notification.NotificationContext;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.controller.ControllerServiceLookup;
import org.apache.nifi.expression.ExpressionLanguageCompiler;
import org.apache.nifi.registry.VariableRegistry;

public class NotificationValidationContext
implements ValidationContext {
    private final NotificationContext context;
    private final Map<String, Boolean> expressionLanguageSupported;
    private final VariableRegistry variableRegistry;

    public NotificationValidationContext(NotificationContext processContext, VariableRegistry variableRegistry) {
        this.context = processContext;
        Map<PropertyDescriptor, String> properties = processContext.getProperties();
        this.expressionLanguageSupported = new HashMap<String, Boolean>(properties.size());
        for (PropertyDescriptor descriptor : properties.keySet()) {
            this.expressionLanguageSupported.put(descriptor.getName(), descriptor.isExpressionLanguageSupported());
        }
        this.variableRegistry = variableRegistry;
    }

    public PropertyValue newPropertyValue(String rawValue) {
        return new StandardPropertyValue(rawValue, null, this.variableRegistry);
    }

    public ExpressionLanguageCompiler newExpressionLanguageCompiler() {
        return new StandardExpressionLanguageCompiler(null);
    }

    public ValidationContext getControllerServiceValidationContext(ControllerService controllerService) {
        throw new UnsupportedOperationException();
    }

    public PropertyValue getProperty(PropertyDescriptor property) {
        return this.context.getProperty(property);
    }

    public Map<PropertyDescriptor, String> getProperties() {
        return this.context.getProperties();
    }

    public Map<String, String> getAllProperties() {
        LinkedHashMap<String, String> propValueMap = new LinkedHashMap<String, String>();
        for (Map.Entry<PropertyDescriptor, String> entry : this.getProperties().entrySet()) {
            propValueMap.put(entry.getKey().getName(), entry.getValue());
        }
        return propValueMap;
    }

    public String getAnnotationData() {
        throw new UnsupportedOperationException();
    }

    public ControllerServiceLookup getControllerServiceLookup() {
        return null;
    }

    public boolean isValidationRequired(ControllerService service) {
        return true;
    }

    public boolean isExpressionLanguagePresent(String value) {
        if (value == null) {
            return false;
        }
        List elRanges = Query.extractExpressionRanges((String)value);
        return elRanges != null && !elRanges.isEmpty();
    }

    public boolean isExpressionLanguageSupported(String propertyName) {
        Boolean supported = this.expressionLanguageSupported.get(propertyName);
        return Boolean.TRUE.equals(supported);
    }

    public String getProcessGroupIdentifier() {
        return null;
    }
}

