/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage.utils;

import com.azure.core.credential.AccessToken;
import com.azure.core.credential.TokenCredential;
import com.azure.core.http.ProxyOptions;
import com.azure.core.http.netty.NettyAsyncHttpClientBuilder;
import com.azure.core.util.ClientOptions;
import com.azure.core.util.HttpClientOptions;
import com.azure.identity.ClientSecretCredentialBuilder;
import com.azure.identity.ManagedIdentityCredential;
import com.azure.identity.ManagedIdentityCredentialBuilder;
import com.azure.storage.common.StorageSharedKeyCredential;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.DataLakeServiceClientBuilder;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.processors.azure.storage.utils.AbstractStorageClientFactory;
import org.apache.nifi.services.azure.storage.ADLSCredentialsDetails;
import reactor.core.publisher.Mono;

public class DataLakeServiceClientFactory
extends AbstractStorageClientFactory<ADLSCredentialsDetails, DataLakeServiceClient> {
    public DataLakeServiceClientFactory(ComponentLog logger, ProxyOptions proxyOptions) {
        super(logger, proxyOptions);
    }

    @Override
    protected DataLakeServiceClient createStorageClient(ADLSCredentialsDetails credentialsDetails, ProxyOptions proxyOptions) {
        String accountName = credentialsDetails.getAccountName();
        String accountKey = credentialsDetails.getAccountKey();
        String sasToken = credentialsDetails.getSasToken();
        AccessToken accessToken = credentialsDetails.getAccessToken();
        String endpointSuffix = credentialsDetails.getEndpointSuffix();
        boolean useManagedIdentity = credentialsDetails.getUseManagedIdentity();
        String managedIdentityClientId = credentialsDetails.getManagedIdentityClientId();
        String servicePrincipalTenantId = credentialsDetails.getServicePrincipalTenantId();
        String servicePrincipalClientId = credentialsDetails.getServicePrincipalClientId();
        String servicePrincipalClientSecret = credentialsDetails.getServicePrincipalClientSecret();
        ProxyOptions credentialProxyOptions = credentialsDetails.getProxyOptions();
        String endpoint = String.format("https://%s.%s", accountName, endpointSuffix);
        DataLakeServiceClientBuilder dataLakeServiceClientBuilder = new DataLakeServiceClientBuilder();
        dataLakeServiceClientBuilder.endpoint(endpoint);
        if (StringUtils.isNotBlank((CharSequence)accountKey)) {
            credential = new StorageSharedKeyCredential(accountName, accountKey);
            dataLakeServiceClientBuilder.credential(credential);
        } else if (StringUtils.isNotBlank((CharSequence)sasToken)) {
            dataLakeServiceClientBuilder.sasToken(sasToken);
        } else if (accessToken != null) {
            credential = tokenRequestContext -> Mono.just((Object)accessToken);
            dataLakeServiceClientBuilder.credential((TokenCredential)credential);
        } else if (useManagedIdentity) {
            ManagedIdentityCredential misCredential = ((ManagedIdentityCredentialBuilder)new ManagedIdentityCredentialBuilder().clientId(managedIdentityClientId).httpClient(new NettyAsyncHttpClientBuilder().proxy(credentialProxyOptions).build())).build();
            dataLakeServiceClientBuilder.credential((TokenCredential)misCredential);
        } else if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{servicePrincipalTenantId, servicePrincipalClientId, servicePrincipalClientSecret})) {
            credential = ((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)((ClientSecretCredentialBuilder)new ClientSecretCredentialBuilder().tenantId(servicePrincipalTenantId)).clientId(servicePrincipalClientId)).clientSecret(servicePrincipalClientSecret).httpClient(new NettyAsyncHttpClientBuilder().proxy(credentialProxyOptions).build())).build();
            dataLakeServiceClientBuilder.credential((TokenCredential)credential);
        } else {
            throw new IllegalArgumentException("No valid credentials were provided");
        }
        HttpClientOptions clientOptions = new HttpClientOptions().setProxyOptions(proxyOptions);
        dataLakeServiceClientBuilder.clientOptions((ClientOptions)clientOptions);
        return dataLakeServiceClientBuilder.buildClient();
    }
}

