/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.azure.core.http.rest.Response;
import com.azure.core.util.Context;
import com.azure.core.util.FluxUtil;
import com.azure.storage.blob.BlobClient;
import com.azure.storage.blob.BlobContainerClient;
import com.azure.storage.blob.BlobServiceClient;
import com.azure.storage.blob.models.BlobErrorCode;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.BlobType;
import com.azure.storage.blob.models.BlockBlobItem;
import com.azure.storage.blob.options.BlobParallelUploadOptions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.behavior.WritesAttribute;
import org.apache.nifi.annotation.behavior.WritesAttributes;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.ValidationContext;
import org.apache.nifi.components.ValidationResult;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.fileresource.service.api.FileResource;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.azure.AbstractAzureBlobProcessor_v12;
import org.apache.nifi.processors.azure.ClientSideEncryptionSupport;
import org.apache.nifi.processors.azure.storage.CopyAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.DeleteAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.FetchAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.ListAzureBlobStorage_v12;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;
import org.apache.nifi.processors.transfer.ResourceTransferProperties;
import org.apache.nifi.processors.transfer.ResourceTransferSource;
import org.apache.nifi.processors.transfer.ResourceTransferUtils;
import org.apache.nifi.services.azure.storage.AzureStorageConflictResolutionStrategy;

@Tags(value={"azure", "microsoft", "cloud", "storage", "blob"})
@SeeAlso(value={ListAzureBlobStorage_v12.class, FetchAzureBlobStorage_v12.class, DeleteAzureBlobStorage_v12.class, CopyAzureBlobStorage_v12.class})
@CapabilityDescription(value="Puts content into a blob on Azure Blob Storage. The processor uses Azure Blob Storage client library v12.")
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
@WritesAttributes(value={@WritesAttribute(attribute="azure.container", description="The name of the Azure Blob Storage container"), @WritesAttribute(attribute="azure.blobname", description="The name of the blob on Azure Blob Storage"), @WritesAttribute(attribute="azure.primaryUri", description="Primary location of the blob"), @WritesAttribute(attribute="azure.etag", description="ETag of the blob"), @WritesAttribute(attribute="azure.blobtype", description="Type of the blob (either BlockBlob, PageBlob or AppendBlob)"), @WritesAttribute(attribute="mime.type", description="MIME Type of the content"), @WritesAttribute(attribute="lang", description="Language code for the content"), @WritesAttribute(attribute="azure.timestamp", description="Timestamp of the blob"), @WritesAttribute(attribute="azure.length", description="Length of the blob"), @WritesAttribute(attribute="azure.error.code", description="Error code reported during blob operation"), @WritesAttribute(attribute="azure.ignored", description="When Conflict Resolution Strategy is 'ignore', this property will be true/false depending on whether the blob was ignored.")})
public class PutAzureBlobStorage_v12
extends AbstractAzureBlobProcessor_v12
implements ClientSideEncryptionSupport {
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(AzureStorageUtils.BLOB_STORAGE_CREDENTIALS_SERVICE, AzureStorageUtils.CONTAINER, AzureStorageUtils.CREATE_CONTAINER, AzureStorageUtils.CONFLICT_RESOLUTION, BLOB_NAME, ResourceTransferProperties.RESOURCE_TRANSFER_SOURCE, ResourceTransferProperties.FILE_RESOURCE_SERVICE, AzureStorageUtils.PROXY_CONFIGURATION_SERVICE, CSE_KEY_TYPE, CSE_KEY_ID, CSE_LOCAL_KEY);

    protected Collection<ValidationResult> customValidate(ValidationContext validationContext) {
        ArrayList<ValidationResult> results = new ArrayList<ValidationResult>(super.customValidate(validationContext));
        results.addAll(this.validateClientSideEncryptionProperties(validationContext));
        return results;
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String containerName = context.getProperty(AzureStorageUtils.CONTAINER).evaluateAttributeExpressions(flowFile).getValue();
        boolean createContainer = context.getProperty(AzureStorageUtils.CREATE_CONTAINER).asBoolean();
        String blobName = context.getProperty(BLOB_NAME).evaluateAttributeExpressions(flowFile).getValue();
        AzureStorageConflictResolutionStrategy conflictResolution = (AzureStorageConflictResolutionStrategy)context.getProperty(AzureStorageUtils.CONFLICT_RESOLUTION).asAllowableValue(AzureStorageConflictResolutionStrategy.class);
        ResourceTransferSource resourceTransferSource = ResourceTransferSource.valueOf((String)context.getProperty(ResourceTransferProperties.RESOURCE_TRANSFER_SOURCE).getValue());
        long startNanos = System.nanoTime();
        try {
            Optional fileResourceFound = ResourceTransferUtils.getFileResource((ResourceTransferSource)resourceTransferSource, (ProcessContext)context, (Map)flowFile.getAttributes());
            BlobServiceClient storageClient = this.getStorageClient((PropertyContext)context, flowFile);
            BlobContainerClient containerClient = storageClient.getBlobContainerClient(containerName);
            if (createContainer && !containerClient.exists()) {
                containerClient.create();
            }
            BlobClient blobClient = this.isClientSideEncryptionEnabled((PropertyContext)context) ? this.getEncryptedBlobClient((PropertyContext)context, containerClient, blobName) : containerClient.getBlobClient(blobName);
            BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
            HashMap<String, String> attributes = new HashMap<String, String>();
            this.applyStandardBlobAttributes(attributes, blobClient);
            boolean ignore = conflictResolution == AzureStorageConflictResolutionStrategy.IGNORE_RESOLUTION;
            try {
                if (conflictResolution != AzureStorageConflictResolutionStrategy.REPLACE_RESOLUTION) {
                    blobRequestConditions.setIfNoneMatch("*");
                }
                long transferSize = fileResourceFound.map(FileResource::getSize).orElse(flowFile.getSize());
                FlowFile sourceFlowFile = flowFile;
                try (InputStream sourceInputStream = fileResourceFound.map(FileResource::getInputStream).orElseGet(() -> session.read(sourceFlowFile));){
                    BlobParallelUploadOptions blobParallelUploadOptions = new BlobParallelUploadOptions(FluxUtil.toFluxByteBuffer((InputStream)sourceInputStream, (int)0x400000));
                    blobParallelUploadOptions.setRequestConditions(blobRequestConditions);
                    Response response = blobClient.uploadWithResponse(blobParallelUploadOptions, null, Context.NONE);
                    BlockBlobItem blob = (BlockBlobItem)response.getValue();
                    PutAzureBlobStorage_v12.applyUploadResultAttributes(attributes, blob, BlobType.BLOCK_BLOB, transferSize);
                    this.applyBlobMetadata(attributes, blobClient);
                    if (ignore) {
                        attributes.put("azure.ignored", "false");
                    }
                }
            }
            catch (BlobStorageException e) {
                BlobErrorCode errorCode = e.getErrorCode();
                flowFile = session.putAttribute(flowFile, "azure.error.code", e.getErrorCode().toString());
                if (errorCode == BlobErrorCode.BLOB_ALREADY_EXISTS && ignore) {
                    this.getLogger().info("Blob already exists: remote blob not modified. Transferring {} to success", new Object[]{flowFile});
                    attributes.put("azure.ignored", "true");
                }
                throw e;
            }
            flowFile = session.putAllAttributes(flowFile, attributes);
            session.transfer(flowFile, REL_SUCCESS);
            long transferMillis = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startNanos);
            String transitUri = (String)attributes.get("azure.primaryUri");
            session.getProvenanceReporter().send(flowFile, transitUri, transferMillis);
        }
        catch (Exception e) {
            this.getLogger().error("Failed to create blob on Azure Blob Storage", (Throwable)e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("blob-name", BLOB_NAME.getName());
        config.renameProperty("conflict-resolution-strategy", AzureStorageUtils.CONFLICT_RESOLUTION.getName());
        config.renameProperty("create-container", AzureStorageUtils.CREATE_CONTAINER.getName());
        config.renameProperty("container-name", AzureStorageUtils.CONTAINER.getName());
        config.renameProperty("storage-credentials-service", AzureStorageUtils.BLOB_STORAGE_CREDENTIALS_SERVICE.getName());
    }

    private static void applyUploadResultAttributes(Map<String, String> attributes, BlockBlobItem blob, BlobType blobType, long length) {
        attributes.put("azure.blobtype", blobType.toString());
        attributes.put("azure.etag", blob.getETag());
        attributes.put("azure.length", String.valueOf(length));
        attributes.put("azure.timestamp", String.valueOf(blob.getLastModified()));
        attributes.put("lang", null);
        attributes.put("mime.type", "application/octet-stream");
    }
}

