/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.eventhub.checkpoint;

import com.azure.messaging.eventhubs.models.Checkpoint;
import com.azure.messaging.eventhubs.models.PartitionContext;
import com.azure.messaging.eventhubs.models.PartitionOwnership;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.azure.eventhub.checkpoint.CheckpointStoreKeyPrefix;

final class ComponentStateCheckpointStoreUtils {
    private ComponentStateCheckpointStoreUtils() {
    }

    static PartitionOwnership convertOwnership(String key, String value) {
        PartitionContext context = ComponentStateCheckpointStoreUtils.convertPartitionContext(key);
        String[] parts = value.split("/", 3);
        if (parts.length != 3) {
            throw new ProcessException(String.format("Invalid ownership value: %s", value));
        }
        return new PartitionOwnership().setFullyQualifiedNamespace(context.getFullyQualifiedNamespace()).setEventHubName(context.getEventHubName()).setConsumerGroup(context.getConsumerGroup()).setPartitionId(context.getPartitionId()).setOwnerId(parts[0]).setLastModifiedTime(Long.valueOf(Long.parseLong(parts[1]))).setETag(parts[2]);
    }

    static Checkpoint convertCheckpoint(String key, String value) {
        PartitionContext context = ComponentStateCheckpointStoreUtils.convertPartitionContext(key);
        String[] parts = value.split("/", 2);
        if (parts.length != 2) {
            throw new ProcessException(String.format("Invalid checkpoint value: %s", value));
        }
        return new Checkpoint().setFullyQualifiedNamespace(context.getFullyQualifiedNamespace()).setEventHubName(context.getEventHubName()).setConsumerGroup(context.getConsumerGroup()).setPartitionId(context.getPartitionId()).setOffsetString(StringUtils.isNotEmpty((CharSequence)parts[0]) ? parts[0] : null).setSequenceNumber(StringUtils.isNotEmpty((CharSequence)parts[1]) ? Long.valueOf(Long.parseLong(parts[1])) : null);
    }

    static PartitionContext convertPartitionContext(String key) {
        String[] parts = key.split("/", 5);
        if (parts.length != 5) {
            throw new ProcessException(String.format("Invalid entry key: %s", key));
        }
        String fullyQualifiedNamespace = parts[1];
        String eventHubName = parts[2];
        String consumerGroup = parts[3];
        String partitionId = parts[4];
        return new PartitionContext(fullyQualifiedNamespace, eventHubName, consumerGroup, partitionId);
    }

    static String createOwnershipKey(PartitionOwnership partitionOwnership) {
        return ComponentStateCheckpointStoreUtils.createKey(CheckpointStoreKeyPrefix.OWNERSHIP.keyPrefix(), partitionOwnership.getFullyQualifiedNamespace(), partitionOwnership.getEventHubName(), partitionOwnership.getConsumerGroup(), partitionOwnership.getPartitionId());
    }

    static String createCheckpointKey(Checkpoint checkpoint) {
        return ComponentStateCheckpointStoreUtils.createKey(CheckpointStoreKeyPrefix.CHECKPOINT.keyPrefix(), checkpoint.getFullyQualifiedNamespace(), checkpoint.getEventHubName(), checkpoint.getConsumerGroup(), checkpoint.getPartitionId());
    }

    private static String createKey(String kind, String fullyQualifiedNamespace, String eventHubName, String consumerGroup, String partitionId) {
        return String.format("%s/%s/%s/%s/%s", kind, fullyQualifiedNamespace, eventHubName, consumerGroup, partitionId);
    }

    static String createOwnershipValue(PartitionOwnership partitionOwnership) {
        return String.format("%s/%s/%s", partitionOwnership.getOwnerId(), partitionOwnership.getLastModifiedTime(), partitionOwnership.getETag());
    }

    static String createCheckpointValue(Checkpoint checkpoint) {
        return String.format("%s/%s", checkpoint.getOffsetString() != null ? checkpoint.getOffsetString() : "", checkpoint.getSequenceNumber() != null ? checkpoint.getSequenceNumber().toString() : "");
    }

    static String ownershipToString(PartitionOwnership partitionOwnership) {
        return "PartitionOwnership{fullyQualifiedNamespace='" + partitionOwnership.getFullyQualifiedNamespace() + "', eventHubName='" + partitionOwnership.getEventHubName() + "', consumerGroup='" + partitionOwnership.getConsumerGroup() + "', partitionId='" + partitionOwnership.getPartitionId() + "', ownerId='" + partitionOwnership.getOwnerId() + "', lastModifiedTime=" + partitionOwnership.getLastModifiedTime() + ", eTag='" + partitionOwnership.getETag() + "'}";
    }

    static List<String> ownershipListToString(List<PartitionOwnership> partitionOwnershipList) {
        return partitionOwnershipList.stream().map(ComponentStateCheckpointStoreUtils::ownershipToString).collect(Collectors.toList());
    }

    static String checkpointToString(Checkpoint checkpoint) {
        return "Checkpoint{fullyQualifiedNamespace='" + checkpoint.getFullyQualifiedNamespace() + "', eventHubName='" + checkpoint.getEventHubName() + "', consumerGroup='" + checkpoint.getConsumerGroup() + "', partitionId='" + checkpoint.getPartitionId() + "', offset=" + checkpoint.getOffsetString() + ", sequenceNumber=" + checkpoint.getSequenceNumber() + "}";
    }
}

