/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage;

import com.azure.core.util.Context;
import com.azure.storage.file.datalake.DataLakeDirectoryClient;
import com.azure.storage.file.datalake.DataLakeFileClient;
import com.azure.storage.file.datalake.DataLakeFileSystemClient;
import com.azure.storage.file.datalake.DataLakeServiceClient;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import java.time.Duration;
import java.util.List;
import org.apache.nifi.annotation.behavior.InputRequirement;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.SeeAlso;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processors.azure.AbstractAzureDataLakeStorageProcessor;
import org.apache.nifi.processors.azure.storage.FetchAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.ListAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.PutAzureDataLakeStorage;
import org.apache.nifi.processors.azure.storage.utils.AzureStorageUtils;

@Tags(value={"azure", "microsoft", "cloud", "storage", "adlsgen2", "datalake"})
@SeeAlso(value={PutAzureDataLakeStorage.class, FetchAzureDataLakeStorage.class, ListAzureDataLakeStorage.class})
@CapabilityDescription(value="Deletes the provided file from Azure Data Lake Storage")
@InputRequirement(value=InputRequirement.Requirement.INPUT_REQUIRED)
public class DeleteAzureDataLakeStorage
extends AbstractAzureDataLakeStorageProcessor {
    public static final AllowableValue FS_TYPE_FILE = new AllowableValue("file", "File", "The object to be deleted is a file.");
    public static final AllowableValue FS_TYPE_DIRECTORY = new AllowableValue("directory", "Directory", "The object to be deleted is a directory.");
    public static final PropertyDescriptor FILESYSTEM_OBJECT_TYPE = new PropertyDescriptor.Builder().name("filesystem-object-type").displayName("Filesystem Object Type").description("They type of the file system object to be deleted. It can be either folder or file.").allowableValues(new DescribedValue[]{FS_TYPE_FILE, FS_TYPE_DIRECTORY}).defaultValue((DescribedValue)FS_TYPE_FILE).required(true).build();
    public static final PropertyDescriptor FILE = new PropertyDescriptor.Builder().fromPropertyDescriptor(AzureStorageUtils.FILE).dependsOn(FILESYSTEM_OBJECT_TYPE, new AllowableValue[]{FS_TYPE_FILE}).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(AzureStorageUtils.ADLS_CREDENTIALS_SERVICE, AzureStorageUtils.FILESYSTEM, FILESYSTEM_OBJECT_TYPE, AzureStorageUtils.DIRECTORY, FILE, AzureStorageUtils.PROXY_CONFIGURATION_SERVICE);

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        try {
            boolean isFile = context.getProperty(FILESYSTEM_OBJECT_TYPE).getValue().equals(FS_TYPE_FILE.getValue());
            DataLakeServiceClient storageClient = this.getStorageClient((PropertyContext)context, flowFile);
            String fileSystem = AzureStorageUtils.evaluateFileSystemProperty(AzureStorageUtils.FILESYSTEM, (PropertyContext)context, flowFile);
            DataLakeFileSystemClient fileSystemClient = storageClient.getFileSystemClient(fileSystem);
            String directory = AzureStorageUtils.evaluateDirectoryProperty(AzureStorageUtils.DIRECTORY, (PropertyContext)context, flowFile);
            DataLakeDirectoryClient directoryClient = fileSystemClient.getDirectoryClient(directory);
            if (isFile) {
                String fileName = AzureStorageUtils.evaluateFileProperty((PropertyContext)context, flowFile);
                DataLakeFileClient fileClient = directoryClient.getFileClient(fileName);
                fileClient.delete();
                session.transfer(flowFile, REL_SUCCESS);
                session.getProvenanceReporter().invokeRemoteProcess(flowFile, fileClient.getFileUrl(), "File deleted");
            } else {
                directoryClient.deleteWithResponse(true, new DataLakeRequestConditions(), Duration.ofSeconds(10L), Context.NONE);
                session.transfer(flowFile, REL_SUCCESS);
                session.getProvenanceReporter().invokeRemoteProcess(flowFile, directoryClient.getDirectoryUrl(), "Directory deleted");
            }
        }
        catch (Exception e) {
            this.getLogger().error("Failed to delete the specified file from Azure Data Lake Storage", (Throwable)e);
            flowFile = session.penalize(flowFile);
            session.transfer(flowFile, REL_FAILURE);
        }
    }

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }
}

