/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.azure.storage.utils;

import org.apache.nifi.components.DescribedValue;

public enum WritingStrategy implements DescribedValue
{
    WRITE_AND_RENAME("Write and Rename", "The processor writes the Azure file into a temporary directory and then renames/moves it to the final destination. This prevents other processes from reading partially written files."),
    SIMPLE_WRITE("Simple Write", "The processor writes the Azure file directly to the destination. This might result in the reading of partially written files.");

    private final String displayName;
    private final String description;

    private WritingStrategy(String displayName, String description) {
        this.displayName = displayName;
        this.description = description;
    }

    public String getValue() {
        return this.name();
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getDescription() {
        return this.description;
    }
}

