/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization.azure;

import com.google.gson.JsonObject;
import com.microsoft.graph.authentication.IAuthenticationProvider;
import com.microsoft.graph.core.ClientException;
import com.microsoft.graph.models.extensions.IGraphServiceClient;
import com.microsoft.graph.options.Option;
import com.microsoft.graph.options.QueryOption;
import com.microsoft.graph.requests.extensions.GraphServiceClient;
import com.microsoft.graph.requests.extensions.IGroupCollectionPage;
import com.microsoft.graph.requests.extensions.IGroupCollectionRequest;
import com.microsoft.graph.requests.extensions.IGroupCollectionRequestBuilder;
import com.microsoft.graph.requests.extensions.IUserCollectionWithReferencesPage;
import com.microsoft.graph.requests.extensions.IUserCollectionWithReferencesRequest;
import com.microsoft.graph.requests.extensions.IUserCollectionWithReferencesRequestBuilder;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.nifi.authorization.AuthorizerConfigurationContext;
import org.apache.nifi.authorization.Group;
import org.apache.nifi.authorization.User;
import org.apache.nifi.authorization.UserAndGroups;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.authorization.UserGroupProviderInitializationContext;
import org.apache.nifi.authorization.azure.ClientCredentialAuthProvider;
import org.apache.nifi.authorization.azure.ImmutableAzureGraphUserGroup;
import org.apache.nifi.authorization.exception.AuthorizationAccessException;
import org.apache.nifi.authorization.exception.AuthorizerCreationException;
import org.apache.nifi.authorization.exception.AuthorizerDestructionException;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.util.FormatUtils;
import org.apache.nifi.util.StopWatch;
import org.apache.nifi.util.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AzureGraphUserGroupProvider
implements UserGroupProvider {
    private static final Logger logger = LoggerFactory.getLogger(AzureGraphUserGroupProvider.class);
    private String claimForUserName;
    private ScheduledExecutorService scheduler;
    public static final String REFRESH_DELAY_PROPERTY = "Refresh Delay";
    private static final long MINIMUM_SYNC_INTERVAL_MILLISECONDS = 10000L;
    public static final String AUTHORITY_ENDPOINT_PROPERTY = "Authority Endpoint";
    public static final String GRAPH_ENDPOINT_PROPERTY = "Graph Endpoint";
    public static final String GRAPH_SCOPE_PROPERTY = "Graph Scope";
    public static final String TENANT_ID_PROPERTY = "Directory ID";
    public static final String APP_REG_CLIENT_ID_PROPERTY = "Application ID";
    public static final String APP_REG_CLIENT_SECRET_PROPERTY = "Client Secret";
    public static final String GROUP_FILTER_LIST_PROPERTY = "Group Filter List Inclusion";
    public static final String GROUP_FILTER_PREFIX_PROPERTY = "Group Filter Prefix";
    public static final String GROUP_FILTER_SUFFIX_PROPERTY = "Group Filter Suffix";
    public static final String GROUP_FILTER_SUBSTRING_PROPERTY = "Group Filter Substring";
    public static final String PAGE_SIZE_PROPERTY = "Page Size";
    public static final String CLAIM_FOR_USERNAME = "Claim for Username";
    public static final String DEFAULT_REFRESH_DELAY = "5 mins";
    public static final String DEFAULT_PAGE_SIZE = "50";
    public static final String DEFAULT_CLAIM_FOR_USERNAME = "upn";
    public static final int MAX_PAGE_SIZE = 999;
    public static final String AZURE_PUBLIC_CLOUD = "https://login.microsoftonline.com/";
    public static final String AZURE_PUBLIC_GRAPH_DEFAULT_SCOPE = "https://graph.microsoft.com/.default";
    static final List<String> REST_CALL_KEYWORDS = Arrays.asList("$select", "$top", "$expand", "$search", "$filter", "$format", "$count", "$skip", "$orderby");
    private IGraphServiceClient graphClient;
    private final AtomicReference<ImmutableAzureGraphUserGroup> azureGraphUserGroupRef = new AtomicReference();

    public Group getGroup(String identifier) throws AuthorizationAccessException {
        return this.azureGraphUserGroupRef.get().getGroup(identifier);
    }

    public Set<Group> getGroups() throws AuthorizationAccessException {
        return this.azureGraphUserGroupRef.get().getGroups();
    }

    public User getUser(String identifier) throws AuthorizationAccessException {
        return this.azureGraphUserGroupRef.get().getUser(identifier);
    }

    public UserAndGroups getUserAndGroups(String principalName) throws AuthorizationAccessException {
        return this.azureGraphUserGroupRef.get().getUserAndGroups(principalName);
    }

    public User getUserByIdentity(String principalName) throws AuthorizationAccessException {
        return this.azureGraphUserGroupRef.get().getUserByPrincipalName(principalName);
    }

    public Set<User> getUsers() throws AuthorizationAccessException {
        return this.azureGraphUserGroupRef.get().getUsers();
    }

    public void initialize(final UserGroupProviderInitializationContext initializationContext) throws AuthorizerCreationException {
        this.scheduler = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(@NotNull Runnable r) {
                Thread thread = Executors.defaultThreadFactory().newThread(r);
                thread.setName(String.format("%s (%s) - UserGroup Refresh", this.getClass().getSimpleName(), initializationContext.getIdentifier()));
                return thread;
            }
        });
    }

    private String getProperty(AuthorizerConfigurationContext authContext, String propertyName, String defaultValue) {
        String value;
        PropertyValue property = authContext.getProperty(propertyName);
        if (property != null && property.isSet() && StringUtils.isNotBlank((String)(value = property.getValue()))) {
            return value;
        }
        return defaultValue;
    }

    private long getDelayProperty(AuthorizerConfigurationContext authContext, String propertyName, String defaultValue) {
        long syncInterval;
        String propertyValue = this.getProperty(authContext, propertyName, defaultValue);
        try {
            syncInterval = Math.round(FormatUtils.getPreciseTimeDuration((String)propertyValue, (TimeUnit)TimeUnit.MILLISECONDS));
        }
        catch (IllegalArgumentException ignored) {
            throw new AuthorizerCreationException(String.format("The %s '%s' is not a valid time interval.", propertyName, propertyValue));
        }
        if (syncInterval < 10000L) {
            throw new AuthorizerCreationException(String.format("The %s '%s' is below the minimum value of '%d ms'", propertyName, propertyValue, 10000L));
        }
        return syncInterval;
    }

    private boolean hasReservedKeyword(String prefix) {
        return REST_CALL_KEYWORDS.contains(prefix);
    }

    public void onConfigured(AuthorizerConfigurationContext configurationContext) throws AuthorizerCreationException {
        long fixedDelay = this.getDelayProperty(configurationContext, REFRESH_DELAY_PROPERTY, DEFAULT_REFRESH_DELAY);
        String authorityEndpoint = this.getProperty(configurationContext, AUTHORITY_ENDPOINT_PROPERTY, AZURE_PUBLIC_CLOUD);
        String graphEndpoint = this.getProperty(configurationContext, GRAPH_ENDPOINT_PROPERTY, null);
        String graphScope = this.getProperty(configurationContext, GRAPH_SCOPE_PROPERTY, AZURE_PUBLIC_GRAPH_DEFAULT_SCOPE);
        String tenantId = this.getProperty(configurationContext, TENANT_ID_PROPERTY, null);
        String clientId = this.getProperty(configurationContext, APP_REG_CLIENT_ID_PROPERTY, null);
        String clientSecret = this.getProperty(configurationContext, APP_REG_CLIENT_SECRET_PROPERTY, null);
        int pageSize = Integer.parseInt(this.getProperty(configurationContext, PAGE_SIZE_PROPERTY, DEFAULT_PAGE_SIZE));
        this.claimForUserName = this.getProperty(configurationContext, CLAIM_FOR_USERNAME, DEFAULT_CLAIM_FOR_USERNAME);
        String providerClassName = this.getClass().getSimpleName();
        if (StringUtils.isBlank((String)tenantId)) {
            throw new AuthorizerCreationException(String.format("%s is a required field for %s", TENANT_ID_PROPERTY, providerClassName));
        }
        if (StringUtils.isBlank((String)clientId)) {
            throw new AuthorizerCreationException(String.format("%s is a required field for %s", APP_REG_CLIENT_ID_PROPERTY, providerClassName));
        }
        if (StringUtils.isBlank((String)clientSecret)) {
            throw new AuthorizerCreationException(String.format("%s is a required field for %s", APP_REG_CLIENT_SECRET_PROPERTY, providerClassName));
        }
        if (pageSize > 999) {
            throw new AuthorizerCreationException(String.format("Max page size for Microsoft Graph is %d.", 999));
        }
        try {
            ClientCredentialAuthProvider authProvider = new ClientCredentialAuthProvider.Builder().authorityEndpoint(authorityEndpoint).tenantId(tenantId).clientId(clientId).clientSecret(clientSecret).graphScope(graphScope).build();
            this.graphClient = GraphServiceClient.builder().authenticationProvider((IAuthenticationProvider)authProvider).buildClient();
            if (!StringUtils.isBlank((String)graphEndpoint)) {
                this.graphClient.setServiceRoot(graphEndpoint);
            }
        }
        catch (ClientException e) {
            throw new AuthorizerCreationException(String.format("Failed to create a GraphServiceClient due to %s", e.getMessage()), (Throwable)e);
        }
        String prefix = this.getProperty(configurationContext, GROUP_FILTER_PREFIX_PROPERTY, null);
        String suffix = this.getProperty(configurationContext, GROUP_FILTER_SUFFIX_PROPERTY, null);
        String substring = this.getProperty(configurationContext, GROUP_FILTER_SUBSTRING_PROPERTY, null);
        String groupFilterList = this.getProperty(configurationContext, GROUP_FILTER_LIST_PROPERTY, null);
        if (StringUtils.isBlank((String)prefix) && StringUtils.isBlank((String)suffix) && StringUtils.isBlank((String)substring) && StringUtils.isBlank((String)groupFilterList)) {
            throw new AuthorizerCreationException(String.format("At least one group filter (%s, %s, %s) should be specified for %s", GROUP_FILTER_PREFIX_PROPERTY, GROUP_FILTER_SUFFIX_PROPERTY, GROUP_FILTER_LIST_PROPERTY, providerClassName));
        }
        if (this.hasReservedKeyword(prefix)) {
            throw new AuthorizerCreationException(String.format("Prefix shouldn't have any reserved keywords ([%s])", StringUtils.join(REST_CALL_KEYWORDS, (String)",")));
        }
        try {
            this.refreshUserGroup(groupFilterList, prefix, suffix, substring, pageSize);
        }
        catch (ClientException | IOException e) {
            throw new AuthorizerCreationException(String.format("Failed to load UserGroup due to %s", e.getMessage()), e);
        }
        this.scheduler.scheduleWithFixedDelay(() -> {
            try {
                this.refreshUserGroup(groupFilterList, prefix, suffix, substring, pageSize);
            }
            catch (Throwable t) {
                logger.error("Error refreshing user groups due to {}", (Object)t.getMessage(), (Object)t);
            }
        }, fixedDelay, fixedDelay, TimeUnit.MILLISECONDS);
    }

    private void refreshUserGroup(String groupFilterList, String prefix, String suffix, String substring, int pageSize) throws IOException, ClientException {
        if (logger.isDebugEnabled()) {
            logger.debug("Refreshing user groups");
        }
        StopWatch stopWatch = new StopWatch(true);
        Set<String> groupDisplayNames = this.getGroupsWith(groupFilterList, prefix, suffix, substring, pageSize);
        this.refreshUserGroupData(groupDisplayNames, pageSize);
        stopWatch.stop();
        if (logger.isDebugEnabled()) {
            logger.debug("Refreshed {} user groups in {}", (Object)groupDisplayNames.size(), (Object)stopWatch.getDuration());
        }
    }

    private Set<String> getGroupsWith(String groupFilterList, String prefix, String suffix, String substring, int pageSize) {
        HashSet<String> groupDisplayNames = new HashSet<String>();
        if (!(StringUtils.isBlank((String)prefix) && StringUtils.isBlank((String)suffix) && StringUtils.isBlank((String)substring))) {
            groupDisplayNames.addAll(this.queryGroupsWith(prefix, suffix, substring, pageSize));
        }
        if (!StringUtils.isBlank((String)groupFilterList)) {
            groupDisplayNames.addAll(Arrays.stream(groupFilterList.split(",")).map(String::trim).filter(s -> !s.isEmpty()).toList());
        }
        return Collections.unmodifiableSet(groupDisplayNames);
    }

    private Set<String> queryGroupsWith(String prefix, String suffix, String substring, int pageSize) {
        IGroupCollectionRequest gRequest;
        HashSet<String> groups = new HashSet<String>();
        if (prefix != null && !prefix.isEmpty()) {
            List<QueryOption> requestOptions = List.of(new QueryOption("$filter", (Object)String.format("startswith(displayName, '%s')", prefix)));
            gRequest = this.graphClient.groups().buildRequest(requestOptions).select("displayName");
        } else {
            gRequest = this.graphClient.groups().buildRequest(new Option[0]).select("displayName");
        }
        if (pageSize > 0) {
            gRequest = gRequest.top(pageSize);
        }
        IGroupCollectionPage filterResults = gRequest.get();
        List currentPage = filterResults.getCurrentPage();
        while (currentPage != null) {
            for (com.microsoft.graph.models.extensions.Group grp : currentPage) {
                boolean substringMatches;
                boolean suffixMatches = StringUtils.isEmpty((String)suffix) || grp.displayName.endsWith(suffix);
                boolean bl = substringMatches = StringUtils.isEmpty((String)substring) || grp.displayName.contains(substring);
                if (!suffixMatches || !substringMatches) continue;
                groups.add(grp.displayName);
            }
            IGroupCollectionRequestBuilder gBuilder = (IGroupCollectionRequestBuilder)filterResults.getNextPage();
            if (gBuilder != null) {
                filterResults = gBuilder.buildRequest(new Option[0]).get();
                currentPage = filterResults.getCurrentPage();
                continue;
            }
            currentPage = null;
        }
        return Collections.unmodifiableSet(groups);
    }

    private UserGroupQueryResult getUsersFrom(String groupName, int pageSize) throws IOException, ClientException {
        HashSet<User> users = new HashSet<User>();
        List<QueryOption> requestOptions = List.of(new QueryOption("$filter", (Object)String.format("displayName eq '%s'", groupName)));
        IGroupCollectionPage results = this.graphClient.groups().buildRequest(requestOptions).get();
        List currentPage = results.getCurrentPage();
        if (currentPage != null && !currentPage.isEmpty()) {
            com.microsoft.graph.models.extensions.Group graphGroup = (com.microsoft.graph.models.extensions.Group)results.getCurrentPage().getFirst();
            Group.Builder groupBuilder = new Group.Builder().identifier(graphGroup.id).name(graphGroup.displayName);
            IUserCollectionWithReferencesRequest uRequest = this.graphClient.groups(graphGroup.id).transitiveMembersAsUser().buildRequest(new Option[0]).select("id, displayName, mail, userPrincipalName");
            IUserCollectionWithReferencesPage userpage = uRequest.get();
            while (userpage != null && userpage.getCurrentPage() != null) {
                for (com.microsoft.graph.models.extensions.User userDO : userpage.getCurrentPage()) {
                    JsonObject jsonUser = userDO.getRawObject();
                    String idUser = !jsonUser.get("id").isJsonNull() ? jsonUser.get("id").getAsString() : "";
                    String userName = this.claimForUserName.equals("email") ? (!jsonUser.get("mail").isJsonNull() ? jsonUser.get("mail").getAsString() : jsonUser.get("userPrincipalName").getAsString()) : jsonUser.get("userPrincipalName").getAsString();
                    User user = new User.Builder().identifier(idUser).identity(userName).build();
                    users.add(user);
                    groupBuilder.addUser(idUser);
                }
                IUserCollectionWithReferencesRequestBuilder nextPageRequest = (IUserCollectionWithReferencesRequestBuilder)userpage.getNextPage();
                if (nextPageRequest == null) break;
                userpage = nextPageRequest.buildRequest(new Option[0]).get();
            }
            Group group = groupBuilder.build();
            return new UserGroupQueryResult(group, users);
        }
        return null;
    }

    private void refreshUserGroupData(Set<String> groupDisplayNames, int pageSize) throws IOException, ClientException {
        Objects.requireNonNull(groupDisplayNames);
        HashSet<User> users = new HashSet<User>();
        HashSet<Group> groups = new HashSet<Group>();
        for (String grpFilter : groupDisplayNames) {
            UserGroupQueryResult queryResult;
            if (logger.isDebugEnabled()) {
                logger.debug("Getting users for group filter: {}", (Object)grpFilter);
            }
            if ((queryResult = this.getUsersFrom(grpFilter, pageSize)) == null) continue;
            groups.add(queryResult.getGroup());
            users.addAll(queryResult.getUsers());
        }
        ImmutableAzureGraphUserGroup azureGraphUserGroup = ImmutableAzureGraphUserGroup.newInstance(users, groups);
        this.azureGraphUserGroupRef.set(azureGraphUserGroup);
    }

    public void preDestruction() throws AuthorizerDestructionException {
        this.scheduler.shutdown();
        try {
            if (!this.scheduler.awaitTermination(10000L, TimeUnit.MILLISECONDS)) {
                this.scheduler.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            logger.warn("Error shutting down user group refresh scheduler due to {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private static class UserGroupQueryResult {
        private final Group group;
        private final Set<User> users;

        public UserGroupQueryResult(Group group, Set<User> users) {
            this.group = group;
            this.users = users;
        }

        public Group getGroup() {
            return this.group;
        }

        public Set<User> getUsers() {
            return this.users;
        }
    }
}

