/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.aws.schemaregistry.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.UUID;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.aws.schemaregistry.client.SchemaRegistryClient;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;
import software.amazon.awssdk.services.glue.GlueClient;
import software.amazon.awssdk.services.glue.model.DataFormat;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionRequest;
import software.amazon.awssdk.services.glue.model.GetSchemaVersionResponse;
import software.amazon.awssdk.services.glue.model.SchemaId;
import software.amazon.awssdk.services.glue.model.SchemaVersionNumber;

public class GlueSchemaRegistryClient
implements SchemaRegistryClient {
    private static final ObjectMapper OBJECT_MAPPER = new ObjectMapper();
    private static final String NAMESPACE_FIELD_NAME = "namespace";
    private final GlueClient client;
    private final String registryName;

    public GlueSchemaRegistryClient(GlueClient client, String registryName) {
        this.client = client;
        this.registryName = registryName;
    }

    @Override
    public RecordSchema getSchema(String schemaName) throws IOException, SchemaNotFoundException {
        SchemaVersionNumber schemaVersionNumber = (SchemaVersionNumber)SchemaVersionNumber.builder().latestVersion(Boolean.valueOf(true)).build();
        GetSchemaVersionResponse schemaVersionResponse = this.getSchemaVersionResponse(schemaName, schemaVersionNumber);
        return this.createRecordSchema(schemaVersionResponse);
    }

    @Override
    public RecordSchema getSchema(String schemaName, long version) throws IOException, SchemaNotFoundException {
        SchemaVersionNumber schemaVersionNumber = (SchemaVersionNumber)SchemaVersionNumber.builder().versionNumber(Long.valueOf(version)).build();
        GetSchemaVersionResponse schemaVersionResponse = this.getSchemaVersionResponse(schemaName, schemaVersionNumber);
        return this.createRecordSchema(schemaVersionResponse);
    }

    @Override
    public RecordSchema getSchema(UUID schemaVersionId) throws SchemaNotFoundException {
        GetSchemaVersionResponse schemaVersionResponse = this.client.getSchemaVersion((GetSchemaVersionRequest)GetSchemaVersionRequest.builder().schemaVersionId(schemaVersionId.toString()).build());
        return this.createRecordSchemaFromSchemaVersionId(schemaVersionResponse);
    }

    private GetSchemaVersionResponse getSchemaVersionResponse(String schemaName, SchemaVersionNumber schemaVersionNumber) {
        SchemaId schemaId = this.buildSchemaId(schemaName);
        GetSchemaVersionRequest request = this.buildSchemaVersionRequest(schemaVersionNumber, schemaId);
        return this.client.getSchemaVersion(request);
    }

    private GetSchemaVersionRequest buildSchemaVersionRequest(SchemaVersionNumber schemaVersionNumber, SchemaId schemaId) {
        return (GetSchemaVersionRequest)GetSchemaVersionRequest.builder().schemaVersionNumber(schemaVersionNumber).schemaId(schemaId).build();
    }

    private SchemaId buildSchemaId(String schemaName) {
        return (SchemaId)SchemaId.builder().registryName(this.registryName).schemaName(schemaName).build();
    }

    private RecordSchema createRecordSchema(GetSchemaVersionResponse schemaVersionResponse) throws SchemaNotFoundException, JsonProcessingException {
        JsonNode schemaNode = OBJECT_MAPPER.readTree(schemaVersionResponse.schemaDefinition());
        String namespace = schemaNode.get(NAMESPACE_FIELD_NAME).asText();
        int version = schemaVersionResponse.versionNumber().intValue();
        String schemaText = schemaVersionResponse.schemaDefinition();
        try {
            SchemaIdentifier schemaId = SchemaIdentifier.builder().name(namespace).version(Integer.valueOf(version)).build();
            return this.parseSchema(schemaVersionResponse.dataFormat(), schemaText, schemaId);
        }
        catch (SchemaParseException spe) {
            throw new SchemaNotFoundException("Obtained Schema with name " + namespace + " from Glue Schema Registry but the Schema Text that was returned is not a valid Avro Schema");
        }
    }

    private RecordSchema createRecordSchemaFromSchemaVersionId(GetSchemaVersionResponse schemaVersionResponse) throws SchemaNotFoundException {
        int schemaVersionId = schemaVersionResponse.versionNumber().intValue();
        try {
            SchemaIdentifier schemaId = SchemaIdentifier.builder().name(schemaVersionResponse.schemaArn()).version(Integer.valueOf(schemaVersionId)).build();
            return this.parseSchema(schemaVersionResponse.dataFormat(), schemaVersionResponse.schemaDefinition(), schemaId);
        }
        catch (SchemaParseException spe) {
            throw new SchemaNotFoundException("Obtained Schema for ARN: " + schemaVersionResponse.schemaArn() + " and Version ID: " + schemaVersionResponse.schemaVersionId() + " from Glue Schema Registry but the Schema Text that was returned is not a valid Avro Schema");
        }
    }

    private RecordSchema parseSchema(DataFormat dataFormat, String schemaText, SchemaIdentifier schemaId) throws SchemaParseException {
        return AvroTypeUtil.createSchema((Schema)(switch (dataFormat) {
            case DataFormat.AVRO -> new Schema.Parser().parse(schemaText);
            case DataFormat.JSON -> throw new UnsupportedOperationException("JSON schema parsing is not yet supported");
            case DataFormat.PROTOBUF -> throw new UnsupportedOperationException("Protobuf schema parsing is not yet supported");
            default -> throw new UnsupportedOperationException("Unsupported data format: " + String.valueOf(dataFormat));
        }), (String)schemaText, (SchemaIdentifier)schemaId);
    }
}

