/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.aws.schemaregistry.client;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.UUID;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.aws.schemaregistry.client.SchemaRegistryClient;
import org.apache.nifi.serialization.record.RecordSchema;

public class CachingSchemaRegistryClient
implements SchemaRegistryClient {
    private final SchemaRegistryClient client;
    private final LoadingCache<String, RecordSchema> nameCache;
    private final LoadingCache<Pair<String, Long>, RecordSchema> nameVersionCache;
    private final LoadingCache<UUID, RecordSchema> schemaVersionIdCache;

    public CachingSchemaRegistryClient(SchemaRegistryClient toWrap, int cacheSize, long expirationNanos) {
        this.client = toWrap;
        this.nameCache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterWrite(Duration.ofNanos(expirationNanos)).build(this.client::getSchema);
        this.nameVersionCache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterWrite(Duration.ofNanos(expirationNanos)).build(key -> this.client.getSchema((String)key.getLeft(), (Long)key.getRight()));
        this.schemaVersionIdCache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterWrite(Duration.ofNanos(expirationNanos)).build(this.client::getSchema);
    }

    @Override
    public RecordSchema getSchema(String schemaName) {
        return (RecordSchema)this.nameCache.get((Object)schemaName);
    }

    @Override
    public RecordSchema getSchema(String schemaName, long version) {
        return (RecordSchema)this.nameVersionCache.get((Object)Pair.of((Object)schemaName, (Object)version));
    }

    @Override
    public RecordSchema getSchema(UUID schemaVersionId) {
        return (RecordSchema)this.schemaVersionIdCache.get((Object)schemaVersionId);
    }
}

