/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.aws.schemaregistry;

import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.aws.schemaregistry.WireFormatAwsGlueSchemaId;
import org.apache.nifi.aws.schemaregistry.serde.GlueSchemaRegistryDeserializerDataParser;
import org.apache.nifi.controller.AbstractControllerService;
import org.apache.nifi.schema.access.SchemaField;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.schemaregistry.services.SchemaReferenceReader;
import org.apache.nifi.serialization.record.SchemaIdentifier;
import org.apache.nifi.stream.io.StreamUtils;

@Tags(value={"schema", "registry", "aws", "avro", "glue"})
@CapabilityDescription(value="Reads Schema Identifier according to AWS Glue Schema encoding as a header consisting of a two byte markers and a 16 byte UUID")
public class AmazonGlueEncodedSchemaReferenceReader
extends AbstractControllerService
implements SchemaReferenceReader {
    private final GlueSchemaRegistryDeserializerDataParser deserializerDataParser = GlueSchemaRegistryDeserializerDataParser.getInstance();
    private static final int HEADER_CAPACITY = GlueSchemaRegistryDeserializerDataParser.getSchemaRegistryHeaderLength();
    private static final Set<SchemaField> SUPPLIED_SCHEMA_FIELDS = Set.of(SchemaField.SCHEMA_NAME);

    public SchemaIdentifier getSchemaIdentifier(Map<String, String> variables, InputStream contentStream) throws SchemaNotFoundException {
        byte[] header = new byte[HEADER_CAPACITY];
        try {
            StreamUtils.fillBuffer((InputStream)contentStream, (byte[])header);
        }
        catch (IOException e) {
            throw new SchemaNotFoundException("Failed to read header in first %d bytes from stream".formatted(HEADER_CAPACITY), (Throwable)e);
        }
        ByteBuffer headerBuffer = ByteBuffer.wrap(header);
        StringBuilder errorStringBuilder = new StringBuilder();
        if (!this.deserializerDataParser.isDataCompatible(headerBuffer, errorStringBuilder)) {
            throw new SchemaNotFoundException("Failed to parse Glue Schema Registry header: %s".formatted(errorStringBuilder));
        }
        UUID schemaVersionId = this.deserializerDataParser.getSchemaVersionId(headerBuffer);
        return SchemaIdentifier.builder().name(new WireFormatAwsGlueSchemaId(schemaVersionId).toSchemaName()).build();
    }

    public Set<SchemaField> getSuppliedSchemaFields() {
        return SUPPLIED_SCHEMA_FIELDS;
    }
}

