/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.aws.schemaregistry.serde;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.apache.nifi.aws.schemaregistry.serde.GlueSchemaRegistryIncompatibleDataException;

public final class GlueSchemaRegistryDeserializerDataParser {
    private GlueSchemaRegistryDeserializerDataParser() {
    }

    public static GlueSchemaRegistryDeserializerDataParser getInstance() {
        return DataParserHelper.INSTANCE;
    }

    public UUID getSchemaVersionId(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        ByteBuffer slicedBuffer = byteBuffer.slice();
        this.validateData(slicedBuffer);
        slicedBuffer.get();
        slicedBuffer.get();
        long mostSigBits = slicedBuffer.getLong();
        long leastSigBits = slicedBuffer.getLong();
        return new UUID(mostSigBits, leastSigBits);
    }

    public boolean isDataCompatible(ByteBuffer byteBuffer, StringBuilder errorBuilder) {
        byteBuffer.rewind();
        ByteBuffer toValidate = byteBuffer.slice();
        if (toValidate.limit() < 18) {
            String message = String.format("%s size: %d", "Data is not compatible with schema registry", toValidate.limit());
            errorBuilder.append(message);
            return false;
        }
        Byte headerVersionByte = toValidate.get();
        if (!headerVersionByte.equals((byte)3)) {
            String message = "Invalid schema registry header version byte in data";
            errorBuilder.append(message);
            return false;
        }
        Byte compressionByte = toValidate.get();
        if (!compressionByte.equals((byte)5) && !compressionByte.equals((byte)0)) {
            String message = "Invalid schema registry compression byte in data";
            errorBuilder.append(message);
            return false;
        }
        return true;
    }

    private void validateData(ByteBuffer buffer) throws GlueSchemaRegistryIncompatibleDataException {
        StringBuilder errorMessageBuilder = new StringBuilder();
        if (!this.isDataCompatible(buffer, errorMessageBuilder)) {
            throw new GlueSchemaRegistryIncompatibleDataException(errorMessageBuilder.toString());
        }
    }

    public boolean isCompressionEnabled(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        ByteBuffer slicedBuffer = byteBuffer.slice();
        slicedBuffer.get();
        Byte compressionByte = slicedBuffer.get();
        return this.isCompressionByteSet(compressionByte);
    }

    private boolean isCompressionByteSet(Byte compressionByte) {
        return !compressionByte.equals((byte)0);
    }

    public Byte getCompressionByte(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        ByteBuffer slicedBuffer = byteBuffer.slice();
        slicedBuffer.get();
        return slicedBuffer.get();
    }

    public Byte getHeaderVersionByte(ByteBuffer byteBuffer) {
        byteBuffer.rewind();
        ByteBuffer slicedBuffer = byteBuffer.slice();
        return slicedBuffer.get();
    }

    public static int getSchemaRegistryHeaderLength() {
        return 18;
    }

    private static class DataParserHelper {
        private static final GlueSchemaRegistryDeserializerDataParser INSTANCE = new GlueSchemaRegistryDeserializerDataParser();

        private DataParserHelper() {
        }
    }
}

