/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.aws.schemaregistry;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;

record WireFormatAwsGlueSchemaId(UUID id) {
    private static final String GLUE_SCHEMA_REGISTRY_WIRE_FORMAT_UUID_PREFIX = "aws-glue-schema-registry-wire-format-uuid$$";

    WireFormatAwsGlueSchemaId {
        Objects.requireNonNull(id, "Schema version ID must not be null");
    }

    public String toSchemaName() {
        return GLUE_SCHEMA_REGISTRY_WIRE_FORMAT_UUID_PREFIX + String.valueOf(this.id);
    }

    public static Optional<WireFormatAwsGlueSchemaId> fromSchemaName(String name) {
        try {
            if (!WireFormatAwsGlueSchemaId.isWireFormatName(name)) {
                return Optional.empty();
            }
            UUID uuid = UUID.fromString(name.substring(GLUE_SCHEMA_REGISTRY_WIRE_FORMAT_UUID_PREFIX.length()));
            return Optional.of(new WireFormatAwsGlueSchemaId(uuid));
        }
        catch (IllegalArgumentException e) {
            return Optional.empty();
        }
    }

    public static boolean isWireFormatName(String schemaName) {
        return schemaName != null && schemaName.startsWith(GLUE_SCHEMA_REGISTRY_WIRE_FORMAT_UUID_PREFIX);
    }
}

