/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.ml;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Set;
import org.apache.commons.io.IOUtils;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.flowfile.attributes.CoreAttributes;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.ml.AbstractAwsMachineLearningJobStatusProcessor;
import org.apache.nifi.processors.aws.v2.AbstractAwsSyncProcessor;
import software.amazon.awssdk.awscore.AwsRequest;
import software.amazon.awssdk.awscore.AwsResponse;
import software.amazon.awssdk.awscore.client.builder.AwsClientBuilder;
import software.amazon.awssdk.awscore.client.builder.AwsSyncClientBuilder;
import software.amazon.awssdk.core.SdkClient;

public abstract class AbstractAwsMachineLearningJobStarter<Q extends AwsRequest, B extends AwsRequest.Builder, R extends AwsResponse, T extends SdkClient, U extends AwsSyncClientBuilder<U, T> & AwsClientBuilder<U, T>>
extends AbstractAwsSyncProcessor<T, U> {
    public static final PropertyDescriptor JSON_PAYLOAD = new PropertyDescriptor.Builder().name("JSON Payload").description("JSON request for AWS Machine Learning services. The Processor will use FlowFile content for the request when this property is not specified.").expressionLanguageSupported(ExpressionLanguageScope.FLOWFILE_ATTRIBUTES).required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    public static final PropertyDescriptor MANDATORY_AWS_CREDENTIALS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().fromPropertyDescriptor(AWS_CREDENTIALS_PROVIDER_SERVICE).required(true).build();
    public static final Relationship REL_ORIGINAL = new Relationship.Builder().name("original").description("Upon successful completion, the original FlowFile will be routed to this relationship.").autoTerminateDefault(true).build();
    private static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(MANDATORY_AWS_CREDENTIALS_PROVIDER_SERVICE, REGION, TIMEOUT, JSON_PAYLOAD, SSL_CONTEXT_SERVICE, ENDPOINT_OVERRIDE);
    private static final ObjectMapper MAPPER = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().configure(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES, true)).findAndAddModules()).build();
    private static final Set<Relationship> RELATIONSHIPS = Set.of(REL_ORIGINAL, REL_SUCCESS, REL_FAILURE);

    protected static List<PropertyDescriptor> getCommonPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public Set<Relationship> getRelationships() {
        return RELATIONSHIPS;
    }

    public List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    @Override
    public void onTrigger(ProcessContext context, ProcessSession session) {
        FlowFile flowFile = session.get();
        if (flowFile == null && !context.getProperty(JSON_PAYLOAD).isSet()) {
            return;
        }
        try {
            R response = this.sendRequest(this.buildRequest(session, context, flowFile), context, flowFile);
            FlowFile childFlowFile = this.writeToFlowFile(session, flowFile, response);
            childFlowFile = this.postProcessFlowFile(context, session, childFlowFile, response);
            session.transfer(childFlowFile, REL_SUCCESS);
        }
        catch (Exception e) {
            if (flowFile != null) {
                session.transfer(flowFile, REL_FAILURE);
            }
            this.getLogger().error("Sending AWS ML Request failed", (Throwable)e);
            return;
        }
        if (flowFile != null) {
            session.transfer(flowFile, REL_ORIGINAL);
        }
    }

    @Override
    public void migrateProperties(PropertyConfiguration config) {
        super.migrateProperties(config);
        config.renameProperty("json-payload", JSON_PAYLOAD.getName());
    }

    protected FlowFile postProcessFlowFile(ProcessContext context, ProcessSession session, FlowFile flowFile, R response) {
        String awsTaskId = this.getAwsTaskId(context, response, flowFile);
        FlowFile processedFlowFile = session.putAttribute(flowFile, AbstractAwsMachineLearningJobStatusProcessor.TASK_ID.getName(), awsTaskId);
        processedFlowFile = session.putAttribute(processedFlowFile, CoreAttributes.MIME_TYPE.key(), "application/json");
        this.getLogger().debug("AWS ML Task [{}] started", new Object[]{awsTaskId});
        return processedFlowFile;
    }

    protected Q buildRequest(ProcessSession session, ProcessContext context, FlowFile flowFile) throws JsonProcessingException {
        return (Q)((AwsRequest.Builder)MAPPER.readValue(this.getPayload(session, context, flowFile), this.getAwsRequestBuilderClass(context, flowFile))).build();
    }

    protected FlowFile writeToFlowFile(ProcessSession session, FlowFile flowFile, R response) {
        FlowFile childFlowFile = flowFile == null ? session.create() : session.create(flowFile);
        childFlowFile = session.write(childFlowFile, out -> MAPPER.writeValue(out, (Object)response.toBuilder()));
        return childFlowFile;
    }

    protected String readFlowFile(ProcessSession session, FlowFile flowFile) {
        String string;
        block8: {
            InputStream inputStream = session.read(flowFile);
            try {
                string = new String(IOUtils.toByteArray((InputStream)inputStream));
                if (inputStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new ProcessException("Read FlowFile Failed", (Throwable)e);
                }
            }
            inputStream.close();
        }
        return string;
    }

    private String getPayload(ProcessSession session, ProcessContext context, FlowFile flowFile) {
        String payloadPropertyValue = context.getProperty(JSON_PAYLOAD).evaluateAttributeExpressions(flowFile).getValue();
        if (payloadPropertyValue == null) {
            payloadPropertyValue = this.readFlowFile(session, flowFile);
        }
        return payloadPropertyValue;
    }

    protected abstract R sendRequest(Q var1, ProcessContext var2, FlowFile var3) throws JsonProcessingException;

    protected abstract Class<? extends B> getAwsRequestBuilderClass(ProcessContext var1, FlowFile var2);

    protected abstract String getAwsTaskId(ProcessContext var1, R var2, FlowFile var3);
}

