/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws;

import com.amazonaws.AmazonWebServiceClient;
import com.amazonaws.ClientConfiguration;
import com.amazonaws.Protocol;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.http.conn.ssl.SdkTLSSocketFactory;
import com.amazonaws.regions.Region;
import com.amazonaws.regions.RegionUtils;
import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.net.Proxy;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.ssl.DefaultHostnameVerifier;
import org.apache.nifi.annotation.lifecycle.OnScheduled;
import org.apache.nifi.annotation.lifecycle.OnStopped;
import org.apache.nifi.components.ConfigVerificationResult;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.PropertyValue;
import org.apache.nifi.context.PropertyContext;
import org.apache.nifi.expression.ExpressionLanguageScope;
import org.apache.nifi.logging.ComponentLog;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.migration.ProxyServiceMigration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.VerifiableProcessor;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.processors.aws.credentials.provider.service.AWSCredentialsProviderService;
import org.apache.nifi.processors.aws.util.RegionUtilV1;
import org.apache.nifi.proxy.ProxyConfiguration;
import org.apache.nifi.proxy.ProxySpec;
import org.apache.nifi.ssl.SSLContextProvider;

public abstract class AbstractAWSCredentialsProviderProcessor<ClientType extends AmazonWebServiceClient>
extends AbstractProcessor
implements VerifiableProcessor {
    private static final String CREDENTIALS_SERVICE_CLASSNAME = "org.apache.nifi.processors.aws.credentials.provider.service.AWSCredentialsProviderControllerService";
    private static final String OBSOLETE_ACCESS_KEY = "Access Key";
    private static final String OBSOLETE_SECRET_KEY = "Secret Key";
    private static final String OBSOLETE_CREDENTIALS_FILE = "Credentials File";
    private static final String OBSOLETE_PROXY_HOST = "Proxy Host";
    private static final String OBSOLETE_PROXY_PORT = "Proxy Host Port";
    private static final String OBSOLETE_PROXY_USERNAME = "proxy-user-name";
    private static final String OBSOLETE_PROXY_PASSWORD = "proxy-user-password";
    private static final String AUTH_SERVICE_ACCESS_KEY = "Access Key";
    private static final String AUTH_SERVICE_SECRET_KEY = "Secret Key";
    private static final String AUTH_SERVICE_CREDENTIALS_FILE = "Credentials File";
    private static final String AUTH_SERVICE_ANONYMOUS_CREDENTIALS = "anonymous-credentials";
    public static final PropertyDescriptor TIMEOUT = new PropertyDescriptor.Builder().name("Communications Timeout").description("The amount of time to wait in order to establish a connection to AWS or receive data from AWS before timing out.").required(true).addValidator(StandardValidators.TIME_PERIOD_VALIDATOR).defaultValue("30 secs").build();
    public static final PropertyDescriptor SSL_CONTEXT_SERVICE = new PropertyDescriptor.Builder().name("SSL Context Service").description("Specifies an optional SSL Context Service that, if provided, will be used to create connections").required(false).identifiesControllerService(SSLContextProvider.class).build();
    public static final PropertyDescriptor ENDPOINT_OVERRIDE = new PropertyDescriptor.Builder().name("Endpoint Override URL").description("Endpoint URL to use instead of the AWS default including scheme, host, port, and path. The AWS libraries select an endpoint URL based on the AWS region, but this property overrides the selected endpoint URL, allowing use with other S3-compatible endpoints.").expressionLanguageSupported(ExpressionLanguageScope.ENVIRONMENT).required(false).addValidator(StandardValidators.URL_VALIDATOR).build();
    public static final PropertyDescriptor AWS_CREDENTIALS_PROVIDER_SERVICE = new PropertyDescriptor.Builder().name("AWS Credentials Provider service").displayName("AWS Credentials Provider Service").description("The Controller Service that is used to obtain AWS credentials provider").required(true).identifiesControllerService(AWSCredentialsProviderService.class).build();
    public static final PropertyDescriptor PROXY_CONFIGURATION_SERVICE = ProxyConfiguration.createProxyConfigPropertyDescriptor((ProxySpec[])new ProxySpec[]{ProxySpec.HTTP, ProxySpec.HTTP_AUTH});
    public static final Relationship REL_SUCCESS = new Relationship.Builder().name("success").description("FlowFiles are routed to this Relationship after they have been successfully processed.").build();
    public static final Relationship REL_FAILURE = new Relationship.Builder().name("failure").description("If the Processor is unable to process a given FlowFile, it will be routed to this Relationship.").build();
    public static final Set<Relationship> COMMON_RELATIONSHIPS = Set.of(REL_SUCCESS, REL_FAILURE);
    private static final String VPCE_ENDPOINT_SUFFIX = ".vpce.amazonaws.com";
    private final Cache<String, ClientType> clientCache = Caffeine.newBuilder().maximumSize(10L).build();

    public Set<Relationship> getRelationships() {
        return COMMON_RELATIONSHIPS;
    }

    @OnScheduled
    public void onScheduled(ProcessContext context) {
        this.getClient(context);
    }

    @OnStopped
    public void onStopped() {
        this.clientCache.invalidateAll();
        this.clientCache.cleanUp();
    }

    public void migrateProperties(PropertyConfiguration config) {
        this.migrateAuthenticationProperties(config);
        ProxyServiceMigration.migrateProxyProperties((PropertyConfiguration)config, (PropertyDescriptor)PROXY_CONFIGURATION_SERVICE, (String)OBSOLETE_PROXY_HOST, (String)OBSOLETE_PROXY_PORT, (String)OBSOLETE_PROXY_USERNAME, (String)OBSOLETE_PROXY_PASSWORD);
    }

    private void migrateAuthenticationProperties(PropertyConfiguration config) {
        if (!config.isPropertySet(AWS_CREDENTIALS_PROVIDER_SERVICE)) {
            if (config.isPropertySet("Access Key") && config.isPropertySet("Secret Key")) {
                String serviceId = config.createControllerService(CREDENTIALS_SERVICE_CLASSNAME, Map.of("Access Key", (String)config.getRawPropertyValue("Access Key").get(), "Secret Key", (String)config.getRawPropertyValue("Secret Key").get()));
                config.setProperty(AWS_CREDENTIALS_PROVIDER_SERVICE.getName(), serviceId);
            } else if (config.isPropertySet("Credentials File")) {
                String serviceId = config.createControllerService(CREDENTIALS_SERVICE_CLASSNAME, Map.of("Credentials File", (String)config.getRawPropertyValue("Credentials File").get()));
                config.setProperty(AWS_CREDENTIALS_PROVIDER_SERVICE, serviceId);
            } else {
                String serviceId = config.createControllerService(CREDENTIALS_SERVICE_CLASSNAME, Map.of(AUTH_SERVICE_ANONYMOUS_CREDENTIALS, "true"));
                config.setProperty(AWS_CREDENTIALS_PROVIDER_SERVICE, serviceId);
            }
        }
        config.removeProperty("Access Key");
        config.removeProperty("Secret Key");
        config.removeProperty("Credentials File");
    }

    protected ClientConfiguration createConfiguration(ProcessContext context) {
        return this.createConfiguration((PropertyContext)context, context.getMaxConcurrentTasks());
    }

    protected ClientConfiguration createConfiguration(PropertyContext context, int maxConcurrentTasks) {
        ProxyConfiguration proxyConfig;
        SSLContextProvider sslContextProvider;
        ClientConfiguration config = new ClientConfiguration();
        config.setMaxConnections(maxConcurrentTasks);
        config.setMaxErrorRetry(0);
        config.setUserAgentPrefix("NiFi");
        config.setProtocol(Protocol.HTTPS);
        int commsTimeout = context.getProperty(TIMEOUT).asTimePeriod(TimeUnit.MILLISECONDS).intValue();
        config.setConnectionTimeout(commsTimeout);
        config.setSocketTimeout(commsTimeout);
        if (this.getSupportedPropertyDescriptors().contains(SSL_CONTEXT_SERVICE) && (sslContextProvider = (SSLContextProvider)context.getProperty(SSL_CONTEXT_SERVICE).asControllerService(SSLContextProvider.class)) != null) {
            SSLContext sslContext = sslContextProvider.createContext();
            SdkTLSSocketFactory sdkTLSSocketFactory = new SdkTLSSocketFactory(sslContext, (HostnameVerifier)new DefaultHostnameVerifier());
            config.getApacheHttpClientConfig().setSslSocketFactory((ConnectionSocketFactory)sdkTLSSocketFactory);
        }
        if (Proxy.Type.HTTP.equals((Object)(proxyConfig = ProxyConfiguration.getConfiguration((PropertyContext)context)).getProxyType())) {
            config.setProxyHost(proxyConfig.getProxyServerHost());
            config.setProxyPort(proxyConfig.getProxyServerPort().intValue());
            if (proxyConfig.hasCredential()) {
                config.setProxyUsername(proxyConfig.getProxyUserName());
                config.setProxyPassword(proxyConfig.getProxyUserPassword());
            }
        }
        return config;
    }

    protected ClientType createClient(ProcessContext context) {
        return this.createClient(context, this.getRegion(context));
    }

    public ClientType createClient(ProcessContext context, Region region) {
        this.getLogger().debug("Using AWS credentials provider service for creating client");
        AWSCredentialsProvider credentialsProvider = this.getCredentialsProvider(context);
        ClientConfiguration configuration = this.createConfiguration(context);
        ClientType createdClient = this.createClient(context, credentialsProvider, region, configuration, this.getEndpointConfiguration(context, region));
        return createdClient;
    }

    protected AwsClientBuilder.EndpointConfiguration getEndpointConfiguration(ProcessContext context, Region region) {
        PropertyValue overrideValue = context.getProperty(ENDPOINT_OVERRIDE);
        if (overrideValue == null || !overrideValue.isSet()) {
            return null;
        }
        String endpointOverride = overrideValue.evaluateAttributeExpressions().getValue();
        String signingRegion = this.isVpceEndpoint(endpointOverride) ? region.getName() : (this.isCustomSignerConfigured(context) ? region.getName() : null);
        return new AwsClientBuilder.EndpointConfiguration(endpointOverride, signingRegion);
    }

    private boolean isVpceEndpoint(String endpoint) {
        return endpoint.endsWith(VPCE_ENDPOINT_SUFFIX);
    }

    protected boolean isCustomSignerConfigured(ProcessContext context) {
        return false;
    }

    public List<ConfigVerificationResult> verify(ProcessContext context, ComponentLog verificationLogger, Map<String, String> attributes) {
        ArrayList<ConfigVerificationResult> results = new ArrayList<ConfigVerificationResult>();
        try {
            this.createClient(context);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.SUCCESSFUL).verificationStepName("Create Client and Configure Region").explanation("Successfully created AWS Client and configured Region").build());
        }
        catch (Exception e) {
            verificationLogger.error("Failed to create AWS Client", (Throwable)e);
            results.add(new ConfigVerificationResult.Builder().outcome(ConfigVerificationResult.Outcome.FAILED).verificationStepName("Create Client and Configure Region").explanation("Failed to crete AWS Client or configure Region: " + e.getMessage()).build());
        }
        return results;
    }

    protected AWSCredentialsProvider getCredentialsProvider(ProcessContext context) {
        AWSCredentialsProviderService awsCredentialsProviderService = (AWSCredentialsProviderService)context.getProperty(AWS_CREDENTIALS_PROVIDER_SERVICE).asControllerService(AWSCredentialsProviderService.class);
        return awsCredentialsProviderService.getCredentialsProvider();
    }

    protected Region getRegion(ProcessContext context) {
        String regionValue;
        if (this.getSupportedPropertyDescriptors().contains(RegionUtilV1.REGION) && (regionValue = context.getProperty(RegionUtilV1.REGION).getValue()) != null) {
            return RegionUtils.getRegion((String)regionValue);
        }
        return null;
    }

    protected ClientType getClient(ProcessContext context, Region region) {
        String regionName = region == null ? "" : region.getName();
        return (ClientType)((AmazonWebServiceClient)this.clientCache.get((Object)regionName, ignored -> this.createClient(context, region)));
    }

    protected ClientType getClient(ProcessContext context) {
        return this.getClient(context, this.getRegion(context));
    }

    protected abstract ClientType createClient(ProcessContext var1, AWSCredentialsProvider var2, Region var3, ClientConfiguration var4, AwsClientBuilder.EndpointConfiguration var5);
}

