/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.aws.v2;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.apache.nifi.components.AllowableValue;
import software.amazon.awssdk.regions.Region;

public final class RegionUtilV2 {
    private RegionUtilV2() {
    }

    public static AllowableValue createAllowableValue(Region region) {
        String description = region.metadata() != null ? region.metadata().description() : region.id();
        return new AllowableValue(region.id(), description, "AWS Region Code : " + region.id());
    }

    public static AllowableValue[] getAvailableRegions() {
        ArrayList<AllowableValue> values = new ArrayList<AllowableValue>();
        for (Region region : Region.regions()) {
            values.add(RegionUtilV2.createAllowableValue(region));
        }
        Collections.sort(values, Comparator.comparing(AllowableValue::getDisplayName));
        return values.toArray(new AllowableValue[0]);
    }
}

