/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.authorization;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import org.apache.nifi.authorization.AccessPolicyProvider;
import org.apache.nifi.authorization.UserGroupProvider;
import org.apache.nifi.authorization.UserGroupProviderFactory;
import org.apache.nifi.nar.NarCloseable;

public class AccessPolicyProviderInvocationHandler
implements InvocationHandler {
    private static final Method getUserGroupProviderMethod;
    private final AccessPolicyProvider accessPolicyProvider;
    private final ClassLoader classLoader;

    public AccessPolicyProviderInvocationHandler(AccessPolicyProvider accessPolicyProvider, ClassLoader classLoader) {
        this.accessPolicyProvider = accessPolicyProvider;
        this.classLoader = classLoader;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        try (NarCloseable ignored = NarCloseable.withComponentNarLoader((ClassLoader)this.classLoader);){
            if (getUserGroupProviderMethod.equals(method)) {
                UserGroupProvider userGroupProvider = (UserGroupProvider)method.invoke((Object)this.accessPolicyProvider, args);
                if (userGroupProvider == null) {
                    UserGroupProvider userGroupProvider2 = userGroupProvider;
                    return userGroupProvider2;
                }
                UserGroupProvider userGroupProvider3 = UserGroupProviderFactory.withNarLoader(userGroupProvider, this.classLoader);
                return userGroupProvider3;
            }
            Object object = method.invoke((Object)this.accessPolicyProvider, args);
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
    }

    static {
        try {
            getUserGroupProviderMethod = AccessPolicyProvider.class.getMethod("getUserGroupProvider", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Unable to obtain necessary class information for AccessPolicyProvider", e);
        }
    }
}

