/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.framework.configuration;

import java.util.Objects;
import org.apache.nifi.authorization.AuthorizerFactoryBean;
import org.apache.nifi.nar.ExtensionManager;
import org.apache.nifi.util.NiFiProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AuthorizerConfiguration {
    private final NiFiProperties properties;
    private final ExtensionManager extensionManager;

    public AuthorizerConfiguration(NiFiProperties properties, ExtensionManager extensionManager) {
        this.properties = Objects.requireNonNull(properties, "Properties required");
        this.extensionManager = Objects.requireNonNull(extensionManager, "Extension Manager required");
    }

    @Bean
    public AuthorizerFactoryBean authorizer() {
        AuthorizerFactoryBean authorizerFactoryBean = new AuthorizerFactoryBean();
        authorizerFactoryBean.setProperties(this.properties);
        authorizerFactoryBean.setExtensionManager(this.extensionManager);
        return authorizerFactoryBean;
    }
}

