/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.atlassian.bitbucket;

import java.util.List;
import org.apache.nifi.annotation.documentation.CapabilityDescription;
import org.apache.nifi.annotation.documentation.Tags;
import org.apache.nifi.atlassian.bitbucket.BitbucketAuthenticationType;
import org.apache.nifi.atlassian.bitbucket.BitbucketRepositoryClient;
import org.apache.nifi.components.DescribedValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.oauth2.OAuth2AccessTokenProvider;
import org.apache.nifi.processor.util.StandardValidators;
import org.apache.nifi.registry.flow.FlowRegistryClientConfigurationContext;
import org.apache.nifi.registry.flow.FlowRegistryException;
import org.apache.nifi.registry.flow.git.AbstractGitFlowRegistryClient;
import org.apache.nifi.registry.flow.git.client.GitRepositoryClient;
import org.apache.nifi.web.client.provider.api.WebClientServiceProvider;

@Tags(value={"atlassian", "bitbucket", "registry", "flow"})
@CapabilityDescription(value="Flow Registry Client that uses the Bitbucket REST API to version control flows in a Bitbucket Repository.")
public class BitbucketFlowRegistryClient
extends AbstractGitFlowRegistryClient {
    static final PropertyDescriptor BITBUCKET_API_URL = new PropertyDescriptor.Builder().name("Bitbucket API Instance").description("The instance of the Bitbucket API").addValidator(StandardValidators.NON_BLANK_VALIDATOR).defaultValue("api.bitbucket.org").required(true).build();
    static final PropertyDescriptor BITBUCKET_API_VERSION = new PropertyDescriptor.Builder().name("Bitbucket API Version").description("The version of the Bitbucket API").defaultValue("2.0").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).build();
    static final PropertyDescriptor WORKSPACE_NAME = new PropertyDescriptor.Builder().name("Workspace Name").description("The name of the workspace that contains the repository to connect to").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).build();
    static final PropertyDescriptor REPOSITORY_NAME = new PropertyDescriptor.Builder().name("Repository Name").description("The name of the repository").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).build();
    static final PropertyDescriptor AUTHENTICATION_TYPE = new PropertyDescriptor.Builder().name("Authentication Type").description("The type of authentication to use for accessing Bitbucket").allowableValues(BitbucketAuthenticationType.class).defaultValue((DescribedValue)BitbucketAuthenticationType.ACCESS_TOKEN).required(true).build();
    static final PropertyDescriptor ACCESS_TOKEN = new PropertyDescriptor.Builder().name("Access Token").description("The access token to use for authentication").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).sensitive(true).dependsOn(AUTHENTICATION_TYPE, (DescribedValue)BitbucketAuthenticationType.ACCESS_TOKEN, new DescribedValue[0]).build();
    static final PropertyDescriptor USERNAME = new PropertyDescriptor.Builder().name("Username").description("The username to use for authentication").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).sensitive(false).dependsOn(AUTHENTICATION_TYPE, (DescribedValue)BitbucketAuthenticationType.BASIC_AUTH, new DescribedValue[0]).build();
    static final PropertyDescriptor APP_PASSWORD = new PropertyDescriptor.Builder().name("App Password").description("The App Password to use for authentication").addValidator(StandardValidators.NON_BLANK_VALIDATOR).required(true).sensitive(true).dependsOn(AUTHENTICATION_TYPE, (DescribedValue)BitbucketAuthenticationType.BASIC_AUTH, new DescribedValue[0]).build();
    static final PropertyDescriptor OAUTH_TOKEN_PROVIDER = new PropertyDescriptor.Builder().name("OAuth2 Access Token Provider").description("Service providing OAuth2 Access Tokens for authentication").identifiesControllerService(OAuth2AccessTokenProvider.class).required(true).dependsOn(AUTHENTICATION_TYPE, (DescribedValue)BitbucketAuthenticationType.OAUTH2, new DescribedValue[0]).build();
    static final PropertyDescriptor WEBCLIENT_SERVICE = new PropertyDescriptor.Builder().name("Web Client Service").description("The Web Client Service to use for communicating with Bitbucket").required(true).identifiesControllerService(WebClientServiceProvider.class).build();
    static final List<PropertyDescriptor> PROPERTY_DESCRIPTORS = List.of(WEBCLIENT_SERVICE, BITBUCKET_API_URL, BITBUCKET_API_VERSION, WORKSPACE_NAME, REPOSITORY_NAME, AUTHENTICATION_TYPE, ACCESS_TOKEN, USERNAME, APP_PASSWORD, OAUTH_TOKEN_PROVIDER);
    static final String STORAGE_LOCATION_PREFIX = "git@bitbucket.org:";
    static final String STORAGE_LOCATION_FORMAT = "git@bitbucket.org:%s/%s.git";

    protected List<PropertyDescriptor> createPropertyDescriptors() {
        return PROPERTY_DESCRIPTORS;
    }

    protected GitRepositoryClient createRepositoryClient(FlowRegistryClientConfigurationContext context) throws FlowRegistryException {
        return BitbucketRepositoryClient.builder().clientId(this.getIdentifier()).apiUrl(context.getProperty(BITBUCKET_API_URL).getValue()).apiVersion(context.getProperty(BITBUCKET_API_VERSION).getValue()).workspace(context.getProperty(WORKSPACE_NAME).getValue()).repoName(context.getProperty(REPOSITORY_NAME).getValue()).repoPath(context.getProperty(REPOSITORY_PATH).getValue()).authenticationType((BitbucketAuthenticationType)context.getProperty(AUTHENTICATION_TYPE).asAllowableValue(BitbucketAuthenticationType.class)).accessToken(context.getProperty(ACCESS_TOKEN).evaluateAttributeExpressions().getValue()).username(context.getProperty(USERNAME).evaluateAttributeExpressions().getValue()).appPassword(context.getProperty(APP_PASSWORD).evaluateAttributeExpressions().getValue()).oauthService((OAuth2AccessTokenProvider)context.getProperty(OAUTH_TOKEN_PROVIDER).asControllerService(OAuth2AccessTokenProvider.class)).webClient((WebClientServiceProvider)context.getProperty(WEBCLIENT_SERVICE).asControllerService(WebClientServiceProvider.class)).build();
    }

    public boolean isStorageLocationApplicable(FlowRegistryClientConfigurationContext context, String location) {
        return location != null && location.startsWith(STORAGE_LOCATION_PREFIX);
    }

    protected String getStorageLocation(GitRepositoryClient repositoryClient) {
        BitbucketRepositoryClient gitLabRepositoryClient = (BitbucketRepositoryClient)repositoryClient;
        return STORAGE_LOCATION_FORMAT.formatted(gitLabRepositoryClient.getWorkspace(), gitLabRepositoryClient.getRepoName());
    }
}

