/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.apicurio.schemaregistry.util;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.OptionalInt;
import org.apache.avro.Schema;
import org.apache.avro.SchemaParseException;
import org.apache.nifi.avro.AvroTypeUtil;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.RecordSchema;
import org.apache.nifi.serialization.record.SchemaIdentifier;

public class SchemaUtils {
    private static final ObjectMapper OBJECT_MAPPER = SchemaUtils.setObjectMapper();

    private SchemaUtils() {
    }

    public static RecordSchema createRecordSchema(InputStream schemaStream, String artifactId, OptionalInt version) throws SchemaNotFoundException, IOException {
        JsonNode schemaNode = OBJECT_MAPPER.readTree(schemaStream);
        String schemaText = schemaNode.toString();
        try {
            Schema avroSchema = new Schema.Parser().parse(schemaText);
            SchemaIdentifier.Builder schemaIdBuilder = SchemaIdentifier.builder().name(artifactId);
            if (version.isPresent()) {
                schemaIdBuilder.version(Integer.valueOf(version.getAsInt()));
            }
            SchemaIdentifier schemaId = schemaIdBuilder.build();
            return AvroTypeUtil.createSchema((Schema)avroSchema, (String)schemaText, (SchemaIdentifier)schemaId);
        }
        catch (SchemaParseException e) {
            String errorMessage = String.format("Obtained Schema with name [%s] from Apicurio Schema Registry but the Schema Text that was returned is not a valid Avro Schema", artifactId);
            throw new SchemaNotFoundException(errorMessage, (Throwable)e);
        }
    }

    static ObjectMapper setObjectMapper() {
        return new ObjectMapper();
    }
}

