/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.apicurio.schemaregistry.client;

import java.io.InputStream;
import java.net.URI;
import org.apache.nifi.web.client.api.HttpUriBuilder;
import org.apache.nifi.web.client.provider.api.WebClientServiceProvider;

public class SchemaRegistryApiClient {
    private final WebClientServiceProvider webClientServiceProvider;
    private final String baseUrl;
    private final String groupId;

    public SchemaRegistryApiClient(WebClientServiceProvider webClientServiceProvider, String baseUrl, String groupId) {
        this.webClientServiceProvider = webClientServiceProvider;
        this.baseUrl = baseUrl;
        this.groupId = groupId;
    }

    public InputStream retrieveResponse(URI uri) {
        return this.webClientServiceProvider.getWebClientService().get().uri(uri).retrieve().body();
    }

    public HttpUriBuilder buildBaseUri() {
        URI uri = URI.create(this.baseUrl);
        return this.webClientServiceProvider.getHttpUriBuilder().scheme(uri.getScheme()).host(uri.getHost()).port(uri.getPort()).addPathSegment("apis").addPathSegment("registry").addPathSegment("v2");
    }

    private HttpUriBuilder buildBaseSchemaUri() {
        return this.buildBaseUri().addPathSegment("groups").addPathSegment(this.groupId);
    }

    private HttpUriBuilder buildBaseSchemaArtifactUri(String artifactId) {
        return this.buildBaseSchemaUri().addPathSegment("artifacts").addPathSegment(artifactId);
    }

    public URI buildSchemaArtifactUri(String artifactId) {
        return this.buildBaseSchemaArtifactUri(artifactId).build();
    }

    public URI buildSchemaVersionUri(String artifactId, int version) {
        return this.buildBaseSchemaArtifactUri(artifactId).addPathSegment("versions").addPathSegment(String.valueOf(version)).build();
    }
}

