/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.apicurio.schemaregistry.client;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.OptionalInt;
import org.apache.nifi.apicurio.schemaregistry.client.SchemaRegistryApiClient;
import org.apache.nifi.apicurio.schemaregistry.client.SchemaRegistryClient;
import org.apache.nifi.apicurio.schemaregistry.util.SchemaUtils;
import org.apache.nifi.schema.access.SchemaNotFoundException;
import org.apache.nifi.serialization.record.RecordSchema;

public class ApicurioSchemaRegistryClient
implements SchemaRegistryClient {
    private final SchemaRegistryApiClient apiClient;

    public ApicurioSchemaRegistryClient(SchemaRegistryApiClient apiClient) {
        this.apiClient = apiClient;
    }

    @Override
    public RecordSchema getSchema(String schemaId, OptionalInt version) throws IOException, SchemaNotFoundException {
        return this.createRecordSchemaForAttributes(schemaId, version);
    }

    private RecordSchema createRecordSchemaForAttributes(String artifactId, OptionalInt version) throws IOException, SchemaNotFoundException {
        URI schemaUri = version.isPresent() ? this.apiClient.buildSchemaVersionUri(artifactId, version.getAsInt()) : this.apiClient.buildSchemaArtifactUri(artifactId);
        try (InputStream schemaResultStream = this.apiClient.retrieveResponse(schemaUri);){
            RecordSchema recordSchema = SchemaUtils.createRecordSchema(schemaResultStream, artifactId, version);
            return recordSchema;
        }
    }
}

