/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.apicurio.schemaregistry.client;

import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.time.Duration;
import java.util.OptionalInt;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.nifi.apicurio.schemaregistry.client.SchemaRegistryClient;
import org.apache.nifi.serialization.record.RecordSchema;

public class CachingSchemaRegistryClient
implements SchemaRegistryClient {
    private final SchemaRegistryClient client;
    private final LoadingCache<Pair<String, OptionalInt>, RecordSchema> schemaCache;

    public CachingSchemaRegistryClient(SchemaRegistryClient toWrap, int cacheSize, long expirationNanos) {
        this.client = toWrap;
        this.schemaCache = Caffeine.newBuilder().maximumSize((long)cacheSize).expireAfterWrite(Duration.ofNanos(expirationNanos)).build(key -> this.client.getSchema((String)key.getLeft(), (OptionalInt)key.getRight()));
    }

    @Override
    public RecordSchema getSchema(String schemaName, OptionalInt version) {
        return (RecordSchema)this.schemaCache.get((Object)Pair.of((Object)schemaName, (Object)version));
    }
}

