/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.amqp.processors;

import com.rabbitmq.client.AMQP;
import com.rabbitmq.client.AlreadyClosedException;
import com.rabbitmq.client.Connection;
import com.rabbitmq.client.ReturnListener;
import java.io.IOException;
import java.net.SocketException;
import org.apache.nifi.amqp.processors.AMQPException;
import org.apache.nifi.amqp.processors.AMQPRollbackException;
import org.apache.nifi.amqp.processors.AMQPWorker;
import org.apache.nifi.logging.ComponentLog;

final class AMQPPublisher
extends AMQPWorker {
    private final String connectionString;

    AMQPPublisher(Connection connection, ComponentLog processorLog) {
        super(connection, processorLog);
        this.getChannel().addReturnListener((ReturnListener)new UndeliverableMessageLogger());
        this.connectionString = connection.toString();
        processorLog.info("Successfully connected AMQPPublisher to {}", new Object[]{this.connectionString});
    }

    void publish(byte[] bytes, AMQP.BasicProperties properties, String routingKey, String exchange) {
        this.validateStringProperty("routingKey", routingKey);
        String string = exchange = exchange == null ? "" : exchange.trim();
        if (this.processorLog.isDebugEnabled()) {
            if (exchange.isEmpty()) {
                this.processorLog.debug("The 'exchangeName' is not specified. Messages will be sent to default exchange");
            }
            this.processorLog.debug("Successfully connected AMQPPublisher to {} and '{}' exchange with '{}' as a routing key.", new Object[]{this.connectionString, exchange, routingKey});
        }
        try {
            this.getChannel().basicPublish(exchange, routingKey, true, properties, bytes);
        }
        catch (AlreadyClosedException | SocketException e) {
            throw new AMQPRollbackException("Failed to publish message because the AMQP connection is lost or has been closed", e);
        }
        catch (Exception e) {
            throw new AMQPException("Failed to publish message to Exchange '" + exchange + "' with Routing Key '" + routingKey + "'.", e);
        }
    }

    @Override
    public String toString() {
        return this.connectionString;
    }

    private final class UndeliverableMessageLogger
    implements ReturnListener {
        private UndeliverableMessageLogger() {
        }

        public void handleReturn(int replyCode, String replyText, String exchangeName, String routingKey, AMQP.BasicProperties properties, byte[] message) throws IOException {
            String logMessage = "Message destined for '" + exchangeName + "' exchange with '" + routingKey + "' as routing key came back with replyCode=" + replyCode + " and replyText=" + replyText + ".";
            AMQPPublisher.this.processorLog.warn(logMessage);
        }
    }
}

