/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.processors.tests.system;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.nifi.components.AllowableValue;
import org.apache.nifi.components.PropertyDescriptor;
import org.apache.nifi.components.Validator;
import org.apache.nifi.controller.ControllerService;
import org.apache.nifi.cs.tests.system.MigrationService;
import org.apache.nifi.flowfile.FlowFile;
import org.apache.nifi.migration.PropertyConfiguration;
import org.apache.nifi.migration.RelationshipConfiguration;
import org.apache.nifi.processor.AbstractProcessor;
import org.apache.nifi.processor.ProcessContext;
import org.apache.nifi.processor.ProcessSession;
import org.apache.nifi.processor.Relationship;
import org.apache.nifi.processor.exception.ProcessException;
import org.apache.nifi.processor.util.StandardValidators;

public class MigrateProperties
extends AbstractProcessor {
    static PropertyDescriptor INGEST = new PropertyDescriptor.Builder().name("Ingest Data").allowableValues(new String[]{"true", "false"}).defaultValue("true").required(true).build();
    static PropertyDescriptor ATTRIBUTE_NAME = new PropertyDescriptor.Builder().name("Attribute to add").required(false).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static PropertyDescriptor ATTRIBUTE_VALUE = new PropertyDescriptor.Builder().name("Attribute Value").required(true).dependsOn(ATTRIBUTE_NAME, new AllowableValue[0]).addValidator(StandardValidators.NON_EMPTY_VALIDATOR).build();
    static PropertyDescriptor SERVICE = new PropertyDescriptor.Builder().name("Service").required(false).identifiesControllerService(ControllerService.class).build();
    static PropertyDescriptor DEPRECATED = new PropertyDescriptor.Builder().name("Deprecated").required(false).addValidator(Validator.VALID).defaultValue("Deprecated Value").build();
    static Relationship REL_ODD = new Relationship.Builder().name("odd").build();
    static Relationship REL_EVEN = new Relationship.Builder().name("even").build();
    static Relationship REL_BROKEN = new Relationship.Builder().name("broken").build();
    private static final Set<Relationship> relationships = Set.of(REL_ODD, REL_EVEN, REL_BROKEN);
    private static final List<PropertyDescriptor> properties = List.of(INGEST, ATTRIBUTE_NAME, ATTRIBUTE_VALUE, SERVICE, DEPRECATED);
    private final AtomicLong counter = new AtomicLong(0L);

    protected List<PropertyDescriptor> getSupportedPropertyDescriptors() {
        return properties;
    }

    public Set<Relationship> getRelationships() {
        return relationships;
    }

    public void migrateProperties(PropertyConfiguration config) {
        config.renameProperty("ingest-data", INGEST.getName());
        config.renameProperty("attr-to-add", ATTRIBUTE_NAME.getName());
        config.renameProperty("attr-value", ATTRIBUTE_VALUE.getName());
        config.renameProperty("never-existed", "still-doesnt-exist");
        config.setProperty("New Property", config.getPropertyValue(INGEST).orElse("New Value"));
        String ignoredValue = config.getPropertyValue("ignored").orElse(null);
        config.removeProperty("ignored");
        if (config.hasProperty("Deprecated")) {
            config.setProperty("Deprecated Found", "true");
        }
        if (ignoredValue != null && ignoredValue.matches("\\d+")) {
            String serviceId = config.createControllerService(MigrationService.class.getName(), Map.of("Start", ignoredValue));
            config.setProperty(SERVICE, serviceId);
        }
    }

    public void migrateRelationships(RelationshipConfiguration config) {
        config.renameRelationship("failure", REL_BROKEN.getName());
        config.splitRelationship("success", REL_ODD.getName(), new String[]{REL_EVEN.getName()});
    }

    public void onTrigger(ProcessContext context, ProcessSession session) throws ProcessException {
        long count;
        FlowFile flowFile = session.get();
        if (flowFile == null) {
            return;
        }
        String attributeValue = context.getProperty(ATTRIBUTE_VALUE).getValue();
        if (attributeValue != null) {
            String attributeName = context.getProperty(ATTRIBUTE_NAME).getValue();
            flowFile = session.putAttribute(flowFile, attributeName, attributeValue);
        }
        Relationship relationship = (count = this.counter.getAndIncrement()) % 2L == 0L ? REL_EVEN : REL_ODD;
        session.transfer(flowFile, relationship);
    }
}

