/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.admin.service;

import jakarta.annotation.Nullable;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import jetbrains.exodus.entitystore.Entity;
import jetbrains.exodus.entitystore.EntityId;
import jetbrains.exodus.entitystore.EntityIterable;
import jetbrains.exodus.entitystore.PersistentEntityStore;
import jetbrains.exodus.entitystore.PersistentEntityStores;
import jetbrains.exodus.entitystore.StoreTransaction;
import jetbrains.exodus.env.Environment;
import jetbrains.exodus.env.EnvironmentConfig;
import jetbrains.exodus.env.Environments;
import org.apache.nifi.action.Action;
import org.apache.nifi.action.Component;
import org.apache.nifi.action.FlowAction;
import org.apache.nifi.action.FlowActionReporter;
import org.apache.nifi.action.FlowChangeAction;
import org.apache.nifi.action.Operation;
import org.apache.nifi.action.component.details.ComponentDetails;
import org.apache.nifi.action.component.details.ExtensionDetails;
import org.apache.nifi.action.component.details.FlowChangeExtensionDetails;
import org.apache.nifi.action.component.details.FlowChangeRemoteProcessGroupDetails;
import org.apache.nifi.action.component.details.RemoteProcessGroupDetails;
import org.apache.nifi.action.details.ActionDetails;
import org.apache.nifi.action.details.ConfigureDetails;
import org.apache.nifi.action.details.ConnectDetails;
import org.apache.nifi.action.details.FlowChangeConfigureDetails;
import org.apache.nifi.action.details.FlowChangeConnectDetails;
import org.apache.nifi.action.details.FlowChangeMoveDetails;
import org.apache.nifi.action.details.FlowChangePurgeDetails;
import org.apache.nifi.action.details.MoveDetails;
import org.apache.nifi.action.details.PurgeDetails;
import org.apache.nifi.admin.action.ActionConverter;
import org.apache.nifi.admin.service.AuditService;
import org.apache.nifi.admin.service.entity.ActionEntity;
import org.apache.nifi.admin.service.entity.ActionLink;
import org.apache.nifi.admin.service.entity.ConfigureDetailsEntity;
import org.apache.nifi.admin.service.entity.ConnectDetailsEntity;
import org.apache.nifi.admin.service.entity.EntityProperty;
import org.apache.nifi.admin.service.entity.EntityType;
import org.apache.nifi.admin.service.entity.MoveDetailsEntity;
import org.apache.nifi.admin.service.entity.PurgeDetailsEntity;
import org.apache.nifi.history.History;
import org.apache.nifi.history.HistoryQuery;
import org.apache.nifi.history.PreviousValue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityStoreAuditService
implements AuditService,
Closeable {
    private static final long FIRST_START_TIME = 0L;
    private static final int PREVIOUS_VALUES_LIMIT = 5;
    private static final String ASCENDING_SORT_ORDER = "ASC";
    private static final int DEFAULT_COUNT = 100;
    private static final String BACKUP_FILE_NAME_FORMAT = "%s.backup.%d";
    private static final Logger logger = LoggerFactory.getLogger(EntityStoreAuditService.class);
    private final PersistentEntityStore entityStore;
    private final Environment environment;
    private final ActionConverter actionConverter;
    @Nullable
    private final FlowActionReporter flowActionReporter;

    public EntityStoreAuditService(File directory, ActionConverter actionConverter, @Nullable FlowActionReporter flowActionReporter) {
        this.environment = this.loadEnvironment(directory);
        this.entityStore = PersistentEntityStores.newInstance((Environment)this.environment);
        logger.info("Environment configured with directory [{}]", (Object)directory);
        this.actionConverter = actionConverter;
        this.flowActionReporter = flowActionReporter;
    }

    @Override
    public void addActions(Collection<Action> actions) {
        Objects.requireNonNull(actions, "Actions required");
        this.entityStore.executeInExclusiveTransaction(storeTransaction -> {
            for (Action action : actions) {
                this.addAction(storeTransaction, action);
            }
            logger.debug("Actions added [{}]", (Object)actions.size());
        });
        if (this.flowActionReporter != null) {
            List<FlowAction> flowActions = actions.stream().map(this.actionConverter::convert).toList();
            this.flowActionReporter.reportFlowActions(flowActions);
        }
    }

    @Override
    public Map<String, List<PreviousValue>> getPreviousValues(String componentId) {
        Objects.requireNonNull(componentId, "Component Identifier required");
        return (Map)this.entityStore.computeInReadonlyTransaction(storeTransaction -> {
            LinkedHashMap previousValuesFound = new LinkedHashMap();
            EntityIterable actionEntities = storeTransaction.find(EntityType.ACTION.getEntityType(), ActionEntity.SOURCE_ID.getProperty(), (Comparable)((Object)componentId));
            for (Entity actionEntity : actionEntities.reverse()) {
                Entity configureDetails = actionEntity.getLink(ActionLink.CONFIGURE_DETAILS.getProperty());
                if (configureDetails == null) continue;
                String name = this.getProperty(configureDetails, ConfigureDetailsEntity.NAME);
                String value = this.getProperty(configureDetails, ConfigureDetailsEntity.VALUE);
                PreviousValue previousValue = new PreviousValue();
                previousValue.setPreviousValue(value);
                previousValue.setUserIdentity(this.getProperty(actionEntity, ActionEntity.USER_IDENTITY));
                previousValue.setTimestamp(this.getDateProperty(actionEntity, ActionEntity.TIMESTAMP));
                List previousValues = (List)previousValuesFound.get(name);
                if (previousValues == null) {
                    ArrayList<PreviousValue> newPreviousValues = new ArrayList<PreviousValue>();
                    newPreviousValues.add(previousValue);
                    previousValuesFound.put(name, newPreviousValues);
                    continue;
                }
                if (previousValues.size() >= 5) continue;
                previousValues.add(previousValue);
            }
            return previousValuesFound;
        });
    }

    @Override
    public void deletePreviousValues(String propertyName, String componentId) {
        Objects.requireNonNull(propertyName, "Property Name required");
        Objects.requireNonNull(componentId, "Component Identifier required");
        this.entityStore.executeInExclusiveTransaction(storeTransaction -> {
            EntityIterable actionEntities = storeTransaction.find(EntityType.ACTION.getEntityType(), ActionEntity.SOURCE_ID.getProperty(), (Comparable)((Object)componentId));
            for (Entity actionEntity : actionEntities) {
                Comparable configureDetailsName;
                Entity configureDetails = actionEntity.getLink(ActionLink.CONFIGURE_DETAILS.getProperty());
                if (configureDetails == null || !propertyName.equals(configureDetailsName = configureDetails.getProperty(ConfigureDetailsEntity.NAME.getProperty()))) continue;
                actionEntity.deleteLinks(ActionLink.CONFIGURE_DETAILS.getProperty());
            }
        });
        logger.info("Component [{}] Previous Property Values deleted", (Object)componentId);
    }

    @Override
    public History getActions(HistoryQuery actionQuery) {
        Objects.requireNonNull(actionQuery, "History Query required");
        return (History)this.entityStore.computeInReadonlyTransaction(storeTransaction -> {
            ArrayList<Action> actionsFound = new ArrayList<Action>();
            EntityIterable entities = this.findActionEntities(actionQuery, storeTransaction);
            int total = Math.toIntExact(entities.size());
            Integer queryOffset = actionQuery.getOffset();
            int skip = Objects.requireNonNullElse(queryOffset, 0);
            Integer queryCount = actionQuery.getCount();
            int limit = Objects.requireNonNullElse(queryCount, 100);
            EntityIterable selected = entities.skip(skip).take(limit);
            for (Entity entity : selected) {
                Action action = this.readAction(entity);
                actionsFound.add(action);
            }
            History history = new History();
            history.setActions(actionsFound);
            history.setTotal(total);
            history.setLastRefreshed(new Date());
            return history;
        });
    }

    @Override
    public History getActions(int firstActionId, int maxActions) {
        return (History)this.entityStore.computeInReadonlyTransaction(storeTransaction -> {
            ArrayList<Action> actions = new ArrayList<Action>();
            int lastActionId = firstActionId + maxActions;
            EntityIterable found = storeTransaction.findIds(EntityType.ACTION.getEntityType(), (long)firstActionId, (long)lastActionId);
            for (Entity entity : found) {
                Action action = this.readAction(entity);
                actions.add(action);
            }
            History history = new History();
            history.setActions(actions);
            history.setLastRefreshed(new Date());
            history.setTotal(actions.size());
            return history;
        });
    }

    @Override
    public Action getAction(Integer actionId) {
        Objects.requireNonNull(actionId, "Action Identifier required");
        return (Action)this.entityStore.computeInReadonlyTransaction(storeTransaction -> {
            EntityIterable found = storeTransaction.findIds(EntityType.ACTION.getEntityType(), (long)actionId.intValue(), (long)actionId.intValue());
            Entity entity = found.getFirst();
            Action action = entity == null ? null : this.readAction(entity);
            return action;
        });
    }

    @Override
    public void purgeActions(Date end, Action purgeAction) {
        Objects.requireNonNull(end, "End date required");
        Objects.requireNonNull(purgeAction, "Purge Action required");
        long endTime = end.getTime();
        this.entityStore.executeInExclusiveTransaction(storeTransaction -> {
            EntityIterable entities = storeTransaction.find(EntityType.ACTION.getEntityType(), ActionEntity.TIMESTAMP.getProperty(), (Comparable)Long.valueOf(0L), (Comparable)Long.valueOf(endTime));
            for (Entity entity : entities) {
                entity.delete();
                for (ActionLink actionLink : ActionLink.values()) {
                    entity.deleteLinks(actionLink.getProperty());
                }
            }
            this.addAction(storeTransaction, purgeAction);
        });
        logger.info("User [{}] Purged Actions with end date [{}]", (Object)purgeAction.getUserIdentity(), (Object)end);
    }

    @Override
    public void close() throws IOException {
        this.entityStore.close();
        this.environment.close();
        logger.info("Environment closed");
    }

    private EntityIterable findActionEntities(HistoryQuery actionQuery, StoreTransaction storeTransaction) {
        EntityIterable filteredEntities;
        EntityIterable sourceEntities;
        Date startDate = actionQuery.getStartDate();
        long startTimestamp = startDate == null ? 0L : startDate.getTime();
        Date endDate = actionQuery.getEndDate();
        long endTimestamp = endDate == null ? System.currentTimeMillis() : endDate.getTime();
        EntityIterable entities = storeTransaction.find(EntityType.ACTION.getEntityType(), ActionEntity.TIMESTAMP.getProperty(), (Comparable)Long.valueOf(startTimestamp), (Comparable)Long.valueOf(endTimestamp));
        String sourceId = actionQuery.getSourceId();
        if (sourceId == null) {
            sourceEntities = entities;
        } else {
            EntityIterable sourceFiltered = storeTransaction.find(EntityType.ACTION.getEntityType(), ActionEntity.SOURCE_ID.getProperty(), (Comparable)((Object)sourceId));
            sourceEntities = entities.intersect(sourceFiltered);
        }
        String userIdentity = actionQuery.getUserIdentity();
        if (userIdentity == null) {
            filteredEntities = sourceEntities;
        } else {
            EntityIterable identityFiltered = storeTransaction.find(EntityType.ACTION.getEntityType(), ActionEntity.USER_IDENTITY.getProperty(), (Comparable)((Object)userIdentity));
            filteredEntities = sourceEntities.intersect(identityFiltered);
        }
        ActionEntity sortEntityProperty = this.getSortEntityProperty(actionQuery);
        boolean ascending = this.isAscending(actionQuery);
        return storeTransaction.sort(EntityType.ACTION.getEntityType(), sortEntityProperty.getProperty(), filteredEntities, ascending);
    }

    private boolean isAscending(HistoryQuery historyQuery) {
        String sortOrder = historyQuery.getSortOrder();
        boolean ascending = sortOrder == null || sortOrder.isEmpty() ? false : ASCENDING_SORT_ORDER.equalsIgnoreCase(sortOrder);
        return ascending;
    }

    private ActionEntity getSortEntityProperty(HistoryQuery historyQuery) {
        ActionEntity sortEntityProperty;
        String sortColumn = historyQuery.getSortColumn();
        if (sortColumn == null || sortColumn.isEmpty()) {
            sortEntityProperty = ActionEntity.TIMESTAMP;
        } else {
            ActionEntity foundActionEntity = null;
            for (ActionEntity actionEntity : ActionEntity.values()) {
                if (!actionEntity.getProperty().equals(sortColumn)) continue;
                foundActionEntity = actionEntity;
                break;
            }
            if (foundActionEntity == null) {
                throw new IllegalArgumentException("Specified Sort Column not supported");
            }
            sortEntityProperty = foundActionEntity;
        }
        return sortEntityProperty;
    }

    private void addAction(StoreTransaction storeTransaction, Action action) {
        Entity actionEntity = storeTransaction.newEntity(EntityType.ACTION.getEntityType());
        actionEntity.setProperty(ActionEntity.TIMESTAMP.getProperty(), (Comparable)Long.valueOf(action.getTimestamp().getTime()));
        actionEntity.setProperty(ActionEntity.USER_IDENTITY.getProperty(), (Comparable)((Object)action.getUserIdentity()));
        actionEntity.setProperty(ActionEntity.SOURCE_ID.getProperty(), (Comparable)((Object)action.getSourceId()));
        actionEntity.setProperty(ActionEntity.SOURCE_NAME.getProperty(), (Comparable)((Object)action.getSourceName()));
        actionEntity.setProperty(ActionEntity.SOURCE_TYPE.getProperty(), (Comparable)((Object)action.getSourceType().name()));
        actionEntity.setProperty(ActionEntity.OPERATION.getProperty(), (Comparable)((Object)action.getOperation().name()));
        ComponentDetails componentDetails = action.getComponentDetails();
        this.addComponentDetails(actionEntity, componentDetails);
        ActionDetails actionDetails = action.getActionDetails();
        this.addActionDetails(storeTransaction, actionEntity, actionDetails);
    }

    private void addComponentDetails(Entity actionEntity, ComponentDetails componentDetails) {
        if (componentDetails instanceof ExtensionDetails) {
            ExtensionDetails extensionDetails = (ExtensionDetails)componentDetails;
            actionEntity.setProperty(ActionEntity.EXTENSION_TYPE.getProperty(), (Comparable)((Object)extensionDetails.getType()));
        } else if (componentDetails instanceof RemoteProcessGroupDetails) {
            RemoteProcessGroupDetails remoteProcessGroupDetails = (RemoteProcessGroupDetails)componentDetails;
            actionEntity.setProperty(ActionEntity.REMOTE_PROCESS_GROUP_URI.getProperty(), (Comparable)((Object)remoteProcessGroupDetails.getUri()));
        }
    }

    private void addActionDetails(StoreTransaction storeTransaction, Entity actionEntity, ActionDetails actionDetails) {
        if (actionDetails instanceof ConnectDetails) {
            ConnectDetails connectDetails = (ConnectDetails)actionDetails;
            this.addConnectDetails(storeTransaction, actionEntity, connectDetails);
        } else if (actionDetails instanceof MoveDetails) {
            MoveDetails moveDetails = (MoveDetails)actionDetails;
            this.addMoveDetails(storeTransaction, actionEntity, moveDetails);
        } else if (actionDetails instanceof ConfigureDetails) {
            ConfigureDetails configureDetails = (ConfigureDetails)actionDetails;
            this.addConfigureDetails(storeTransaction, actionEntity, configureDetails);
        } else if (actionDetails instanceof PurgeDetails) {
            PurgeDetails purgeDetails = (PurgeDetails)actionDetails;
            this.addPurgeDetails(storeTransaction, actionEntity, purgeDetails);
        }
    }

    private void addConnectDetails(StoreTransaction storeTransaction, Entity actionEntity, ConnectDetails connectDetails) {
        Entity connectDetailsEntity = storeTransaction.newEntity(EntityType.CONNECT_DETAILS.getEntityType());
        connectDetailsEntity.setLink(ConnectDetailsEntity.ACTION.getProperty(), actionEntity);
        actionEntity.setLink(ActionLink.CONNECT_DETAILS.getProperty(), connectDetailsEntity);
        connectDetailsEntity.setProperty(ConnectDetailsEntity.SOURCE_ID.getProperty(), (Comparable)((Object)connectDetails.getSourceId()));
        connectDetailsEntity.setProperty(ConnectDetailsEntity.SOURCE_TYPE.getProperty(), (Comparable)((Object)connectDetails.getSourceType().name()));
        if (connectDetails.getSourceName() != null) {
            connectDetailsEntity.setProperty(ConnectDetailsEntity.SOURCE_NAME.getProperty(), (Comparable)((Object)connectDetails.getSourceName()));
        }
        connectDetailsEntity.setProperty(ConnectDetailsEntity.DESTINATION_ID.getProperty(), (Comparable)((Object)connectDetails.getDestinationId()));
        connectDetailsEntity.setProperty(ConnectDetailsEntity.DESTINATION_TYPE.getProperty(), (Comparable)((Object)connectDetails.getDestinationType().name()));
        if (connectDetails.getDestinationName() != null) {
            connectDetailsEntity.setProperty(ConnectDetailsEntity.DESTINATION_NAME.getProperty(), (Comparable)((Object)connectDetails.getDestinationName()));
        }
        if (connectDetails.getRelationship() != null) {
            connectDetailsEntity.setProperty(ConnectDetailsEntity.RELATIONSHIP.getProperty(), (Comparable)((Object)connectDetails.getRelationship()));
        }
    }

    private void addMoveDetails(StoreTransaction storeTransaction, Entity actionEntity, MoveDetails moveDetails) {
        Entity moveDetailsEntity = storeTransaction.newEntity(EntityType.MOVE_DETAILS.getEntityType());
        moveDetailsEntity.setLink(MoveDetailsEntity.ACTION.getProperty(), actionEntity);
        actionEntity.setLink(ActionLink.MOVE_DETAILS.getProperty(), moveDetailsEntity);
        moveDetailsEntity.setProperty(MoveDetailsEntity.GROUP.getProperty(), (Comparable)((Object)moveDetails.getGroup()));
        moveDetailsEntity.setProperty(MoveDetailsEntity.GROUP_ID.getProperty(), (Comparable)((Object)moveDetails.getGroupId()));
        moveDetailsEntity.setProperty(MoveDetailsEntity.PREVIOUS_GROUP.getProperty(), (Comparable)((Object)moveDetails.getPreviousGroup()));
        moveDetailsEntity.setProperty(MoveDetailsEntity.PREVIOUS_GROUP_ID.getProperty(), (Comparable)((Object)moveDetails.getPreviousGroupId()));
    }

    private void addConfigureDetails(StoreTransaction storeTransaction, Entity actionEntity, ConfigureDetails configureDetails) {
        String value;
        Entity configureDetailsEntity = storeTransaction.newEntity(EntityType.CONFIGURE_DETAILS.getEntityType());
        configureDetailsEntity.setLink(MoveDetailsEntity.ACTION.getProperty(), actionEntity);
        actionEntity.setLink(ActionLink.CONFIGURE_DETAILS.getProperty(), configureDetailsEntity);
        configureDetailsEntity.setProperty(ConfigureDetailsEntity.NAME.getProperty(), (Comparable)((Object)configureDetails.getName()));
        String previousValue = configureDetails.getPreviousValue();
        if (previousValue != null) {
            configureDetailsEntity.setProperty(ConfigureDetailsEntity.PREVIOUS_VALUE.getProperty(), (Comparable)((Object)previousValue));
        }
        if ((value = configureDetails.getValue()) != null) {
            configureDetailsEntity.setProperty(ConfigureDetailsEntity.VALUE.getProperty(), (Comparable)((Object)value));
        }
    }

    private void addPurgeDetails(StoreTransaction storeTransaction, Entity actionEntity, PurgeDetails purgeDetails) {
        Entity purgeDetailsEntity = storeTransaction.newEntity(EntityType.PURGE_DETAILS.getEntityType());
        purgeDetailsEntity.setLink(PurgeDetailsEntity.ACTION.getProperty(), actionEntity);
        actionEntity.setLink(ActionLink.PURGE_DETAILS.getProperty(), purgeDetailsEntity);
        purgeDetailsEntity.setProperty(PurgeDetailsEntity.END_DATE.getProperty(), (Comparable)Long.valueOf(purgeDetails.getEndDate().getTime()));
    }

    private Action readAction(Entity entity) {
        Entity moveDetailsEntity;
        Entity connectDetailsEntity;
        Entity configureDetailsEntity;
        Entity purgeDetailsEntity;
        String remoteProgressGroupUri;
        FlowChangeAction action = new FlowChangeAction();
        EntityId entityId = entity.getId();
        int id = Math.toIntExact(entityId.getLocalId());
        action.setId(Integer.valueOf(id));
        action.setUserIdentity(this.getProperty(entity, ActionEntity.USER_IDENTITY));
        action.setSourceId(this.getProperty(entity, ActionEntity.SOURCE_ID));
        action.setSourceName(this.getProperty(entity, ActionEntity.SOURCE_NAME));
        action.setTimestamp(this.getDateProperty(entity, ActionEntity.TIMESTAMP));
        action.setSourceType(this.getEnumProperty(entity, ActionEntity.SOURCE_TYPE, Component.class));
        action.setOperation(this.getEnumProperty(entity, ActionEntity.OPERATION, Operation.class));
        String extensionType = this.getProperty(entity, ActionEntity.EXTENSION_TYPE);
        if (extensionType != null) {
            FlowChangeExtensionDetails extensionDetails = new FlowChangeExtensionDetails();
            extensionDetails.setType(extensionType);
            action.setComponentDetails((ComponentDetails)extensionDetails);
        }
        if ((remoteProgressGroupUri = this.getProperty(entity, ActionEntity.REMOTE_PROCESS_GROUP_URI)) != null) {
            FlowChangeRemoteProcessGroupDetails remoteProcessGroupDetails = new FlowChangeRemoteProcessGroupDetails();
            remoteProcessGroupDetails.setUri(remoteProgressGroupUri);
            action.setComponentDetails((ComponentDetails)remoteProcessGroupDetails);
        }
        if ((purgeDetailsEntity = entity.getLink(ActionLink.PURGE_DETAILS.getProperty())) != null) {
            FlowChangePurgeDetails purgeDetails = new FlowChangePurgeDetails();
            purgeDetails.setEndDate(this.getDateProperty(purgeDetailsEntity, PurgeDetailsEntity.END_DATE));
            action.setActionDetails((ActionDetails)purgeDetails);
        }
        if ((configureDetailsEntity = entity.getLink(ActionLink.CONFIGURE_DETAILS.getProperty())) != null) {
            ConfigureDetails configureDetails = this.getConfigureDetails(configureDetailsEntity);
            action.setActionDetails((ActionDetails)configureDetails);
        }
        if ((connectDetailsEntity = entity.getLink(ActionLink.CONNECT_DETAILS.getProperty())) != null) {
            ConnectDetails connectDetails = this.getConnectDetails(connectDetailsEntity);
            action.setActionDetails((ActionDetails)connectDetails);
        }
        if ((moveDetailsEntity = entity.getLink(ActionLink.MOVE_DETAILS.getProperty())) != null) {
            MoveDetails moveDetails = this.getMoveDetails(moveDetailsEntity);
            action.setActionDetails((ActionDetails)moveDetails);
        }
        return action;
    }

    private ConfigureDetails getConfigureDetails(Entity configureDetailsEntity) {
        FlowChangeConfigureDetails configureDetails = new FlowChangeConfigureDetails();
        configureDetails.setName(this.getProperty(configureDetailsEntity, ConfigureDetailsEntity.NAME));
        configureDetails.setPreviousValue(this.getProperty(configureDetailsEntity, ConfigureDetailsEntity.PREVIOUS_VALUE));
        configureDetails.setValue(this.getProperty(configureDetailsEntity, ConfigureDetailsEntity.VALUE));
        return configureDetails;
    }

    private ConnectDetails getConnectDetails(Entity connectDetailsEntity) {
        FlowChangeConnectDetails connectDetails = new FlowChangeConnectDetails();
        connectDetails.setSourceId(this.getProperty(connectDetailsEntity, ConnectDetailsEntity.SOURCE_ID));
        connectDetails.setSourceName(this.getProperty(connectDetailsEntity, ConnectDetailsEntity.SOURCE_NAME));
        connectDetails.setSourceType(this.getEnumProperty(connectDetailsEntity, ConnectDetailsEntity.SOURCE_TYPE, Component.class));
        connectDetails.setDestinationId(this.getProperty(connectDetailsEntity, ConnectDetailsEntity.DESTINATION_ID));
        connectDetails.setDestinationName(this.getProperty(connectDetailsEntity, ConnectDetailsEntity.DESTINATION_NAME));
        connectDetails.setDestinationType(this.getEnumProperty(connectDetailsEntity, ConnectDetailsEntity.DESTINATION_TYPE, Component.class));
        connectDetails.setRelationship(this.getProperty(connectDetailsEntity, ConnectDetailsEntity.RELATIONSHIP));
        return connectDetails;
    }

    private MoveDetails getMoveDetails(Entity moveDetailsEntity) {
        FlowChangeMoveDetails moveDetails = new FlowChangeMoveDetails();
        moveDetails.setGroup(this.getProperty(moveDetailsEntity, MoveDetailsEntity.GROUP));
        moveDetails.setGroupId(this.getProperty(moveDetailsEntity, MoveDetailsEntity.GROUP_ID));
        moveDetails.setPreviousGroup(this.getProperty(moveDetailsEntity, MoveDetailsEntity.PREVIOUS_GROUP));
        moveDetails.setPreviousGroupId(this.getProperty(moveDetailsEntity, MoveDetailsEntity.PREVIOUS_GROUP_ID));
        return moveDetails;
    }

    private String getProperty(Entity entity, EntityProperty entityProperty) {
        Comparable property = entity.getProperty(entityProperty.getProperty());
        return property == null ? null : property.toString();
    }

    private <T extends Enum<T>> T getEnumProperty(Entity entity, EntityProperty entityProperty, Class<T> enumType) {
        Comparable property = entity.getProperty(entityProperty.getProperty());
        return property == null ? null : (T)Enum.valueOf(enumType, property.toString());
    }

    private Date getDateProperty(Entity entity, EntityProperty entityProperty) {
        Date dateProperty;
        Comparable property = entity.getProperty(entityProperty.getProperty());
        if (property instanceof Long) {
            long milliseconds = (Long)property;
            dateProperty = new Date(milliseconds);
        } else {
            dateProperty = null;
        }
        return dateProperty;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Environment loadEnvironment(File directory) {
        EnvironmentConfig environmentConfig = new EnvironmentConfig();
        try {
            return Environments.newInstance((File)directory, (EnvironmentConfig)environmentConfig);
        }
        catch (Exception e) {
            logger.warn("Environment loading failed with directory [{}]", (Object)directory, (Object)e);
            try (Stream<Path> files = Files.list(directory.toPath());){
                List<Path> environmentFiles = files.filter(x$0 -> Files.isRegularFile(x$0, new LinkOption[0])).toList();
                long now = System.currentTimeMillis();
                Iterator<Path> iterator = environmentFiles.iterator();
                while (iterator.hasNext()) {
                    Path environmentFile = iterator.next();
                    String backupFileName = String.format(BACKUP_FILE_NAME_FORMAT, environmentFile.getFileName().toString(), now);
                    Path backupStoreFile = environmentFile.resolveSibling(backupFileName);
                    try {
                        Files.move(environmentFile, backupStoreFile, StandardCopyOption.REPLACE_EXISTING);
                        logger.warn("Moved Environment file [{}] to [{}]", (Object)environmentFile, (Object)backupStoreFile);
                    }
                    catch (IOException ioe) {
                        throw new UncheckedIOException(String.format("Environment file move failed [%s]", environmentFile), ioe);
                    }
                }
                return Environments.newInstance((File)directory, (EnvironmentConfig)environmentConfig);
            }
            catch (IOException ioe) {
                throw new UncheckedIOException(String.format("Environment directory listing failed [%s]", directory), ioe);
            }
        }
    }
}

