/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.command;

import java.io.File;
import java.io.IOException;
import java.util.Optional;
import org.apache.nifi.minifi.bootstrap.MiNiFiParameters;
import org.apache.nifi.minifi.bootstrap.RunMiNiFi;
import org.apache.nifi.minifi.bootstrap.Status;
import org.apache.nifi.minifi.bootstrap.command.CommandRunner;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.bootstrap.service.CurrentPortProvider;
import org.apache.nifi.minifi.bootstrap.service.GracefulShutdownParameterProvider;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiCommandSender;
import org.apache.nifi.minifi.bootstrap.util.ProcessUtils;

public class StopRunner
implements CommandRunner {
    protected static final String SHUTDOWN_CMD = "SHUTDOWN";
    private final BootstrapFileProvider bootstrapFileProvider;
    private final MiNiFiParameters miNiFiParameters;
    private final MiNiFiCommandSender miNiFiCommandSender;
    private final CurrentPortProvider currentPortProvider;
    private final GracefulShutdownParameterProvider gracefulShutdownParameterProvider;
    private final ProcessUtils processUtils;

    public StopRunner(BootstrapFileProvider bootstrapFileProvider, MiNiFiParameters miNiFiParameters, MiNiFiCommandSender miNiFiCommandSender, CurrentPortProvider currentPortProvider, GracefulShutdownParameterProvider gracefulShutdownParameterProvider, ProcessUtils processUtils) {
        this.bootstrapFileProvider = bootstrapFileProvider;
        this.miNiFiParameters = miNiFiParameters;
        this.miNiFiCommandSender = miNiFiCommandSender;
        this.currentPortProvider = currentPortProvider;
        this.gracefulShutdownParameterProvider = gracefulShutdownParameterProvider;
        this.processUtils = processUtils;
    }

    @Override
    public int runCommand(String[] args) {
        try {
            return this.stop();
        }
        catch (Exception e) {
            RunMiNiFi.DEFAULT_LOGGER.error("Exception happened during stopping MiNiFi", (Throwable)e);
            return Status.ERROR.getStatusCode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int stop() throws IOException {
        Integer currentPort = this.currentPortProvider.getCurrentPort();
        if (currentPort == null) {
            RunMiNiFi.CMD_LOGGER.error("Apache MiNiFi is not currently running");
            return Status.MINIFI_NOT_RUNNING.getStatusCode();
        }
        int status = Status.OK.getStatusCode();
        File lockFile = this.bootstrapFileProvider.getLockFile();
        if (!lockFile.exists()) {
            lockFile.createNewFile();
        }
        long minifiPid = this.miNiFiParameters.getMinifiPid();
        try {
            Optional<String> commandResponse = this.miNiFiCommandSender.sendCommand(SHUTDOWN_CMD, currentPort, new String[0]);
            if (commandResponse.filter(SHUTDOWN_CMD::equals).isPresent()) {
                this.gracefulShutDownMiNiFiProcess(minifiPid);
            } else {
                RunMiNiFi.CMD_LOGGER.error("When sending SHUTDOWN command to MiNiFi, got unexpected response {}", commandResponse.orElse(null));
                status = Status.ERROR.getStatusCode();
            }
        }
        catch (IOException e) {
            RunMiNiFi.CMD_LOGGER.warn("An error has occurred while stopping MiNiFi. Force killing process with pid={}", (Object)minifiPid, (Object)e);
            this.killProcessTree(minifiPid);
        }
        finally {
            if (lockFile.exists() && !lockFile.delete()) {
                RunMiNiFi.CMD_LOGGER.error("Failed to delete lock file {}; this file should be cleaned up manually", (Object)lockFile);
            }
        }
        return status;
    }

    private void gracefulShutDownMiNiFiProcess(long minifiPid) throws IOException {
        RunMiNiFi.CMD_LOGGER.info("Apache MiNiFi has accepted the Shutdown Command and is shutting down now");
        File statusFile = this.bootstrapFileProvider.getStatusFile();
        File pidFile = this.bootstrapFileProvider.getPidFile();
        if (minifiPid != -1L) {
            this.processUtils.shutdownProcess(minifiPid, "MiNiFi has not finished shutting down after {} seconds. Killing process.", this.gracefulShutdownParameterProvider.getGracefulShutdownSeconds());
            if (statusFile.exists() && !statusFile.delete()) {
                RunMiNiFi.CMD_LOGGER.error("Failed to delete status file {}; this file should be cleaned up manually", (Object)statusFile);
            }
            if (pidFile.exists() && !pidFile.delete()) {
                RunMiNiFi.CMD_LOGGER.error("Failed to delete pid file {}; this file should be cleaned up manually", (Object)pidFile);
            }
            RunMiNiFi.CMD_LOGGER.info("MiNiFi has finished shutting down.");
        }
    }

    private void killProcessTree(long minifiPid) throws IOException {
        if (minifiPid == -1L) {
            RunMiNiFi.DEFAULT_LOGGER.error("No PID found for the MiNiFi process, so unable to kill process; The process should be killed manually.");
        } else {
            RunMiNiFi.DEFAULT_LOGGER.error("Will kill the MiNiFi Process with PID {}", (Object)minifiPid);
            this.processUtils.killProcessTree(minifiPid);
        }
    }
}

