/*
 * Decompiled with CFR 0.152.
 */
package org.apache.nifi.minifi.bootstrap.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.security.SecureRandom;
import java.util.Base64;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.lang3.tuple.Triple;
import org.apache.nifi.minifi.bootstrap.configuration.ConfigurationChangeException;
import org.apache.nifi.minifi.bootstrap.service.BootstrapFileProvider;
import org.apache.nifi.minifi.bootstrap.service.MiNiFiExecCommandProvider;
import org.apache.nifi.minifi.bootstrap.util.OrderedProperties;
import org.apache.nifi.minifi.commons.api.MiNiFiProperties;
import org.apache.nifi.minifi.properties.BootstrapProperties;

public class MiNiFiPropertiesGenerator {
    public static final String PROPERTIES_FILE_APACHE_2_0_LICENSE = " Licensed to the Apache Software Foundation (ASF) under one or more\n# contributor license agreements.  See the NOTICE file distributed with\n# this work for additional information regarding copyright ownership.\n# The ASF licenses this file to You under the Apache License, Version 2.0\n# (the \"License\"); you may not use this file except in compliance with\n# the License.  You may obtain a copy of the License at\n#\n#     http://www.apache.org/licenses/LICENSE-2.0\n#\n# Unless required by applicable law or agreed to in writing, software\n# distributed under the License is distributed on an \"AS IS\" BASIS,\n# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\n# See the License for the specific language governing permissions and\n# limitations under the License.\n\n";
    static final List<Triple<String, String, String>> NIFI_PROPERTIES_WITH_DEFAULT_VALUES_AND_COMMENTS = List.of(Triple.of((Object)"nifi.flow.configuration.archive.enabled", (Object)"false", (Object)""), Triple.of((Object)"nifi.flow.configuration.archive.dir", (Object)"./conf/archive/", (Object)""), Triple.of((Object)"nifi.flowcontroller.autoResumeState", (Object)"true", (Object)""), Triple.of((Object)"nifi.flowcontroller.graceful.shutdown.period", (Object)"10 sec", (Object)""), Triple.of((Object)"nifi.flowservice.writedelay.interval", (Object)"500 ms", (Object)""), Triple.of((Object)"nifi.administrative.yield.duration", (Object)"30 sec", (Object)""), Triple.of((Object)"nifi.bored.yield.duration", (Object)"10 millis", (Object)"# If a component has no work to do (is \"bored\"), how long should we wait before checking again for work"), Triple.of((Object)"nifi.login.identity.provider.configuration.file", (Object)"./conf/login-identity-providers.xml", (Object)""), Triple.of((Object)"nifi.ui.banner.text", (Object)"", (Object)""), Triple.of((Object)"nifi.nar.library.directory", (Object)"./lib", (Object)""), Triple.of((Object)"nifi.nar.working.directory", (Object)"./work/nar/", (Object)""), Triple.of((Object)"nifi.nar.library.autoload.directory", (Object)"./extensions", (Object)""), Triple.of((Object)"nifi.state.management.configuration.file", (Object)"./conf/state-management.xml", (Object)"# State Management"), Triple.of((Object)"nifi.state.management.provider.local", (Object)"local-provider", (Object)"# The ID of the local state provider"), Triple.of((Object)"nifi.database.directory", (Object)"./database_repository", (Object)"# H2 Settings"), Triple.of((Object)"nifi.flowfile.repository.implementation", (Object)"org.apache.nifi.controller.repository.WriteAheadFlowFileRepository", (Object)"# FlowFile Repository"), Triple.of((Object)"nifi.flowfile.repository.directory", (Object)"./flowfile_repository", (Object)""), Triple.of((Object)"nifi.flowfile.repository.checkpoint.interval", (Object)"20 secs", (Object)""), Triple.of((Object)"nifi.flowfile.repository.always.sync", (Object)"false", (Object)""), Triple.of((Object)"nifi.swap.manager.implementation", (Object)"org.apache.nifi.controller.FileSystemSwapManager", (Object)""), Triple.of((Object)"nifi.queue.swap.threshold", (Object)"20000", (Object)""), Triple.of((Object)"nifi.content.repository.implementation", (Object)"org.apache.nifi.controller.repository.FileSystemRepository", (Object)"# Content Repository"), Triple.of((Object)"nifi.content.claim.max.appendable.size", (Object)"50 KB", (Object)""), Triple.of((Object)"nifi.content.repository.archive.max.retention.period", (Object)"7 days", (Object)""), Triple.of((Object)"nifi.content.repository.archive.max.usage.percentage", (Object)"50%", (Object)""), Triple.of((Object)"nifi.content.repository.archive.enabled", (Object)"false", (Object)""), Triple.of((Object)"nifi.content.repository.directory..default", (Object)"./content_repository", (Object)""), Triple.of((Object)"nifi.provenance.repository.implementation", (Object)"org.apache.nifi.provenance.NoOpProvenanceRepository", (Object)"# Provenance Repository Properties"), Triple.of((Object)"nifi.provenance.repository.rollover.time", (Object)"", (Object)""), Triple.of((Object)"nifi.provenance.repository.index.shard.size", (Object)"", (Object)""), Triple.of((Object)"nifi.provenance.repository.max.storage.size", (Object)"", (Object)""), Triple.of((Object)"nifi.provenance.repository.max.storage.time", (Object)"", (Object)""), Triple.of((Object)"nifi.components.status.repository.implementation", (Object)"org.apache.nifi.controller.status.history.VolatileComponentStatusRepository", (Object)"# Component Status Repository"), Triple.of((Object)"nifi.components.status.snapshot.frequency", (Object)"1 min", (Object)""), Triple.of((Object)"nifi.web.http.host", (Object)"", (Object)""), Triple.of((Object)"nifi.web.http.port", (Object)"", (Object)""), Triple.of((Object)"nifi.web.https.host", (Object)"", (Object)""), Triple.of((Object)"nifi.web.https.port", (Object)"", (Object)""), Triple.of((Object)"nifi.web.jetty.working.directory", (Object)"./work/jetty", (Object)""), Triple.of((Object)"nifi.web.jetty.threads", (Object)"200", (Object)""), Triple.of((Object)"nifi.security.keystore", (Object)"", (Object)""), Triple.of((Object)"nifi.security.keystoreType", (Object)"", (Object)""), Triple.of((Object)"nifi.security.keystorePasswd", (Object)"", (Object)""), Triple.of((Object)"nifi.security.keyPasswd", (Object)"", (Object)""), Triple.of((Object)"nifi.security.truststore", (Object)"", (Object)""), Triple.of((Object)"nifi.security.truststoreType", (Object)"", (Object)""), Triple.of((Object)"nifi.security.truststorePasswd", (Object)"", (Object)""), Triple.of((Object)"nifi.security.ocsp.responder.url", (Object)"", (Object)""), Triple.of((Object)"nifi.security.ocsp.responder.certificate", (Object)"", (Object)""), Triple.of((Object)"nifi.cluster.is.node", (Object)"false", (Object)""), Triple.of((Object)"nifi.flow.configuration.file", (Object)"./conf/flow.json.gz", (Object)""));
    static final Map<String, String> MINIFI_TO_NIFI_PROPERTY_MAPPING = Map.ofEntries(Map.entry(MiNiFiProperties.NIFI_MINIFI_FLOW_CONFIG.getKey(), "nifi.flow.configuration.file"), Map.entry(MiNiFiProperties.NIFI_MINIFI_SECURITY_KEYSTORE.getKey(), "nifi.security.keystore"), Map.entry(MiNiFiProperties.NIFI_MINIFI_SECURITY_KEYSTORE_TYPE.getKey(), "nifi.security.keystoreType"), Map.entry(MiNiFiProperties.NIFI_MINIFI_SECURITY_KEYSTORE_PASSWD.getKey(), "nifi.security.keystorePasswd"), Map.entry(MiNiFiProperties.NIFI_MINIFI_SECURITY_KEY_PASSWD.getKey(), "nifi.security.keyPasswd"), Map.entry(MiNiFiProperties.NIFI_MINIFI_SECURITY_TRUSTSTORE.getKey(), "nifi.security.truststore"), Map.entry(MiNiFiProperties.NIFI_MINIFI_SECURITY_TRUSTSTORE_TYPE.getKey(), "nifi.security.truststoreType"), Map.entry(MiNiFiProperties.NIFI_MINIFI_SECURITY_TRUSTSTORE_PASSWD.getKey(), "nifi.security.truststorePasswd"));
    static final String DEFAULT_SENSITIVE_PROPERTIES_ENCODING_ALGORITHM = "NIFI_PBKDF2_AES_GCM_256";
    private static final Base64.Encoder KEY_ENCODER = Base64.getEncoder().withoutPadding();
    private static final int SENSITIVE_PROPERTIES_KEY_LENGTH = 24;
    private static final String C2_PROPERTY_PREFIX = "c2.";
    private static final String NIFI_PREFIX = "nifi.";
    public static final String FILE_EXTENSION_DELIMITER = ".";

    public void generateMinifiProperties(String configDirectory, BootstrapProperties bootstrapProperties) throws ConfigurationChangeException {
        String minifiPropertiesFileName = Path.of(MiNiFiExecCommandProvider.getMiNiFiPropertiesPath(bootstrapProperties, new File(configDirectory)), new String[0]).getFileName().toString();
        Path minifiPropertiesFile = Path.of(configDirectory, minifiPropertiesFileName);
        Map<String, String> existingSensitivePropertiesConfiguration = this.extractSensitivePropertiesConfiguration(minifiPropertiesFile);
        OrderedProperties minifiProperties = this.prepareMinifiProperties(bootstrapProperties, existingSensitivePropertiesConfiguration);
        this.persistMinifiProperties(minifiPropertiesFile, minifiProperties);
    }

    private Map<String, String> extractSensitivePropertiesConfiguration(Path minifiPropertiesFile) throws ConfigurationChangeException {
        if (!Files.exists(minifiPropertiesFile, new LinkOption[0])) {
            return Map.of();
        }
        Properties minifiProperties = new Properties();
        try (InputStream inputStream = Files.newInputStream(minifiPropertiesFile, new OpenOption[0]);){
            minifiProperties.load(inputStream);
        }
        catch (IOException e) {
            throw new ConfigurationChangeException("Unable to load MiNiFi properties from " + String.valueOf(minifiPropertiesFile), e);
        }
        return Map.of("nifi.sensitive.props.key", minifiProperties.getProperty("nifi.sensitive.props.key"), "nifi.sensitive.props.algorithm", minifiProperties.getProperty("nifi.sensitive.props.algorithm"));
    }

    private OrderedProperties prepareMinifiProperties(BootstrapProperties bootstrapProperties, Map<String, String> existingSensitivePropertiesConfiguration) {
        OrderedProperties minifiProperties = new OrderedProperties();
        NIFI_PROPERTIES_WITH_DEFAULT_VALUES_AND_COMMENTS.forEach(triple -> minifiProperties.setProperty((String)triple.getLeft(), (String)triple.getMiddle(), (String)triple.getRight()));
        this.getNonBlankPropertiesWithPredicate(bootstrapProperties, MINIFI_TO_NIFI_PROPERTY_MAPPING::containsKey).forEach(entry -> minifiProperties.setProperty(MINIFI_TO_NIFI_PROPERTY_MAPPING.get(entry.getKey()), (String)entry.getValue()));
        this.getSensitiveProperties(bootstrapProperties, existingSensitivePropertiesConfiguration).forEach(entry -> minifiProperties.setProperty((String)entry.getKey(), (String)entry.getValue()));
        this.getNonBlankPropertiesWithPredicate(bootstrapProperties, key -> key.startsWith(C2_PROPERTY_PREFIX)).forEach(entry -> minifiProperties.setProperty((String)entry.getKey(), (String)entry.getValue()));
        this.getNonBlankPropertiesWithPredicate(bootstrapProperties, key -> key.startsWith(NIFI_PREFIX)).forEach(entry -> minifiProperties.setProperty((String)entry.getKey(), (String)entry.getValue()));
        this.bootstrapFileAndLogProperties().forEach(entry -> minifiProperties.setProperty((String)entry.getKey(), (String)entry.getValue()));
        return minifiProperties;
    }

    private List<Pair<String, String>> getNonBlankPropertiesWithPredicate(BootstrapProperties bootstrapProperties, Predicate<String> predicate) {
        return Optional.ofNullable(bootstrapProperties).map(BootstrapProperties::getPropertyKeys).orElseGet(Set::of).stream().filter(predicate).map(key -> Pair.of((Object)key, (Object)bootstrapProperties.getProperty(key))).filter(pair -> StringUtils.isNotBlank((CharSequence)((CharSequence)pair.getValue()))).sorted((o1, o2) -> Comparator.naturalOrder().compare((String)o1.getKey(), (String)o2.getKey())).toList();
    }

    private List<Pair<String, String>> getSensitiveProperties(BootstrapProperties bootstrapProperties, Map<String, String> existingSensitivePropertiesConfiguration) {
        return existingSensitivePropertiesConfiguration.isEmpty() ? List.of(Pair.of((Object)"nifi.sensitive.props.key", (Object)Optional.ofNullable(bootstrapProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SENSITIVE_PROPS_KEY.getKey())).filter(StringUtils::isNotBlank).orElseGet(this::generateSensitivePropertiesKey)), Pair.of((Object)"nifi.sensitive.props.algorithm", (Object)Optional.ofNullable(bootstrapProperties.getProperty(MiNiFiProperties.NIFI_MINIFI_SENSITIVE_PROPS_ALGORITHM.getKey())).filter(StringUtils::isNotBlank).orElse(DEFAULT_SENSITIVE_PROPERTIES_ENCODING_ALGORITHM))) : existingSensitivePropertiesConfiguration.entrySet().stream().map(entry -> Pair.of((Object)((String)entry.getKey()), (Object)((String)entry.getValue()))).toList();
    }

    private String generateSensitivePropertiesKey() {
        SecureRandom secureRandom = new SecureRandom();
        byte[] sensitivePropertiesKeyBinary = new byte[24];
        secureRandom.nextBytes(sensitivePropertiesKeyBinary);
        return KEY_ENCODER.encodeToString(sensitivePropertiesKeyBinary);
    }

    private List<Pair<String, String>> bootstrapFileAndLogProperties() {
        return List.of(Pair.of((Object)"nifi.minifi.bootstrap.file", (Object)BootstrapFileProvider.getBootstrapConfFile().getAbsolutePath()), Pair.of((Object)"nifi.minifi.log.directory", (Object)System.getProperty("org.apache.nifi.minifi.bootstrap.config.log.dir", "./logs").trim()), Pair.of((Object)"nifi.minifi.app.log.file", (Object)String.join((CharSequence)FILE_EXTENSION_DELIMITER, System.getProperty("org.apache.nifi.minifi.bootstrap.config.log.app.file.name", "minifi-app").trim(), System.getProperty("org.apache.nifi.minifi.bootstrap.config.log.app.file.extension", "log").trim())), Pair.of((Object)"nifi.minifi.bootstrap.log.file", (Object)String.join((CharSequence)FILE_EXTENSION_DELIMITER, System.getProperty("org.apache.nifi.minifi.bootstrap.config.log.bootstrap.file.name", "minifi-bootstrap").trim(), System.getProperty("org.apache.nifi.minifi.bootstrap.config.log.bootstrap.file.extension", "log").trim())));
    }

    private void persistMinifiProperties(Path minifiPropertiesFile, OrderedProperties minifiProperties) throws ConfigurationChangeException {
        try (ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
             FileOutputStream fileOutputStream = new FileOutputStream(minifiPropertiesFile.toString());){
            minifiProperties.store((OutputStream)byteArrayOutputStream, PROPERTIES_FILE_APACHE_2_0_LICENSE);
            byteArrayOutputStream.writeTo((OutputStream)fileOutputStream);
        }
        catch (Exception e) {
            throw new ConfigurationChangeException("Failed to write MiNiFi properties to " + String.valueOf(minifiPropertiesFile), e);
        }
    }
}

